/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.dcm4che3.conf.core.api.ConfigurableClass;
import org.dcm4che3.conf.core.api.ConfigurableProperty;
import org.dcm4che3.conf.core.api.LDAP;
import org.dcm4che3.net.ConnectionMonitor;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DicomProtocolHandler;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.net.Listener;
import org.dcm4che3.net.TCPListener;
import org.dcm4che3.net.TCPProtocolHandler;
import org.dcm4che3.net.UDPListener;
import org.dcm4che3.net.UDPProtocolHandler;
import org.dcm4che3.util.Base64;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LDAP(objectClasses={"dicomNetworkConnection", "dcmNetworkConnection"})
@ConfigurableClass
public class Connection
implements Serializable {
    private static final long serialVersionUID = -7814748788035232055L;
    public static final Logger LOG = LoggerFactory.getLogger(Connection.class);
    public static final String NO_TIMEOUT_STR = "0";
    public static final int NO_TIMEOUT = Integer.valueOf("0");
    public static final int SYNCHRONOUS_MODE = 1;
    public static final int NOT_LISTENING = -1;
    public static final int DEF_BACKLOG = 50;
    public static final int DEF_SOCKETDELAY = 50;
    public static final String DEF_BUFFERSIZE_STR = "0";
    public static final int DEF_BUFFERSIZE = Integer.valueOf("0");
    public static final int DEF_MAX_PDU_LENGTH = 16378;
    public static final String TLS_RSA_WITH_NULL_SHA = "SSL_RSA_WITH_NULL_SHA";
    public static final String TLS_RSA_WITH_3DES_EDE_CBC_SHA = "SSL_RSA_WITH_3DES_EDE_CBC_SHA";
    public static final String TLS_RSA_WITH_AES_128_CBC_SHA = "TLS_RSA_WITH_AES_128_CBC_SHA";
    private Device device;
    @ConfigurableProperty(name="cn", label="Name", tags={ConfigurableProperty.Tag.PRIMARY})
    private String commonName;
    @ConfigurableProperty(name="dicomHostname", label="Hostname", tags={ConfigurableProperty.Tag.PRIMARY})
    private String hostname;
    @ConfigurableProperty(name="dcmBindAddress")
    private String bindAddress;
    @ConfigurableProperty(name="dcmClientBindAddress")
    private String clientBindAddress;
    @ConfigurableProperty(name="dcmHTTPProxy")
    private String httpProxy;
    @ConfigurableProperty(name="dicomPort", defaultValue="-1", label="Port", tags={ConfigurableProperty.Tag.PRIMARY})
    private int port = -1;
    @ConfigurableProperty(name="dcmTCPBacklog", defaultValue="50")
    private int backlog = 50;
    @ConfigurableProperty(name="dcmTCPConnectTimeout", defaultValue="0")
    private int connectTimeout;
    @ConfigurableProperty(name="dcmAARQTimeout", defaultValue="0")
    private int requestTimeout;
    @ConfigurableProperty(name="dcmAAACTimeout", defaultValue="0")
    private int acceptTimeout;
    @ConfigurableProperty(name="dcmARRPTimeout", defaultValue="0")
    private int releaseTimeout;
    @ConfigurableProperty(name="dcmResponseTimeout", defaultValue="0")
    private int responseTimeout;
    @ConfigurableProperty(name="dcmRetrieveTimeout", defaultValue="0")
    private int retrieveTimeout;
    @ConfigurableProperty(name="dcmIdleTimeout", defaultValue="0")
    private int idleTimeout;
    @ConfigurableProperty(name="dcmTCPCloseDelay", defaultValue="50")
    private int socketCloseDelay = 50;
    @ConfigurableProperty(name="dcmTCPSendBufferSize", defaultValue="0")
    private int sendBufferSize;
    @ConfigurableProperty(name="dcmTCPReceiveBufferSize", defaultValue="0")
    private int receiveBufferSize;
    @ConfigurableProperty(name="dcmSendPDULength", defaultValue="16378")
    private int sendPDULength = 16378;
    @ConfigurableProperty(name="dcmReceivePDULength", defaultValue="16378")
    private int receivePDULength = 16378;
    @ConfigurableProperty(name="dcmMaxOpsPerformed", defaultValue="1")
    private int maxOpsPerformed = 1;
    @ConfigurableProperty(name="dcmMaxOpsInvoked", defaultValue="1")
    private int maxOpsInvoked = 1;
    @ConfigurableProperty(name="dcmPackPDV", defaultValue="true")
    private boolean packPDV = true;
    @ConfigurableProperty(name="dcmTCPNoDelay", defaultValue="true")
    private boolean tcpNoDelay = true;
    @ConfigurableProperty(name="dcmTLSNeedClientAuth", defaultValue="true")
    private boolean tlsNeedClientAuth = true;
    @ConfigurableProperty(name="dicomTLSCipherSuite")
    private String[] tlsCipherSuites = new String[0];
    @ConfigurableProperty(name="dcmTLSProtocol")
    private String[] tlsProtocols = new String[]{"TLSv1", "SSLv3"};
    @ConfigurableProperty(name="dcmBlacklistedHostname")
    private String[] blacklist = new String[0];
    @ConfigurableProperty(name="dicomInstalled")
    private Boolean connectionInstalled;
    @ConfigurableProperty(name="dcmProtocol", defaultValue="DICOM", label="Protocol", tags={ConfigurableProperty.Tag.PRIMARY})
    private Protocol protocol = Protocol.DICOM;
    private static final EnumMap<Protocol, TCPProtocolHandler> tcpHandlers = new EnumMap(Protocol.class);
    private static final EnumMap<Protocol, UDPProtocolHandler> udpHandlers = new EnumMap(Protocol.class);
    private transient List<InetAddress> blacklistAddrs;
    private transient InetAddress hostAddr;
    private transient InetAddress bindAddr;
    private transient InetAddress clientBindAddr;
    private volatile transient Listener listener;
    private transient boolean rebindNeeded;

    static {
        Connection.registerTCPProtocolHandler(Protocol.DICOM, DicomProtocolHandler.INSTANCE);
    }

    public Connection() {
    }

    public Connection(String string, String string2) {
        this(string, string2, -1);
    }

    public Connection(String string, String string2, int n) {
        this.commonName = string;
        this.hostname = string2;
        this.port = n;
    }

    public static TCPProtocolHandler registerTCPProtocolHandler(Protocol protocol, TCPProtocolHandler tCPProtocolHandler) {
        return tcpHandlers.put(protocol, tCPProtocolHandler);
    }

    public static TCPProtocolHandler unregisterTCPProtocolHandler(Protocol protocol) {
        return tcpHandlers.remove((Object)protocol);
    }

    public static UDPProtocolHandler registerUDPProtocolHandler(Protocol protocol, UDPProtocolHandler uDPProtocolHandler) {
        return udpHandlers.put(protocol, uDPProtocolHandler);
    }

    public static UDPProtocolHandler unregisterUDPProtocolHandler(Protocol protocol) {
        return udpHandlers.remove((Object)protocol);
    }

    public final Device getDevice() {
        return this.device;
    }

    final void setDevice(Device device) {
        if (device != null && this.device != null) {
            throw new IllegalStateException("already owned by " + device);
        }
        this.device = device;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final void setHostname(String string) {
        if (string != null ? string.equals(this.hostname) : this.hostname == null) {
            return;
        }
        this.hostname = string;
        this.needRebind();
    }

    public final String getBindAddress() {
        return this.bindAddress;
    }

    public final void setBindAddress(String string) {
        if (string != null ? string.equals(this.bindAddress) : this.bindAddress == null) {
            return;
        }
        this.bindAddress = string;
        this.bindAddr = null;
        this.needRebind();
    }

    public String getClientBindAddress() {
        return this.clientBindAddress;
    }

    public void setClientBindAddress(String string) {
        if (string != null ? string.equals(this.clientBindAddress) : this.clientBindAddress == null) {
            return;
        }
        this.clientBindAddress = string;
        this.clientBindAddr = null;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        if (protocol == null) {
            throw new NullPointerException();
        }
        if (this.protocol == protocol) {
            return;
        }
        this.protocol = protocol;
        this.needRebind();
    }

    boolean isRebindNeeded() {
        return this.rebindNeeded;
    }

    void needRebind() {
        this.rebindNeeded = true;
    }

    public final String getCommonName() {
        return this.commonName;
    }

    public final void setCommonName(String string) {
        this.commonName = string;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        if (this.port == n) {
            return;
        }
        if ((n <= 0 || n > 65535) && n != -1) {
            throw new IllegalArgumentException("port out of range:" + n);
        }
        this.port = n;
        this.needRebind();
    }

    public final String getHttpProxy() {
        return this.httpProxy;
    }

    public final void setHttpProxy(String string) {
        this.httpProxy = string;
    }

    public final boolean useHttpProxy() {
        return this.httpProxy != null;
    }

    public final boolean isServer() {
        return this.port > 0;
    }

    public final int getBacklog() {
        return this.backlog;
    }

    public final void setBacklog(int n) {
        if (this.backlog == n) {
            return;
        }
        if (n < 1) {
            throw new IllegalArgumentException("backlog: " + n);
        }
        this.backlog = n;
        this.needRebind();
    }

    public final int getConnectTimeout() {
        return this.connectTimeout;
    }

    public final void setConnectTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("timeout: " + n);
        }
        this.connectTimeout = n;
    }

    public final int getRequestTimeout() {
        return this.requestTimeout;
    }

    public final void setRequestTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("timeout: " + n);
        }
        this.requestTimeout = n;
    }

    public final int getAcceptTimeout() {
        return this.acceptTimeout;
    }

    public final void setAcceptTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("timeout: " + n);
        }
        this.acceptTimeout = n;
    }

    public final int getReleaseTimeout() {
        return this.releaseTimeout;
    }

    public final void setReleaseTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("timeout: " + n);
        }
        this.releaseTimeout = n;
    }

    public final int getSocketCloseDelay() {
        return this.socketCloseDelay;
    }

    public final void setSocketCloseDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("delay: " + n);
        }
        this.socketCloseDelay = n;
    }

    public final void setResponseTimeout(int n) {
        this.responseTimeout = n;
    }

    public final int getResponseTimeout() {
        return this.responseTimeout;
    }

    public final int getRetrieveTimeout() {
        return this.retrieveTimeout;
    }

    public final void setRetrieveTimeout(int n) {
        this.retrieveTimeout = n;
    }

    public final int getIdleTimeout() {
        return this.idleTimeout;
    }

    public final void setIdleTimeout(int n) {
        this.idleTimeout = n;
    }

    public String[] getTlsCipherSuites() {
        return this.tlsCipherSuites;
    }

    public void setTlsCipherSuites(String ... stringArray) {
        if (Arrays.equals(this.tlsCipherSuites, stringArray)) {
            return;
        }
        this.tlsCipherSuites = stringArray;
        this.needRebind();
    }

    public final boolean isTls() {
        return this.tlsCipherSuites.length > 0;
    }

    public final String[] getTlsProtocols() {
        return this.tlsProtocols;
    }

    public final void setTlsProtocols(String ... stringArray) {
        if (Arrays.equals(this.tlsProtocols, stringArray)) {
            return;
        }
        this.tlsProtocols = stringArray;
        this.needRebind();
    }

    public final boolean isTlsNeedClientAuth() {
        return this.tlsNeedClientAuth;
    }

    public final void setTlsNeedClientAuth(boolean bl) {
        if (this.tlsNeedClientAuth == bl) {
            return;
        }
        this.tlsNeedClientAuth = bl;
        this.needRebind();
    }

    public final int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public final void setReceiveBufferSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("size: " + n);
        }
        this.receiveBufferSize = n;
    }

    public final int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public final void setSendBufferSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("size: " + n);
        }
        this.sendBufferSize = n;
    }

    public final int getSendPDULength() {
        return this.sendPDULength;
    }

    public final void setSendPDULength(int n) {
        this.sendPDULength = n;
    }

    public final int getReceivePDULength() {
        return this.receivePDULength;
    }

    public final void setReceivePDULength(int n) {
        this.receivePDULength = n;
    }

    public final int getMaxOpsPerformed() {
        return this.maxOpsPerformed;
    }

    public final void setMaxOpsPerformed(int n) {
        this.maxOpsPerformed = n;
    }

    public final int getMaxOpsInvoked() {
        return this.maxOpsInvoked;
    }

    public final void setMaxOpsInvoked(int n) {
        this.maxOpsInvoked = n;
    }

    public final boolean isPackPDV() {
        return this.packPDV;
    }

    public final void setPackPDV(boolean bl) {
        this.packPDV = bl;
    }

    public final boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public final void setTcpNoDelay(boolean bl) {
        this.tcpNoDelay = bl;
    }

    public boolean isInstalled() {
        return this.device != null && this.device.isInstalled() && (this.connectionInstalled == null || this.connectionInstalled != false);
    }

    public Boolean getConnectionInstalled() {
        return this.connectionInstalled;
    }

    public void setConnectionInstalled(Boolean bl) {
        if (this.connectionInstalled == bl) {
            return;
        }
        boolean bl2 = this.isInstalled();
        this.connectionInstalled = bl;
        if (this.isInstalled() != bl2) {
            this.needRebind();
        }
    }

    synchronized void rebind() throws IOException, GeneralSecurityException {
        this.unbind();
        this.bind();
    }

    public final String[] getBlacklist() {
        return this.blacklist;
    }

    public final void setBlacklist(String[] stringArray) {
        this.blacklist = stringArray;
        this.blacklistAddrs = null;
    }

    public String toString() {
        return this.promptTo(new StringBuilder(), "").toString();
    }

    public StringBuilder promptTo(StringBuilder stringBuilder, String string) {
        String string2 = String.valueOf(string) + "  ";
        StringUtils.appendLine(stringBuilder, string, "Connection[cn: ", this.commonName);
        StringUtils.appendLine(stringBuilder, string2, "host: ", this.hostname);
        StringUtils.appendLine(stringBuilder, string2, "port: ", this.port);
        StringUtils.appendLine(stringBuilder, string2, "ciphers: ", Arrays.toString(this.tlsCipherSuites));
        StringUtils.appendLine(stringBuilder, string2, "installed: ", this.getConnectionInstalled());
        return stringBuilder.append(string).append(']');
    }

    void setSocketSendOptions(Socket socket) throws SocketException {
        int n = socket.getSendBufferSize();
        if (this.sendBufferSize == 0) {
            this.sendBufferSize = n;
        } else if (this.sendBufferSize != n) {
            socket.setSendBufferSize(this.sendBufferSize);
            this.sendBufferSize = socket.getSendBufferSize();
        }
        if (socket.getTcpNoDelay() != this.tcpNoDelay) {
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
    }

    private void setReceiveBufferSize(Socket socket) throws SocketException {
        int n = socket.getReceiveBufferSize();
        if (this.receiveBufferSize == 0) {
            this.receiveBufferSize = n;
        } else if (this.receiveBufferSize != n) {
            socket.setReceiveBufferSize(this.receiveBufferSize);
            this.receiveBufferSize = socket.getReceiveBufferSize();
        }
    }

    void setReceiveBufferSize(ServerSocket serverSocket) throws SocketException {
        int n = serverSocket.getReceiveBufferSize();
        if (this.receiveBufferSize == 0) {
            this.receiveBufferSize = n;
        } else if (this.receiveBufferSize != n) {
            serverSocket.setReceiveBufferSize(this.receiveBufferSize);
            this.receiveBufferSize = serverSocket.getReceiveBufferSize();
        }
    }

    public void setReceiveBufferSize(DatagramSocket datagramSocket) throws SocketException {
        int n = datagramSocket.getReceiveBufferSize();
        if (this.receiveBufferSize == 0) {
            this.receiveBufferSize = n;
        } else if (this.receiveBufferSize != n) {
            datagramSocket.setReceiveBufferSize(this.receiveBufferSize);
            this.receiveBufferSize = datagramSocket.getReceiveBufferSize();
        }
    }

    private InetAddress hostAddr() throws UnknownHostException {
        if (this.hostAddr == null && this.hostname != null) {
            this.hostAddr = InetAddress.getByName(this.hostname);
        }
        return this.hostAddr;
    }

    private InetAddress bindAddr() throws UnknownHostException {
        if (this.bindAddress == null) {
            return this.hostAddr();
        }
        if (this.bindAddr == null) {
            this.bindAddr = InetAddress.getByName(this.bindAddress);
        }
        return this.bindAddr;
    }

    private InetAddress clientBindAddr() throws UnknownHostException {
        if (this.clientBindAddress == null) {
            return this.hostAddr();
        }
        if (this.clientBindAddr == null) {
            this.clientBindAddr = InetAddress.getByName(this.clientBindAddress);
        }
        return this.clientBindAddr;
    }

    private List<InetAddress> blacklistAddrs() {
        if (this.blacklistAddrs == null) {
            this.blacklistAddrs = new ArrayList<InetAddress>(this.blacklist.length);
            String[] stringArray = this.blacklist;
            int n = this.blacklist.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                try {
                    this.blacklistAddrs.add(InetAddress.getByName(string));
                }
                catch (UnknownHostException unknownHostException) {
                    LOG.warn("Failed to lookup InetAddress of " + string, (Throwable)unknownHostException);
                }
                ++n2;
            }
        }
        return this.blacklistAddrs;
    }

    public InetSocketAddress getEndPoint() throws UnknownHostException {
        return new InetSocketAddress(this.hostAddr(), this.port);
    }

    public InetSocketAddress getBindPoint() throws UnknownHostException {
        return new InetSocketAddress(this.bindAddr(), this.port);
    }

    public InetSocketAddress getClientBindPoint() throws UnknownHostException {
        return new InetSocketAddress(this.clientBindAddr(), 0);
    }

    private void checkInstalled() {
        if (!this.isInstalled()) {
            throw new IllegalStateException("Not installed");
        }
    }

    private void checkCompatible(Connection connection) throws IncompatibleConnectionException {
        if (!this.isCompatible(connection)) {
            throw new IncompatibleConnectionException(connection.toString());
        }
    }

    public synchronized boolean bind() throws IOException, GeneralSecurityException {
        if (!this.isInstalled() || !this.isServer()) {
            this.rebindNeeded = false;
            return false;
        }
        if (this.device == null) {
            throw new IllegalStateException("Not attached to Device");
        }
        if (this.isListening()) {
            throw new IllegalStateException("Already listening - " + this.listener);
        }
        if (this.protocol.isTCP()) {
            TCPProtocolHandler tCPProtocolHandler = tcpHandlers.get((Object)this.protocol);
            if (tCPProtocolHandler == null) {
                throw new IllegalStateException("No TCP Protocol Handler for protocol " + (Object)((Object)this.protocol));
            }
            this.listener = new TCPListener(this, tCPProtocolHandler);
        } else {
            UDPProtocolHandler uDPProtocolHandler = udpHandlers.get((Object)this.protocol);
            if (uDPProtocolHandler == null) {
                throw new IllegalStateException("No UDP Protocol Handler for protocol " + (Object)((Object)this.protocol));
            }
            this.listener = new UDPListener(this, uDPProtocolHandler);
        }
        this.rebindNeeded = false;
        return true;
    }

    public final boolean isListening() {
        return this.listener != null;
    }

    public boolean isBlackListed(InetAddress inetAddress) {
        return this.blacklistAddrs().contains(inetAddress);
    }

    public synchronized void unbind() {
        Listener listener = this.listener;
        if (listener == null) {
            return;
        }
        this.listener = null;
        try {
            listener.close();
        }
        catch (Throwable throwable) {}
    }

    public Socket connect(Connection connection) throws IOException, IncompatibleConnectionException, GeneralSecurityException {
        this.checkInstalled();
        if (!this.protocol.isTCP()) {
            throw new IllegalStateException("Not a TCP Connection");
        }
        this.checkCompatible(connection);
        InetSocketAddress inetSocketAddress = this.getClientBindPoint();
        String string = connection.getHostname();
        int n = connection.getPort();
        LOG.info("Initiate connection from {} to {}:{}", new Object[]{inetSocketAddress, string, n});
        Socket socket = new Socket();
        ConnectionMonitor connectionMonitor = this.device != null ? this.device.getConnectionMonitor() : null;
        try {
            socket.bind(inetSocketAddress);
            this.setReceiveBufferSize(socket);
            this.setSocketSendOptions(socket);
            String string2 = connection.getHttpProxy();
            if (string2 != null) {
                String string3 = null;
                String[] stringArray = StringUtils.split(string2, '@');
                if (stringArray.length > 1) {
                    string3 = stringArray[0];
                    string2 = stringArray[1];
                }
                int n2 = (stringArray = StringUtils.split(string2, ':')).length > 1 ? Integer.parseInt(stringArray[1]) : 8080;
                socket.connect(new InetSocketAddress(stringArray[0], n2), this.connectTimeout);
                try {
                    this.doProxyHandshake(socket, string, n, string3, this.connectTimeout);
                }
                catch (IOException iOException) {
                    SafeClose.close(socket);
                    throw iOException;
                }
            } else {
                socket.connect(connection.getEndPoint(), this.connectTimeout);
            }
            if (this.isTls()) {
                socket = this.createTLSSocket(socket, connection);
            }
            if (connectionMonitor != null) {
                connectionMonitor.onConnectionEstablished(this, connection, socket);
            }
            LOG.info("Established connection {}", (Object)socket);
            return socket;
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (connectionMonitor != null) {
                connectionMonitor.onConnectionFailed(this, connection, socket, generalSecurityException);
            }
            SafeClose.close(socket);
            throw generalSecurityException;
        }
        catch (IOException iOException) {
            if (connectionMonitor != null) {
                connectionMonitor.onConnectionFailed(this, connection, socket, iOException);
            }
            SafeClose.close(socket);
            throw iOException;
        }
    }

    public DatagramSocket createDatagramSocket() throws IOException {
        this.checkInstalled();
        if (this.protocol.isTCP()) {
            throw new IllegalStateException("Not a UDP Connection");
        }
        DatagramSocket datagramSocket = new DatagramSocket(this.getClientBindPoint());
        int n = datagramSocket.getSendBufferSize();
        if (this.sendBufferSize == 0) {
            this.sendBufferSize = n;
        } else if (this.sendBufferSize != n) {
            datagramSocket.setSendBufferSize(this.sendBufferSize);
            this.sendBufferSize = datagramSocket.getSendBufferSize();
        }
        return datagramSocket;
    }

    public Listener getListener() {
        return this.listener;
    }

    private void doProxyHandshake(Socket socket, String string, int n, String string2, int n2) throws IOException {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("CONNECT ").append(string).append(':').append(n).append(" HTTP/1.1\r\nHost: ").append(string).append(':').append(n);
        if (string2 != null) {
            object2 = string2.getBytes("UTF-8");
            object = new char[(((byte[])object2).length + 2) / 3 * 4];
            Base64.encode((byte[])object2, 0, ((Object)object2).length, (char[])object, 0);
            stringBuilder.append("\r\nProxy-Authorization: basic ").append((char[])object);
        }
        stringBuilder.append("\r\n\r\n");
        object2 = socket.getOutputStream();
        ((OutputStream)object2).write(stringBuilder.toString().getBytes("US-ASCII"));
        ((OutputStream)object2).flush();
        socket.setSoTimeout(n2);
        object = new HTTPResponse(socket).toString();
        socket.setSoTimeout(0);
        if (!((String)object).startsWith("HTTP/1.1 2")) {
            throw new IOException("Unable to tunnel through " + socket + ". Proxy returns \"" + (String)object + '\"');
        }
    }

    private SSLSocket createTLSSocket(Socket socket, Connection connection) throws GeneralSecurityException, IOException {
        SSLContext sSLContext = this.device.sslContext();
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, connection.getHostname(), connection.getPort(), true);
        sSLSocket.setEnabledProtocols(Connection.intersect(connection.tlsProtocols, this.tlsProtocols));
        sSLSocket.setEnabledCipherSuites(Connection.intersect(connection.tlsCipherSuites, this.tlsCipherSuites));
        sSLSocket.startHandshake();
        return sSLSocket;
    }

    public void close(Socket socket) {
        LOG.info("Close connection {}", (Object)socket);
        SafeClose.close(socket);
    }

    public boolean isCompatible(Connection connection) {
        if (connection.protocol != this.protocol) {
            return false;
        }
        if (!this.protocol.isTCP()) {
            return true;
        }
        if (!this.isTls()) {
            return !connection.isTls();
        }
        return this.hasCommon(connection.tlsProtocols, this.tlsProtocols) && this.hasCommon(connection.tlsCipherSuites, this.tlsCipherSuites);
    }

    private boolean hasCommon(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray3[n2];
            String[] stringArray4 = stringArray2;
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String string2 = stringArray4[n4];
                if (string.equals(string2)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private static String[] intersect(String[] stringArray, String[] stringArray2) {
        String[] stringArray3;
        String[] stringArray4 = new String[Math.min(stringArray.length, stringArray2.length)];
        int n = 0;
        String[] stringArray5 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            stringArray3 = stringArray5[n3];
            String[] stringArray6 = stringArray2;
            int n4 = stringArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                String string = stringArray6[n5];
                if (stringArray3.equals(string)) {
                    stringArray4[n++] = stringArray3;
                    break;
                }
                ++n5;
            }
            ++n3;
        }
        if (n == stringArray4.length) {
            return stringArray4;
        }
        stringArray3 = new String[n];
        System.arraycopy(stringArray4, 0, stringArray3, 0, n);
        return stringArray3;
    }

    boolean equalsRDN(Connection connection) {
        return this.commonName != null ? this.commonName.equals(connection.commonName) : connection.commonName == null && this.hostname.equals(connection.hostname) && this.port == connection.port && this.protocol == connection.protocol;
    }

    void reconfigure(Connection connection) {
        this.setCommonName(connection.commonName);
        this.setHostname(connection.hostname);
        this.setPort(connection.port);
        this.setBindAddress(connection.bindAddress);
        this.setClientBindAddress(connection.clientBindAddress);
        this.setProtocol(connection.protocol);
        this.setHttpProxy(connection.httpProxy);
        this.setBacklog(connection.backlog);
        this.setConnectTimeout(connection.connectTimeout);
        this.setRequestTimeout(connection.requestTimeout);
        this.setAcceptTimeout(connection.acceptTimeout);
        this.setReleaseTimeout(connection.releaseTimeout);
        this.setResponseTimeout(connection.responseTimeout);
        this.setRetrieveTimeout(connection.retrieveTimeout);
        this.setIdleTimeout(connection.idleTimeout);
        this.setSocketCloseDelay(connection.socketCloseDelay);
        this.setSendBufferSize(connection.sendBufferSize);
        this.setReceiveBufferSize(connection.receiveBufferSize);
        this.setSendPDULength(connection.sendPDULength);
        this.setReceivePDULength(connection.receivePDULength);
        this.setMaxOpsPerformed(connection.maxOpsPerformed);
        this.setMaxOpsPerformed(connection.maxOpsInvoked);
        this.setPackPDV(connection.packPDV);
        this.setTcpNoDelay(connection.tcpNoDelay);
        this.setTlsNeedClientAuth(connection.tlsNeedClientAuth);
        this.setTlsCipherSuites(connection.tlsCipherSuites);
        this.setTlsProtocols(connection.tlsProtocols);
        this.setBlacklist(connection.blacklist);
        this.setConnectionInstalled(connection.connectionInstalled);
    }

    private static class HTTPResponse
    extends ByteArrayOutputStream {
        private final String rsp;

        public HTTPResponse(Socket socket) throws IOException {
            super(64);
            int n;
            InputStream inputStream = socket.getInputStream();
            boolean bl = false;
            while ((n = inputStream.read()) != -1) {
                this.write(n);
                if (n == 10) {
                    if (bl) {
                        this.rsp = new String(this.buf, 0, this.count, "US-ASCII");
                        return;
                    }
                    bl = true;
                    continue;
                }
                if (n == 13) continue;
                bl = false;
            }
            throw new IOException("Unexpected EOF from " + socket);
        }

        @Override
        public String toString() {
            return this.rsp;
        }
    }

    public static enum Protocol {
        DICOM,
        HL7,
        SYSLOG_TLS,
        SYSLOG_UDP;


        public boolean isTCP() {
            return this != SYSLOG_UDP;
        }

        public boolean isSyslog() {
            return this == SYSLOG_TLS || this == SYSLOG_UDP;
        }
    }
}

