/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net;

import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.dcm4che3.conf.core.api.ConfigurableClass;
import org.dcm4che3.conf.core.api.ConfigurableProperty;
import org.dcm4che3.conf.core.api.LDAP;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.AssociationHandler;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.ConnectionMonitor;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.net.DimseRQHandler;
import org.dcm4che3.net.SSLManagerFactory;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.util.StringUtils;

@LDAP(objectClasses={"dcmDevice", "dicomDevice"}, distinguishingField="dicomDeviceName")
@ConfigurableClass
public class Device
implements Serializable {
    private static final long serialVersionUID = -5816872456184522866L;
    @ConfigurableProperty(name="dicomDeviceName", label="Device name", tags={ConfigurableProperty.Tag.PRIMARY})
    private String deviceName;
    @ConfigurableProperty(name="dicomDescription")
    private String description;
    @ConfigurableProperty(name="dicomManufacturer")
    private String manufacturer;
    @ConfigurableProperty(name="dicomManufacturerModelName")
    private String manufacturerModelName;
    @ConfigurableProperty(name="dicomStationName")
    private String stationName;
    @ConfigurableProperty(name="dicomDeviceSerialNumber")
    private String deviceSerialNumber;
    @ConfigurableProperty(name="dcmTrustStoreURL")
    private String trustStoreURL;
    @ConfigurableProperty(name="dcmTrustStoreType")
    private String trustStoreType;
    @ConfigurableProperty(name="dcmTrustStorePin")
    private String trustStorePin;
    @ConfigurableProperty(name="dcmTrustStorePinProperty")
    private String trustStorePinProperty;
    @ConfigurableProperty(name="dcmKeyStoreURL")
    private String keyStoreURL;
    @ConfigurableProperty(name="dcmKeyStoreType")
    private String keyStoreType;
    @ConfigurableProperty(name="dcmKeyStorePin")
    private String keyStorePin;
    @ConfigurableProperty(name="dcmKeyStorePinProperty")
    private String keyStorePinProperty;
    @ConfigurableProperty(name="dcmKeyStoreKeyPin")
    private String keyStoreKeyPin;
    @ConfigurableProperty(name="dcmKeyStoreKeyPinProperty")
    private String keyStoreKeyPinProperty;
    @ConfigurableProperty(name="dicomIssuerOfPatientID")
    private Issuer issuerOfPatientID;
    @ConfigurableProperty(name="dicomIssuerOfAccessionNumber")
    private Issuer issuerOfAccessionNumber;
    @ConfigurableProperty(name="dicomOrderPlacerIdentifier")
    private Issuer orderPlacerIdentifier;
    @ConfigurableProperty(name="dicomOrderFillerIdentifier")
    private Issuer orderFillerIdentifier;
    @ConfigurableProperty(name="dicomIssuerOfAdmissionID")
    private Issuer issuerOfAdmissionID;
    @ConfigurableProperty(name="dicomIssuerOfServiceEpisodeID")
    private Issuer issuerOfServiceEpisodeID;
    @ConfigurableProperty(name="dicomIssuerOfContainerIdentifier")
    private Issuer issuerOfContainerIdentifier;
    @ConfigurableProperty(name="dicomIssuerOfSpecimenIdentifier")
    private Issuer issuerOfSpecimenIdentifier;
    @ConfigurableProperty(name="dicomSoftwareVersion")
    private String[] softwareVersions = new String[0];
    @ConfigurableProperty(name="dicomPrimaryDeviceType")
    private String[] primaryDeviceTypes = new String[0];
    @ConfigurableProperty(name="dicomInstitutionName")
    private String[] institutionNames = new String[0];
    @ConfigurableProperty(name="dicomInstitutionCode")
    private Code[] institutionCodes = new Code[0];
    @ConfigurableProperty(name="dicomInstitutionAddress")
    private String[] institutionAddresses = new String[0];
    @ConfigurableProperty(name="dicomInstitutionDepartmentName")
    private String[] institutionalDepartmentNames = new String[0];
    @ConfigurableProperty(name="dicomRelatedDeviceReference")
    private String[] relatedDeviceRefs = new String[0];
    @ConfigurableProperty(name="dicomVendorData")
    private byte[][] vendorData = new byte[0][];
    @ConfigurableProperty(name="dcmLimitOpenAssociations")
    private int limitOpenAssociations;
    @ConfigurableProperty(name="dicomInstalled")
    private boolean installed = true;
    @ConfigurableProperty(name="dcmTimeZoneOfDevice")
    private TimeZone timeZoneOfDevice;
    private final LinkedHashMap<String, X509Certificate[]> authorizedNodeCertificates = new LinkedHashMap();
    private final LinkedHashMap<String, X509Certificate[]> thisNodeCertificates = new LinkedHashMap();
    @LDAP(noContainerNode=true)
    @ConfigurableProperty(name="dicomConnection", label="Connections")
    private final List<Connection> connections = new ArrayList<Connection>();
    @LDAP(noContainerNode=true)
    @ConfigurableProperty(name="dicomNetworkAE", label="Application Entities")
    private final Map<String, ApplicationEntity> applicationEntitiesMap = new TreeMap<String, ApplicationEntity>();
    private final Map<Class<? extends DeviceExtension>, DeviceExtension> extensions = new HashMap<Class<? extends DeviceExtension>, DeviceExtension>();
    private transient AssociationHandler associationHandler = new AssociationHandler();
    private transient DimseRQHandler dimseRQHandler;
    private transient ConnectionMonitor connectionMonitor;
    private transient int assocCount = 0;
    private final transient Object assocCountLock = new Object();
    private transient Executor executor;
    private transient ScheduledExecutorService scheduledExecutor;
    private volatile transient SSLContext sslContext;
    private volatile transient KeyManager km;
    private volatile transient TrustManager tm;

    public Device() {
    }

    public Device(String string) {
        this.setDeviceName(string);
    }

    private void checkNotEmpty(String string, String string2) {
        if (string2 != null && string2.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(string) + " cannot be empty");
        }
    }

    public final String getDeviceName() {
        return this.deviceName;
    }

    public final void setDeviceName(String string) {
        this.checkNotEmpty("Device Name", string);
        this.deviceName = string;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public final String getManufacturer() {
        return this.manufacturer;
    }

    public final void setManufacturer(String string) {
        this.manufacturer = string;
    }

    public final String getManufacturerModelName() {
        return this.manufacturerModelName;
    }

    public final void setManufacturerModelName(String string) {
        this.manufacturerModelName = string;
    }

    public final String[] getSoftwareVersions() {
        return this.softwareVersions;
    }

    public final void setSoftwareVersions(String ... stringArray) {
        this.softwareVersions = stringArray;
    }

    public final String getStationName() {
        return this.stationName;
    }

    public final void setStationName(String string) {
        this.stationName = string;
    }

    public final String getDeviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    public final void setDeviceSerialNumber(String string) {
        this.deviceSerialNumber = string;
    }

    public final String[] getPrimaryDeviceTypes() {
        return this.primaryDeviceTypes;
    }

    public void setPrimaryDeviceTypes(String ... stringArray) {
        this.primaryDeviceTypes = stringArray;
    }

    public final String[] getInstitutionNames() {
        return this.institutionNames;
    }

    public void setInstitutionNames(String ... stringArray) {
        this.institutionNames = stringArray;
    }

    public final Code[] getInstitutionCodes() {
        return this.institutionCodes;
    }

    public void setInstitutionCodes(Code ... codeArray) {
        this.institutionCodes = codeArray;
    }

    public final String[] getInstitutionAddresses() {
        return this.institutionAddresses;
    }

    public void setInstitutionAddresses(String ... stringArray) {
        this.institutionAddresses = stringArray;
    }

    public final String[] getInstitutionalDepartmentNames() {
        return this.institutionalDepartmentNames;
    }

    public void setInstitutionalDepartmentNames(String ... stringArray) {
        this.institutionalDepartmentNames = stringArray;
    }

    public final Issuer getIssuerOfPatientID() {
        return this.issuerOfPatientID;
    }

    public final void setIssuerOfPatientID(Issuer issuer) {
        this.issuerOfPatientID = issuer;
    }

    public final Issuer getIssuerOfAccessionNumber() {
        return this.issuerOfAccessionNumber;
    }

    public final void setIssuerOfAccessionNumber(Issuer issuer) {
        this.issuerOfAccessionNumber = issuer;
    }

    public final Issuer getOrderPlacerIdentifier() {
        return this.orderPlacerIdentifier;
    }

    public final void setOrderPlacerIdentifier(Issuer issuer) {
        this.orderPlacerIdentifier = issuer;
    }

    public final Issuer getOrderFillerIdentifier() {
        return this.orderFillerIdentifier;
    }

    public final void setOrderFillerIdentifier(Issuer issuer) {
        this.orderFillerIdentifier = issuer;
    }

    public final Issuer getIssuerOfAdmissionID() {
        return this.issuerOfAdmissionID;
    }

    public final void setIssuerOfAdmissionID(Issuer issuer) {
        this.issuerOfAdmissionID = issuer;
    }

    public final Issuer getIssuerOfServiceEpisodeID() {
        return this.issuerOfServiceEpisodeID;
    }

    public final void setIssuerOfServiceEpisodeID(Issuer issuer) {
        this.issuerOfServiceEpisodeID = issuer;
    }

    public final Issuer getIssuerOfContainerIdentifier() {
        return this.issuerOfContainerIdentifier;
    }

    public final void setIssuerOfContainerIdentifier(Issuer issuer) {
        this.issuerOfContainerIdentifier = issuer;
    }

    public final Issuer getIssuerOfSpecimenIdentifier() {
        return this.issuerOfSpecimenIdentifier;
    }

    public final void setIssuerOfSpecimenIdentifier(Issuer issuer) {
        this.issuerOfSpecimenIdentifier = issuer;
    }

    public X509Certificate[] getAuthorizedNodeCertificates(String string) {
        return this.authorizedNodeCertificates.get(string);
    }

    public void setAuthorizedNodeCertificates(String string, X509Certificate ... x509CertificateArray) {
        this.authorizedNodeCertificates.put(string, x509CertificateArray);
        this.setTrustManager(null);
    }

    public X509Certificate[] removeAuthorizedNodeCertificates(String string) {
        X509Certificate[] x509CertificateArray = (X509Certificate[])this.authorizedNodeCertificates.remove(string);
        this.setTrustManager(null);
        return x509CertificateArray;
    }

    public void removeAllAuthorizedNodeCertificates() {
        this.authorizedNodeCertificates.clear();
        this.setTrustManager(null);
    }

    public X509Certificate[] getAllAuthorizedNodeCertificates() {
        return Device.toArray(this.authorizedNodeCertificates.values());
    }

    public String[] getAuthorizedNodeCertificateRefs() {
        return this.authorizedNodeCertificates.keySet().toArray(StringUtils.EMPTY_STRING);
    }

    public final String getTrustStoreURL() {
        return this.trustStoreURL;
    }

    public final void setTrustStoreURL(String string) {
        this.checkNotEmpty("trustStoreURL", string);
        if (string == null ? this.trustStoreURL == null : string.equals(this.trustStoreURL)) {
            return;
        }
        this.trustStoreURL = string;
        this.setTrustManager(null);
    }

    public final String getTrustStoreType() {
        return this.trustStoreType;
    }

    public final void setTrustStoreType(String string) {
        this.checkNotEmpty("trustStoreType", string);
        this.trustStoreType = string;
    }

    public final String getTrustStorePin() {
        return this.trustStorePin;
    }

    public final void setTrustStorePin(String string) {
        this.checkNotEmpty("trustStorePin", string);
        this.trustStorePin = string;
    }

    public final String getTrustStorePinProperty() {
        return this.trustStorePinProperty;
    }

    public final void setTrustStorePinProperty(String string) {
        this.checkNotEmpty("keyPin", this.keyStoreKeyPin);
        this.trustStorePinProperty = string;
    }

    public X509Certificate[] getThisNodeCertificates(String string) {
        return this.thisNodeCertificates.get(string);
    }

    public void setThisNodeCertificates(String string, X509Certificate ... x509CertificateArray) {
        this.thisNodeCertificates.put(string, x509CertificateArray);
    }

    public X509Certificate[] removeThisNodeCertificates(String string) {
        return (X509Certificate[])this.thisNodeCertificates.remove(string);
    }

    public final String getKeyStoreURL() {
        return this.keyStoreURL;
    }

    public final void setKeyStoreURL(String string) {
        this.checkNotEmpty("keyStoreURL", string);
        if (string == null ? this.keyStoreURL == null : string.equals(this.keyStoreURL)) {
            return;
        }
        this.keyStoreURL = string;
        this.setKeyManager(null);
    }

    public final String getKeyStoreType() {
        return this.keyStoreType;
    }

    public final void setKeyStoreType(String string) {
        this.checkNotEmpty("keyStoreType", this.keyStoreURL);
        this.keyStoreType = string;
    }

    public final String getKeyStorePin() {
        return this.keyStorePin;
    }

    public final void setKeyStorePin(String string) {
        this.checkNotEmpty("keyStorePin", string);
        this.keyStorePin = string;
    }

    public final String getKeyStorePinProperty() {
        return this.keyStorePinProperty;
    }

    public final void setKeyStorePinProperty(String string) {
        this.checkNotEmpty("keyStorePinProperty", string);
        this.keyStorePinProperty = string;
    }

    public final String getKeyStoreKeyPin() {
        return this.keyStoreKeyPin;
    }

    public final void setKeyStoreKeyPin(String string) {
        this.checkNotEmpty("keyStoreKeyPin", string);
        this.keyStoreKeyPin = string;
    }

    public final String getKeyStoreKeyPinProperty() {
        return this.keyStoreKeyPinProperty;
    }

    public final void setKeyStoreKeyPinProperty(String string) {
        this.checkNotEmpty("keyStoreKeyPinProperty", string);
        this.keyStoreKeyPinProperty = string;
    }

    public void removeAllThisNodeCertificates() {
        this.thisNodeCertificates.clear();
    }

    public X509Certificate[] getAllThisNodeCertificates() {
        return Device.toArray(this.thisNodeCertificates.values());
    }

    public String[] getThisNodeCertificateRefs() {
        return this.thisNodeCertificates.keySet().toArray(StringUtils.EMPTY_STRING);
    }

    private static X509Certificate[] toArray(Collection<X509Certificate[]> collection) {
        X509Certificate[] x509CertificateArray2;
        int n = 0;
        for (X509Certificate[] x509CertificateArray2 : collection) {
            n += x509CertificateArray2.length;
        }
        x509CertificateArray2 = new X509Certificate[n];
        int n2 = 0;
        for (X509Certificate[] x509CertificateArray3 : collection) {
            System.arraycopy(x509CertificateArray3, 0, x509CertificateArray2, n2, x509CertificateArray3.length);
            n2 += x509CertificateArray3.length;
        }
        return x509CertificateArray2;
    }

    public final String[] getRelatedDeviceRefs() {
        return this.relatedDeviceRefs;
    }

    public void setRelatedDeviceRefs(String ... stringArray) {
        this.relatedDeviceRefs = stringArray;
    }

    public final byte[][] getVendorData() {
        return this.vendorData;
    }

    public void setVendorData(byte[] ... byArray) {
        this.vendorData = byArray;
    }

    public final boolean isInstalled() {
        return this.installed;
    }

    public final void setInstalled(boolean bl) {
        if (this.installed == bl) {
            return;
        }
        this.installed = bl;
        this.needRebindConnections();
    }

    public void setTimeZoneOfDevice(TimeZone timeZone) {
        this.timeZoneOfDevice = timeZone;
    }

    public TimeZone getTimeZoneOfDevice() {
        return this.timeZoneOfDevice;
    }

    public final void setDimseRQHandler(DimseRQHandler dimseRQHandler) {
        this.dimseRQHandler = dimseRQHandler;
    }

    public final DimseRQHandler getDimseRQHandler() {
        return this.dimseRQHandler;
    }

    public final AssociationHandler getAssociationHandler() {
        return this.associationHandler;
    }

    public void setAssociationHandler(AssociationHandler associationHandler) {
        if (associationHandler == null) {
            throw new NullPointerException();
        }
        this.associationHandler = associationHandler;
    }

    public ConnectionMonitor getConnectionMonitor() {
        return this.connectionMonitor;
    }

    public void setConnectionMonitor(ConnectionMonitor connectionMonitor) {
        this.connectionMonitor = connectionMonitor;
    }

    public void bindConnections() throws IOException, GeneralSecurityException {
        for (Connection connection : this.connections) {
            connection.bind();
        }
    }

    public void rebindConnections() throws IOException, GeneralSecurityException {
        for (Connection connection : this.connections) {
            if (!connection.isRebindNeeded()) continue;
            connection.rebind();
        }
    }

    private void needRebindConnections() {
        for (Connection connection : this.connections) {
            connection.needRebind();
        }
    }

    private void needReconfigureTLS() {
        for (Connection connection : this.connections) {
            if (!connection.isTls()) continue;
            connection.needRebind();
        }
        this.sslContext = null;
    }

    public void unbindConnections() {
        for (Connection connection : this.connections) {
            connection.unbind();
        }
    }

    public final Executor getExecutor() {
        return this.executor;
    }

    public final void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public final ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    public final void setScheduledExecutor(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutor = scheduledExecutorService;
    }

    public void addConnection(Connection connection) {
        connection.setDevice(this);
        this.connections.add(connection);
        connection.needRebind();
    }

    public boolean removeConnection(Connection connection) {
        for (ApplicationEntity serializable : this.applicationEntitiesMap.values()) {
            if (!serializable.getConnections().contains(connection)) continue;
            throw new IllegalStateException(connection + " used by AE: " + serializable.getAETitle());
        }
        for (DeviceExtension deviceExtension : this.extensions.values()) {
            deviceExtension.verifyNotUsed(connection);
        }
        if (!this.connections.remove(connection)) {
            return false;
        }
        connection.setDevice(null);
        connection.unbind();
        return true;
    }

    public List<Connection> listConnections() {
        return Collections.unmodifiableList(this.connections);
    }

    public Connection connectionWithEqualsRDN(Connection connection) {
        for (Connection connection2 : this.connections) {
            if (!connection2.equalsRDN(connection)) continue;
            return connection2;
        }
        return null;
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public void setConnections(List<Connection> list) {
        this.connections.clear();
        for (Connection connection : list) {
            this.addConnection(connection);
        }
    }

    public void setApplicationEntitiesMap(Map<String, ApplicationEntity> map) {
        this.applicationEntitiesMap.clear();
        for (Map.Entry<String, ApplicationEntity> entry : map.entrySet()) {
            this.addApplicationEntity(entry.getValue());
        }
    }

    public Map<String, ApplicationEntity> getApplicationEntitiesMap() {
        return this.applicationEntitiesMap;
    }

    public void addApplicationEntity(ApplicationEntity applicationEntity) {
        applicationEntity.setDevice(this);
        this.applicationEntitiesMap.put(applicationEntity.getAETitle(), applicationEntity);
    }

    public ApplicationEntity removeApplicationEntity(ApplicationEntity applicationEntity) {
        return this.removeApplicationEntity(applicationEntity.getAETitle());
    }

    public ApplicationEntity removeApplicationEntity(String string) {
        ApplicationEntity applicationEntity = this.applicationEntitiesMap.remove(string);
        if (applicationEntity != null) {
            applicationEntity.setDevice(null);
        }
        return applicationEntity;
    }

    public void addDeviceExtension(DeviceExtension deviceExtension) {
        Class<?> clazz = deviceExtension.getClass();
        if (this.extensions.containsKey(clazz)) {
            throw new IllegalStateException("already contains Device Extension:" + clazz);
        }
        deviceExtension.setDevice(this);
        this.extensions.put(clazz, deviceExtension);
    }

    public boolean removeDeviceExtension(DeviceExtension deviceExtension) {
        if (this.extensions.remove(deviceExtension.getClass()) == null) {
            return false;
        }
        deviceExtension.setDevice(null);
        return true;
    }

    public final int getLimitOpenAssociations() {
        return this.limitOpenAssociations;
    }

    public final void setLimitOpenAssociations(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("limit: " + n);
        }
        this.limitOpenAssociations = n;
    }

    public int getNumberOfOpenAssociations() {
        return this.assocCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementNumberOfOpenAssociations() {
        Object object = this.assocCountLock;
        synchronized (object) {
            ++this.assocCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementNumberOfOpenAssociations() {
        Object object = this.assocCountLock;
        synchronized (object) {
            if (--this.assocCount <= 0) {
                this.assocCountLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNoOpenConnections() throws InterruptedException {
        Object object = this.assocCountLock;
        synchronized (object) {
            while (this.assocCount > 0) {
                this.assocCountLock.wait();
            }
        }
    }

    public boolean isLimitOfOpenAssociationsExceeded() {
        return this.limitOpenAssociations > 0 && this.getNumberOfOpenAssociations() > this.limitOpenAssociations;
    }

    public ApplicationEntity getApplicationEntity(String string) {
        ApplicationEntity applicationEntity = this.applicationEntitiesMap.get(string);
        if (applicationEntity == null) {
            applicationEntity = this.applicationEntitiesMap.get("*");
        }
        return applicationEntity;
    }

    public Collection<String> getApplicationAETitles() {
        return this.applicationEntitiesMap.keySet();
    }

    public Collection<ApplicationEntity> getApplicationEntities() {
        return this.applicationEntitiesMap.values();
    }

    public final void setKeyManager(KeyManager keyManager) {
        this.km = keyManager;
        this.needReconfigureTLS();
    }

    public final KeyManager getKeyManager() {
        return this.km;
    }

    private KeyManager km() throws GeneralSecurityException, IOException {
        KeyManager keyManager = this.km;
        if (keyManager != null || this.keyStoreURL == null) {
            return keyManager;
        }
        String string = this.keyStorePin();
        this.km = keyManager = SSLManagerFactory.createKeyManager(this.keyStoreType(), StringUtils.replaceSystemProperties(this.keyStoreURL), this.keyStorePin(), this.keyPin(string));
        return keyManager;
    }

    private String keyStoreType() {
        if (this.keyStoreType == null) {
            throw new IllegalStateException("keyStoreURL requires keyStoreType");
        }
        return this.keyStoreType;
    }

    private String keyStorePin() {
        if (this.keyStorePin != null) {
            return this.keyStorePin;
        }
        if (this.keyStorePinProperty == null) {
            throw new IllegalStateException("keyStoreURL requires keyStorePin or keyStorePinProperty");
        }
        String string = System.getProperty(this.keyStorePinProperty);
        if (string == null) {
            throw new IllegalStateException("No such keyStorePinProperty: " + this.keyStorePinProperty);
        }
        return string;
    }

    private String keyPin(String string) {
        if (this.keyStoreKeyPin != null) {
            return this.keyStoreKeyPin;
        }
        if (this.keyStoreKeyPinProperty == null) {
            return string;
        }
        String string2 = System.getProperty(this.keyStoreKeyPinProperty);
        if (string2 == null) {
            throw new IllegalStateException("No such keyPinProperty: " + this.keyStoreKeyPinProperty);
        }
        return string2;
    }

    public final void setTrustManager(TrustManager trustManager) {
        this.tm = trustManager;
        this.needReconfigureTLS();
    }

    public final TrustManager getTrustManager() {
        return this.tm;
    }

    private TrustManager tm() throws GeneralSecurityException, IOException {
        TrustManager trustManager = this.tm;
        if (trustManager != null || this.trustStoreURL == null && this.authorizedNodeCertificates.isEmpty()) {
            return trustManager;
        }
        trustManager = this.trustStoreURL != null ? SSLManagerFactory.createTrustManager(this.trustStoreType(), StringUtils.replaceSystemProperties(this.trustStoreURL), this.trustStorePin()) : SSLManagerFactory.createTrustManager(this.getAllAuthorizedNodeCertificates());
        this.tm = trustManager;
        return trustManager;
    }

    private String trustStoreType() {
        if (this.trustStoreType == null) {
            throw new IllegalStateException("trustStoreURL requires trustStoreType");
        }
        return this.trustStoreType;
    }

    private String trustStorePin() {
        if (this.trustStorePin != null) {
            return this.trustStorePin;
        }
        if (this.trustStorePinProperty == null) {
            throw new IllegalStateException("trustStoreURL requires trustStorePin or trustStorePinProperty");
        }
        String string = System.getProperty(this.trustStorePinProperty);
        if (string == null) {
            throw new IllegalStateException("No such trustStorePinProperty: " + this.trustStorePinProperty);
        }
        return string;
    }

    SSLContext sslContext() throws GeneralSecurityException, IOException {
        SSLContext sSLContext = this.sslContext;
        if (sSLContext != null) {
            return sSLContext;
        }
        this.sslContext = sSLContext = Device.createSSLContext(this.km(), this.tm());
        return sSLContext;
    }

    private static SSLContext createSSLContext(KeyManager keyManager, TrustManager trustManager) throws GeneralSecurityException {
        TrustManager[] trustManagerArray;
        KeyManager[] keyManagerArray;
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        if (keyManager != null) {
            KeyManager[] keyManagerArray2 = new KeyManager[1];
            keyManagerArray = keyManagerArray2;
            keyManagerArray2[0] = keyManager;
        } else {
            keyManagerArray = null;
        }
        if (trustManager != null) {
            TrustManager[] trustManagerArray2 = new TrustManager[1];
            trustManagerArray = trustManagerArray2;
            trustManagerArray2[0] = trustManager;
        } else {
            trustManagerArray = null;
        }
        sSLContext.init(keyManagerArray, trustManagerArray, null);
        return sSLContext;
    }

    public void execute(Runnable runnable) {
        if (this.executor == null) {
            throw new IllegalStateException("executer not initalized");
        }
        this.executor.execute(runnable);
    }

    public ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        if (this.scheduledExecutor == null) {
            throw new IllegalStateException("scheduled executor service not initalized");
        }
        return this.scheduledExecutor.schedule(runnable, l, timeUnit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        if (this.scheduledExecutor == null) {
            throw new IllegalStateException("scheduled executor service not initalized");
        }
        return this.scheduledExecutor.scheduleAtFixedRate(runnable, l, l2, timeUnit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        if (this.scheduledExecutor == null) {
            throw new IllegalStateException("scheduled executor service not initalized");
        }
        return this.scheduledExecutor.scheduleWithFixedDelay(runnable, l, l2, timeUnit);
    }

    public String toString() {
        return this.promptTo(new StringBuilder(512), "").toString();
    }

    public StringBuilder promptTo(StringBuilder stringBuilder, String string) {
        String string2 = String.valueOf(string) + "  ";
        StringUtils.appendLine(stringBuilder, string, "Device[name: ", this.deviceName);
        StringUtils.appendLine(stringBuilder, string2, "desc: ", this.description);
        StringUtils.appendLine(stringBuilder, string2, "installed: ", this.installed);
        for (Connection serializable : this.connections) {
            serializable.promptTo(stringBuilder, string2).append(StringUtils.LINE_SEPARATOR);
        }
        for (ApplicationEntity applicationEntity : this.applicationEntitiesMap.values()) {
            applicationEntity.promptTo(stringBuilder, string2).append(StringUtils.LINE_SEPARATOR);
        }
        return stringBuilder.append(string).append(']');
    }

    public void reconfigure(Device device) throws IOException, GeneralSecurityException {
        this.setDeviceAttributes(device);
        this.reconfigureConnections(device);
        this.reconfigureApplicationEntities(device);
        this.reconfigureDeviceExtensions(device);
    }

    protected void setDeviceAttributes(Device device) {
        this.setDescription(device.description);
        this.setManufacturer(device.manufacturer);
        this.setManufacturerModelName(device.manufacturerModelName);
        this.setSoftwareVersions(device.softwareVersions);
        this.setStationName(device.stationName);
        this.setDeviceSerialNumber(device.deviceSerialNumber);
        this.setTrustStoreURL(device.trustStoreURL);
        this.setTrustStoreType(device.trustStoreType);
        this.setTrustStorePin(device.trustStorePin);
        this.setKeyStoreURL(device.keyStoreURL);
        this.setKeyStoreType(device.keyStoreType);
        this.setKeyStorePin(device.keyStorePin);
        this.setKeyStoreKeyPin(device.keyStoreKeyPin);
        this.setTimeZoneOfDevice(device.timeZoneOfDevice);
        this.setIssuerOfPatientID(device.issuerOfPatientID);
        this.setIssuerOfAccessionNumber(device.issuerOfAccessionNumber);
        this.setOrderPlacerIdentifier(device.orderPlacerIdentifier);
        this.setOrderFillerIdentifier(device.orderFillerIdentifier);
        this.setIssuerOfAdmissionID(device.issuerOfAdmissionID);
        this.setIssuerOfServiceEpisodeID(device.issuerOfServiceEpisodeID);
        this.setIssuerOfContainerIdentifier(device.issuerOfContainerIdentifier);
        this.setIssuerOfSpecimenIdentifier(device.issuerOfSpecimenIdentifier);
        this.setInstitutionNames(device.institutionNames);
        this.setInstitutionCodes(device.institutionCodes);
        this.setInstitutionAddresses(device.institutionAddresses);
        this.setInstitutionalDepartmentNames(device.institutionalDepartmentNames);
        this.setPrimaryDeviceTypes(device.primaryDeviceTypes);
        this.setRelatedDeviceRefs(device.relatedDeviceRefs);
        this.setAuthorizedNodeCertificates(device.authorizedNodeCertificates);
        this.setThisNodeCertificates(device.thisNodeCertificates);
        this.setVendorData(device.vendorData);
        this.setLimitOpenAssociations(device.limitOpenAssociations);
        this.setInstalled(device.installed);
    }

    private void setAuthorizedNodeCertificates(Map<String, X509Certificate[]> map) {
        if (this.update(this.authorizedNodeCertificates, map)) {
            this.setTrustManager(null);
        }
    }

    private void setThisNodeCertificates(Map<String, X509Certificate[]> map) {
        this.update(this.thisNodeCertificates, map);
    }

    private boolean update(Map<String, X509Certificate[]> map, Map<String, X509Certificate[]> map2) {
        boolean bl = map.keySet().retainAll(map2.keySet());
        for (Map.Entry<String, X509Certificate[]> entry : map2.entrySet()) {
            String string = entry.getKey();
            Object[] objectArray = entry.getValue();
            Object[] objectArray2 = map.get(string);
            if (objectArray2 != null && Arrays.equals(objectArray, objectArray2)) continue;
            map.put(string, (X509Certificate[])objectArray);
            bl = true;
        }
        return bl;
    }

    private void reconfigureConnections(Device device) {
        Iterator<Connection> iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Connection connection = iterator.next();
            if (device.connectionWithEqualsRDN(connection) != null) continue;
            iterator.remove();
            connection.setDevice(null);
            connection.unbind();
        }
        for (Connection connection : device.connections) {
            Connection connection2 = this.connectionWithEqualsRDN(connection);
            if (connection2 == null) {
                connection2 = new Connection();
                this.addConnection(connection2);
            }
            connection2.reconfigure(connection);
        }
    }

    private void reconfigureApplicationEntities(Device device) {
        this.applicationEntitiesMap.keySet().retainAll(device.applicationEntitiesMap.keySet());
        for (ApplicationEntity applicationEntity : device.applicationEntitiesMap.values()) {
            ApplicationEntity applicationEntity2 = this.applicationEntitiesMap.get(applicationEntity.getAETitle());
            if (applicationEntity2 == null) {
                applicationEntity2 = new ApplicationEntity(applicationEntity.getAETitle());
                this.addApplicationEntity(applicationEntity2);
            }
            applicationEntity2.reconfigure(applicationEntity);
        }
    }

    public void reconfigureConnections(List<Connection> list, List<Connection> list2) {
        list.clear();
        for (Connection connection : list2) {
            list.add(this.connectionWithEqualsRDN(connection));
        }
    }

    private void reconfigureDeviceExtensions(Device device) {
        Iterator<Class<? extends DeviceExtension>> object2 = this.extensions.keySet().iterator();
        while (object2.hasNext()) {
            if (device.extensions.containsKey(object2.next())) continue;
            object2.remove();
        }
        for (DeviceExtension deviceExtension : device.extensions.values()) {
            Class<?> clazz = deviceExtension.getClass();
            DeviceExtension deviceExtension2 = this.extensions.get(clazz);
            if (deviceExtension2 == null) {
                try {
                    deviceExtension2 = (DeviceExtension)clazz.newInstance();
                    this.addDeviceExtension(deviceExtension2);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to instantiate " + clazz.getName(), exception);
                }
            }
            deviceExtension2.reconfigure(deviceExtension);
        }
    }

    public Collection<DeviceExtension> listDeviceExtensions() {
        return this.extensions.values();
    }

    public <T extends DeviceExtension> T getDeviceExtension(Class<T> clazz) {
        return (T)this.extensions.get(clazz);
    }

    public <T extends DeviceExtension> T getDeviceExtensionNotNull(Class<T> clazz) {
        T t = this.getDeviceExtension(clazz);
        if (t == null) {
            throw new IllegalStateException("No " + clazz.getName() + " configured for Device: " + this.deviceName);
        }
        return t;
    }

    public Collection<ApplicationEntity> getAEsSupportingTransferCapability(TransferCapability transferCapability, boolean bl) {
        ArrayList<ApplicationEntity> arrayList = new ArrayList<ApplicationEntity>();
        for (ApplicationEntity applicationEntity : this.getApplicationEntities()) {
            if (!applicationEntity.supportsTransferCapability(transferCapability, bl)) continue;
            arrayList.add(applicationEntity);
        }
        return arrayList;
    }
}

