/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.DataWriter;
import org.dcm4che3.net.DataWriterAdapter;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.PDVOutputStream;
import org.dcm4che3.net.pdu.AAbort;
import org.dcm4che3.net.pdu.AAssociateAC;
import org.dcm4che3.net.pdu.AAssociateRJ;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.AAssociateRQAC;
import org.dcm4che3.net.pdu.CommonExtendedNegotiation;
import org.dcm4che3.net.pdu.ExtendedNegotiation;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.pdu.RoleSelection;
import org.dcm4che3.net.pdu.UserIdentityAC;
import org.dcm4che3.net.pdu.UserIdentityRQ;

class PDUEncoder
extends PDVOutputStream {
    private Association as;
    private OutputStream out;
    private byte[] buf = new byte[16384];
    private int pos;
    private int pdvpcid;
    private int pdvcmd;
    private int pdvpos;
    private int maxpdulen;
    private Thread th;
    private Object dimseLock = new Object();

    public PDUEncoder(Association association, OutputStream outputStream) {
        this.as = association;
        this.out = outputStream;
    }

    public void write(AAssociateRQ aAssociateRQ) throws IOException {
        this.encode(aAssociateRQ, 1, 32);
        this.writePDU(this.pos - 6);
    }

    public void write(AAssociateAC aAssociateAC) throws IOException {
        this.encode(aAssociateAC, 2, 33);
        this.writePDU(this.pos - 6);
    }

    public void write(AAssociateRJ aAssociateRJ) throws IOException {
        this.write(3, aAssociateRJ.getResult(), aAssociateRJ.getSource(), aAssociateRJ.getReason());
    }

    public void writeAReleaseRQ() throws IOException {
        this.write(5, 0, 0, 0);
    }

    public void writeAReleaseRP() throws IOException {
        this.write(6, 0, 0, 0);
    }

    public void write(AAbort aAbort) throws IOException {
        this.write(7, 0, aAbort.getSource(), aAbort.getReason());
    }

    private synchronized void write(int n, int n2, int n3, int n4) throws IOException {
        byte[] byArray = new byte[10];
        byArray[0] = (byte)n;
        byArray[5] = 4;
        byArray[7] = (byte)n2;
        byArray[8] = (byte)n3;
        byArray[9] = (byte)n4;
        byte[] byArray2 = byArray;
        this.out.write(byArray2);
        this.out.flush();
    }

    private synchronized void writePDU(int n) throws IOException {
        try {
            this.out.write(this.buf, 0, 6 + n);
            this.out.flush();
        }
        catch (IOException iOException) {
            this.as.onIOException(iOException);
            throw iOException;
        }
        this.pdvpos = 6;
        this.pos = 12;
    }

    private void encode(AAssociateRQAC aAssociateRQAC, int n, int n2) {
        aAssociateRQAC.checkCallingAET();
        aAssociateRQAC.checkCalledAET();
        int n3 = aAssociateRQAC.length();
        if (this.buf.length < 6 + n3) {
            this.buf = new byte[6 + n3];
        }
        this.pos = 0;
        this.put(n);
        this.put(0);
        this.putInt(n3);
        this.putShort(aAssociateRQAC.getProtocolVersion());
        this.put(0);
        this.put(0);
        this.encodeAET(aAssociateRQAC.getCalledAET());
        this.encodeAET(aAssociateRQAC.getCallingAET());
        this.put(aAssociateRQAC.getReservedBytes(), 0, 32);
        this.encodeStringItem(16, aAssociateRQAC.getApplicationContext());
        for (PresentationContext presentationContext : aAssociateRQAC.getPresentationContexts()) {
            this.encode(presentationContext, n2);
        }
        this.encodeUserInfo(aAssociateRQAC);
    }

    private void put(int n) {
        this.buf[this.pos++] = (byte)n;
    }

    private void put(byte[] byArray) {
        this.put(byArray, 0, byArray.length);
    }

    private void put(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.buf, this.pos, n2);
        this.pos += n2;
    }

    private void putShort(int n) {
        this.buf[this.pos++] = (byte)(n >> 8);
        this.buf[this.pos++] = (byte)n;
    }

    private void putInt(int n) {
        this.buf[this.pos++] = (byte)(n >> 24);
        this.buf[this.pos++] = (byte)(n >> 16);
        this.buf[this.pos++] = (byte)(n >> 8);
        this.buf[this.pos++] = (byte)n;
    }

    private void putString(String string) {
        int n = string.length();
        string.getBytes(0, n, this.buf, this.pos);
        this.pos += n;
    }

    private void encode(byte[] byArray) {
        this.putShort(byArray.length);
        this.put(byArray, 0, byArray.length);
    }

    private void encode(String string) {
        this.putShort(string.length());
        this.putString(string);
    }

    private void encodeAET(String string) {
        int n = this.pos + 16;
        this.putString(string);
        while (this.pos < n) {
            this.put(32);
        }
    }

    private void encodeItemHeader(int n, int n2) {
        this.put(n);
        this.put(0);
        this.putShort(n2);
    }

    private void encodeStringItem(int n, String string) {
        if (string == null) {
            return;
        }
        this.encodeItemHeader(n, string.length());
        this.putString(string);
    }

    private void encode(PresentationContext presentationContext, int n) {
        this.encodeItemHeader(n, presentationContext.length());
        this.put(presentationContext.getPCID());
        this.put(0);
        this.put(presentationContext.getResult());
        this.put(0);
        this.encodeStringItem(48, presentationContext.getAbstractSyntax());
        String[] stringArray = presentationContext.getTransferSyntaxes();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            this.encodeStringItem(64, string);
            ++n3;
        }
    }

    private void encodeUserInfo(AAssociateRQAC aAssociateRQAC) {
        this.encodeItemHeader(80, aAssociateRQAC.userInfoLength());
        this.encodeMaxPDULength(aAssociateRQAC.getMaxPDULength());
        this.encodeStringItem(82, aAssociateRQAC.getImplClassUID());
        if (aAssociateRQAC.isAsyncOps()) {
            this.encodeAsyncOpsWindow(aAssociateRQAC);
        }
        for (RoleSelection object : aAssociateRQAC.getRoleSelections()) {
            this.encode(object);
        }
        this.encodeStringItem(85, aAssociateRQAC.getImplVersionName());
        for (ExtendedNegotiation extendedNegotiation : aAssociateRQAC.getExtendedNegotiations()) {
            this.encode(extendedNegotiation);
        }
        for (CommonExtendedNegotiation commonExtendedNegotiation : aAssociateRQAC.getCommonExtendedNegotiations()) {
            this.encode(commonExtendedNegotiation);
        }
        this.encode(aAssociateRQAC.getUserIdentityRQ());
        this.encode(aAssociateRQAC.getUserIdentityAC());
    }

    private void encodeMaxPDULength(int n) {
        this.encodeItemHeader(81, 4);
        this.putInt(n);
    }

    private void encodeAsyncOpsWindow(AAssociateRQAC aAssociateRQAC) {
        this.encodeItemHeader(83, 4);
        this.putShort(aAssociateRQAC.getMaxOpsInvoked());
        this.putShort(aAssociateRQAC.getMaxOpsPerformed());
    }

    private void encode(RoleSelection roleSelection) {
        this.encodeItemHeader(84, roleSelection.length());
        this.encode(roleSelection.getSOPClassUID());
        this.put(roleSelection.isSCU() ? 1 : 0);
        this.put(roleSelection.isSCP() ? 1 : 0);
    }

    private void encode(ExtendedNegotiation extendedNegotiation) {
        this.encodeItemHeader(86, extendedNegotiation.length());
        this.encode(extendedNegotiation.getSOPClassUID());
        this.put(extendedNegotiation.getInformation());
    }

    private void encode(CommonExtendedNegotiation commonExtendedNegotiation) {
        this.encodeItemHeader(87, commonExtendedNegotiation.length());
        this.encode(commonExtendedNegotiation.getSOPClassUID());
        this.encode(commonExtendedNegotiation.getServiceClassUID());
        this.putShort(commonExtendedNegotiation.getRelatedGeneralSOPClassUIDsLength());
        String[] stringArray = commonExtendedNegotiation.getRelatedGeneralSOPClassUIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.encode(string);
            ++n2;
        }
    }

    private void encode(UserIdentityRQ userIdentityRQ) {
        if (userIdentityRQ == null) {
            return;
        }
        this.encodeItemHeader(88, userIdentityRQ.length());
        this.put(userIdentityRQ.getType());
        this.put(userIdentityRQ.isPositiveResponseRequested() ? 1 : 0);
        this.encode(userIdentityRQ.getPrimaryField());
        this.encode(userIdentityRQ.getSecondaryField());
    }

    private void encode(UserIdentityAC userIdentityAC) {
        if (userIdentityAC == null) {
            return;
        }
        this.encodeItemHeader(89, userIdentityAC.length());
        this.encode(userIdentityAC.getServerResponse());
    }

    @Override
    public void write(int n) throws IOException {
        this.checkThread();
        this.flushPDataTF();
        this.put(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkThread();
        int n3 = n;
        int n4 = n2;
        while (n4 > 0) {
            this.flushPDataTF();
            int n5 = Math.min(n4, this.free());
            this.put(byArray, n3, n5);
            n3 += n5;
            n4 -= n5;
        }
    }

    @Override
    public void close() {
        this.checkThread();
        this.encodePDVHeader(2);
    }

    @Override
    public void copyFrom(InputStream inputStream, int n) throws IOException {
        this.checkThread();
        int n2 = n;
        while (n2 > 0) {
            this.flushPDataTF();
            int n3 = inputStream.read(this.buf, this.pos, Math.min(n2, this.free()));
            if (n3 == -1) {
                throw new EOFException();
            }
            this.pos += n3;
            n2 -= n3;
        }
    }

    @Override
    public void copyFrom(InputStream inputStream) throws IOException {
        this.checkThread();
        while (true) {
            this.flushPDataTF();
            int n = inputStream.read(this.buf, this.pos, this.free());
            if (n == -1) {
                return;
            }
            this.pos += n;
        }
    }

    private void checkThread() {
        if (this.th != Thread.currentThread()) {
            throw new IllegalStateException("Entered by wrong thread");
        }
    }

    private int free() {
        return this.maxpdulen + 6 - this.pos;
    }

    private void flushPDataTF() throws IOException {
        if (this.free() > 0) {
            return;
        }
        this.encodePDVHeader(0);
        this.as.writePDataTF();
    }

    private void encodePDVHeader(int n) {
        int n2 = this.pos;
        int n3 = n2 - this.pdvpos - 4;
        this.pos = this.pdvpos;
        this.putInt(n3);
        this.put(this.pdvpcid);
        this.put(this.pdvcmd | n);
        this.pos = n2;
        Association.LOG.trace("{} << PDV[len={}, pcid={}, mch={}]", new Object[]{this.as, n3, this.pdvpcid, this.pdvcmd | n});
    }

    public void writePDataTF() throws IOException {
        int n = this.pos - 6;
        this.pos = 0;
        this.put(4);
        this.put(0);
        this.putInt(n);
        Association.LOG.trace("{} << P-DATA-TF[len={}]", new Object[]{this.as, n});
        this.writePDU(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDIMSE(PresentationContext presentationContext, Attributes attributes, DataWriter dataWriter) throws IOException {
        Object object = this.dimseLock;
        synchronized (object) {
            Object object2;
            int n = presentationContext.getPCID();
            String string = presentationContext.getTransferSyntax();
            if (Dimse.LOG.isInfoEnabled()) {
                object2 = Dimse.valueOf(attributes.getInt(256, -1));
                Dimse.LOG.info("{} << {}", (Object)this.as, (Object)((Dimse)((Object)object2)).toString(attributes, n, string));
                Dimse.LOG.debug("Command:\n{}", (Object)attributes);
                if (dataWriter instanceof DataWriterAdapter) {
                    Dimse.LOG.debug("Dataset:\n{}", (Object)((DataWriterAdapter)dataWriter).getDataset());
                }
            }
            this.th = Thread.currentThread();
            this.maxpdulen = this.as.getMaxPDULengthSend();
            if (this.buf.length < this.maxpdulen + 6) {
                this.buf = new byte[this.maxpdulen + 6];
            }
            this.pdvpcid = n;
            this.pdvcmd = 1;
            object2 = new DicomOutputStream(this, "1.2.840.10008.1.2");
            ((DicomOutputStream)object2).writeCommand(attributes);
            ((DicomOutputStream)object2).close();
            if (dataWriter != null) {
                if (!this.as.isPackPDV()) {
                    this.as.writePDataTF();
                } else {
                    this.pdvpos = this.pos;
                    this.pos += 6;
                }
                this.pdvcmd = 0;
                dataWriter.writeTo(this, string);
                this.close();
            }
            this.as.writePDataTF();
            this.th = null;
        }
    }
}

