/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net;

import java.io.IOException;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.AssociationStateException;
import org.dcm4che3.net.pdu.AAbort;
import org.dcm4che3.net.pdu.AAssociateAC;
import org.dcm4che3.net.pdu.AAssociateRJ;
import org.dcm4che3.net.pdu.AAssociateRQ;

public enum State {
    Sta1("Sta1 - Idle"){

        @Override
        void write(Association association, AAbort aAbort) {
        }

        @Override
        void closeSocket(Association association) {
        }

        @Override
        void closeSocketDelayed(Association association) {
        }
    }
    ,
    Sta2("Sta2 - Transport connection open"){

        @Override
        void onAAssociateRQ(Association association, AAssociateRQ aAssociateRQ) throws IOException {
            association.handle(aAssociateRQ);
        }
    }
    ,
    Sta3("Sta3 - Awaiting local A-ASSOCIATE response primitive"),
    Sta4("Sta4 - Awaiting transport connection opening to complete"),
    Sta5("Sta5 - Awaiting A-ASSOCIATE-AC or A-ASSOCIATE-RJ PDU"){

        @Override
        void onAAssociateAC(Association association, AAssociateAC aAssociateAC) throws IOException {
            association.handle(aAssociateAC);
        }

        @Override
        void onAAssociateRJ(Association association, AAssociateRJ aAssociateRJ) throws IOException {
            association.handle(aAssociateRJ);
        }
    }
    ,
    Sta6("Sta6 - Association established and ready for data transfer"){

        @Override
        void onAReleaseRQ(Association association) throws IOException {
            association.handleAReleaseRQ();
        }

        @Override
        void onPDataTF(Association association) throws IOException {
            association.handlePDataTF();
        }

        @Override
        void writeAReleaseRQ(Association association) throws IOException {
            association.writeAReleaseRQ();
        }

        @Override
        public void writePDataTF(Association association) throws IOException {
            association.doWritePDataTF();
        }
    }
    ,
    Sta7("Sta7 - Awaiting A-RELEASE-RP PDU"){

        @Override
        public void onAReleaseRP(Association association) throws IOException {
            association.handleAReleaseRP();
        }

        @Override
        void onAReleaseRQ(Association association) throws IOException {
            association.handleAReleaseRQCollision();
        }

        @Override
        void onPDataTF(Association association) throws IOException {
            association.handlePDataTF();
        }
    }
    ,
    Sta8("Sta8 - Awaiting local A-RELEASE response primitive"){

        @Override
        public void writePDataTF(Association association) throws IOException {
            association.doWritePDataTF();
        }
    }
    ,
    Sta9("Sta9 - Release collision requestor side; awaiting A-RELEASE response"),
    Sta10("Sta10 - Release collision acceptor side; awaiting A-RELEASE-RP PDU"){

        @Override
        void onAReleaseRP(Association association) throws IOException {
            association.handleAReleaseRPCollision();
        }
    }
    ,
    Sta11("Sta11 - Release collision requestor side; awaiting A-RELEASE-RP PDU"){

        @Override
        void onAReleaseRP(Association association) throws IOException {
            association.handleAReleaseRP();
        }
    }
    ,
    Sta12("Sta12 - Release collision acceptor side; awaiting A-RELEASE response primitive"),
    Sta13("Sta13 - Awaiting Transport Connection Close Indication"){

        @Override
        public void onAReleaseRP(Association association) throws IOException {
        }

        @Override
        void onAReleaseRQ(Association association) throws IOException {
        }

        @Override
        void onPDataTF(Association association) throws IOException {
        }

        @Override
        void write(Association association, AAbort aAbort) {
        }

        @Override
        void closeSocketDelayed(Association association) {
        }
    };

    private String name;

    private State(String string2) {
        this.name = string2;
    }

    public String toString() {
        return this.name;
    }

    void onAAssociateRQ(Association association, AAssociateRQ aAssociateRQ) throws IOException {
        association.unexpectedPDU("A-ASSOCIATE-RQ");
    }

    void onAAssociateAC(Association association, AAssociateAC aAssociateAC) throws IOException {
        association.unexpectedPDU("A-ASSOCIATE-AC");
    }

    void onAAssociateRJ(Association association, AAssociateRJ aAssociateRJ) throws IOException {
        association.unexpectedPDU("A-ASSOCIATE-RJ");
    }

    void onPDataTF(Association association) throws IOException {
        association.unexpectedPDU("P-DATA-TF");
    }

    void onAReleaseRQ(Association association) throws IOException {
        association.unexpectedPDU("A-RELEASE-RQ");
    }

    void onAReleaseRP(Association association) throws IOException {
        association.unexpectedPDU("A-RELEASE-RP");
    }

    void writeAReleaseRQ(Association association) throws IOException {
        throw new AssociationStateException(this);
    }

    void write(Association association, AAbort aAbort) throws IOException {
        association.write(aAbort);
    }

    public void writePDataTF(Association association) throws IOException {
        throw new AssociationStateException(this);
    }

    void closeSocket(Association association) {
        association.doCloseSocket();
    }

    void closeSocketDelayed(Association association) {
        association.doCloseSocketDelayed();
    }

    /* synthetic */ State(String string, int n, String string2, State state) {
        this(string2);
    }
}

