/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net;

import java.io.Serializable;
import org.dcm4che3.conf.core.api.ConfigurableClass;
import org.dcm4che3.conf.core.api.ConfigurableProperty;
import org.dcm4che3.conf.core.api.LDAP;
import org.dcm4che3.net.pdu.ExtendedNegotiation;

@LDAP
@ConfigurableClass
public class StorageOptions
implements Serializable {
    private static final long serialVersionUID = 6911502883119290413L;
    @ConfigurableProperty(name="dcmStorageConformance", enumRepresentation=ConfigurableProperty.EnumRepresentation.ORDINAL, defaultValue="3")
    private LevelOfSupport levelOfSupport = LevelOfSupport.UNSPECIFIED;
    @ConfigurableProperty(name="dcmDigitalSignatureSupport", enumRepresentation=ConfigurableProperty.EnumRepresentation.ORDINAL, defaultValue="0")
    private DigitalSignatureSupport digitalSignatureSupport = DigitalSignatureSupport.UNSPECIFIED;
    @ConfigurableProperty(name="dcmDataElementCoercion", enumRepresentation=ConfigurableProperty.EnumRepresentation.ORDINAL, defaultValue="2")
    private ElementCoercion elementCoercion = ElementCoercion.UNSPECIFIED;

    public StorageOptions() {
        this(LevelOfSupport.UNSPECIFIED, DigitalSignatureSupport.UNSPECIFIED, ElementCoercion.UNSPECIFIED);
    }

    public StorageOptions(LevelOfSupport levelOfSupport, DigitalSignatureSupport digitalSignatureSupport, ElementCoercion elementCoercion) {
        this.levelOfSupport = levelOfSupport;
        this.digitalSignatureSupport = digitalSignatureSupport;
        this.elementCoercion = elementCoercion;
    }

    public final LevelOfSupport getLevelOfSupport() {
        return this.levelOfSupport;
    }

    public final void setLevelOfSupport(LevelOfSupport levelOfSupport) {
        this.levelOfSupport = levelOfSupport;
    }

    public final DigitalSignatureSupport getDigitalSignatureSupport() {
        return this.digitalSignatureSupport;
    }

    public final void setDigitalSignatureSupport(DigitalSignatureSupport digitalSignatureSupport) {
        this.digitalSignatureSupport = digitalSignatureSupport;
    }

    public final ElementCoercion getElementCoercion() {
        return this.elementCoercion;
    }

    public final void setElementCoercion(ElementCoercion elementCoercion) {
        this.elementCoercion = elementCoercion;
    }

    public byte[] toExtendedNegotiationInformation() {
        byte[] byArray = new byte[6];
        byArray[0] = (byte)this.levelOfSupport.ordinal();
        byArray[2] = (byte)this.digitalSignatureSupport.ordinal();
        byArray[4] = (byte)this.elementCoercion.ordinal();
        return byArray;
    }

    public static StorageOptions valueOf(ExtendedNegotiation extendedNegotiation) {
        return new StorageOptions(LevelOfSupport.valueOf(extendedNegotiation.getField(0, (byte)3)), DigitalSignatureSupport.valueOf(extendedNegotiation.getField(2, (byte)0)), ElementCoercion.valueOf(extendedNegotiation.getField(4, (byte)2)));
    }

    public int hashCode() {
        return this.levelOfSupport.hashCode() + this.digitalSignatureSupport.hashCode() + this.elementCoercion.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StorageOptions)) {
            return false;
        }
        StorageOptions storageOptions = (StorageOptions)object;
        return this.levelOfSupport == storageOptions.levelOfSupport && this.digitalSignatureSupport == storageOptions.digitalSignatureSupport && this.elementCoercion == storageOptions.elementCoercion;
    }

    public String toString() {
        return "StorageOptions[levelOfSupport=" + this.levelOfSupport.ordinal() + ", digitalSignatureSupport=" + this.digitalSignatureSupport.ordinal() + ", elementCoercion=" + this.elementCoercion.ordinal() + "]";
    }

    public static enum DigitalSignatureSupport {
        UNSPECIFIED,
        LEVEL_1,
        LEVEL_2,
        LEVEL_3;


        public static DigitalSignatureSupport valueOf(String string) {
            return Enum.valueOf(DigitalSignatureSupport.class, string);
        }
    }

    public static enum ElementCoercion {
        NO,
        YES,
        UNSPECIFIED;


        public static ElementCoercion valueOf(String string) {
            return Enum.valueOf(ElementCoercion.class, string);
        }
    }

    public static enum LevelOfSupport {
        LEVEL_0,
        LEVEL_1,
        LEVEL_2,
        UNSPECIFIED;


        public static LevelOfSupport valueOf(String string) {
            return Enum.valueOf(LevelOfSupport.class, string);
        }
    }
}

