/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dcm4che3.conf.core.api.ConfigurableClass;
import org.dcm4che3.conf.core.api.ConfigurableProperty;
import org.dcm4che3.data.UID;
import org.dcm4che3.net.AEExtension;
import org.dcm4che3.net.DefaultTransferCapabilities;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.net.TransferCapability;

@ConfigurableClass
public class TCGroupConfigAEExtension
extends AEExtension {
    @ConfigurableProperty
    Map<String, TCGroupDetails> scuTCs = new TreeMap<String, TCGroupDetails>();
    @ConfigurableProperty
    Map<String, TCGroupDetails> scpTCs = new TreeMap<String, TCGroupDetails>();

    public TCGroupConfigAEExtension() {
    }

    public TCGroupConfigAEExtension(EnumSet<DefaultGroup> enumSet, EnumSet<DefaultGroup> enumSet2) {
        for (DefaultGroup defaultGroup : enumSet) {
            this.scpTCs.put(defaultGroup.name(), new TCGroupDetails());
        }
        for (DefaultGroup defaultGroup : enumSet2) {
            this.scuTCs.put(defaultGroup.name(), new TCGroupDetails());
        }
    }

    public EnumSet<DefaultGroup> getSupportedDefaultScpGroups() {
        EnumSet<DefaultGroup> enumSet = EnumSet.noneOf(DefaultGroup.class);
        for (Map.Entry<String, TCGroupDetails> entry : this.scpTCs.entrySet()) {
            try {
                DefaultGroup defaultGroup = DefaultGroup.valueOf(entry.getKey());
                enumSet.add(defaultGroup);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return enumSet;
    }

    public Map<String, TCGroupDetails> getScuTCs() {
        return this.scuTCs;
    }

    public void setScuTCs(Map<String, TCGroupDetails> map) {
        this.scuTCs = map;
    }

    public Map<String, TCGroupDetails> getScpTCs() {
        return this.scpTCs;
    }

    public void setScpTCs(Map<String, TCGroupDetails> map) {
        this.scpTCs = map;
    }

    @Override
    public void reconfigure(AEExtension aEExtension) {
        TCGroupConfigAEExtension tCGroupConfigAEExtension = (TCGroupConfigAEExtension)aEExtension;
        this.setScpTCs(tCGroupConfigAEExtension.getScpTCs());
        this.setScuTCs(tCGroupConfigAEExtension.getScuTCs());
    }

    public static List<TransferCapability> getTCsForDefaultGroup(DefaultGroup defaultGroup) {
        switch (defaultGroup) {
            case STORAGE: {
                ArrayList<TransferCapability> arrayList = new ArrayList<TransferCapability>();
                TCGroupConfigAEExtension.allTCToList(arrayList, DefaultTransferCapabilities.IMAGE_CUIDS, null, DefaultTransferCapabilities.IMAGE_TSUIDS);
                TCGroupConfigAEExtension.allTCToList(arrayList, DefaultTransferCapabilities.VIDEO_CUIDS, null, DefaultTransferCapabilities.VIDEO_TSUIDS);
                TCGroupConfigAEExtension.allTCToList(arrayList, DefaultTransferCapabilities.OTHER_CUIDS, null, DefaultTransferCapabilities.OTHER_TSUIDS);
                TCGroupConfigAEExtension.allTCToList(arrayList, new String[]{"1.2.840.10008.5.1.4.33", "1.2.840.10008.1.1"}, null, "1.2.840.10008.1.2");
                return arrayList;
            }
            case QUERY_RETRIEVE: {
                ArrayList<TransferCapability> arrayList = new ArrayList<TransferCapability>();
                TCGroupConfigAEExtension.allTCToList(arrayList, DefaultTransferCapabilities.QUERY_CUIDS, EnumSet.allOf(QueryOption.class), "1.2.840.10008.1.2");
                TCGroupConfigAEExtension.allTCToList(arrayList, DefaultTransferCapabilities.RETRIEVE_CUIDS, EnumSet.of(QueryOption.RELATIONAL), "1.2.840.10008.1.2");
                TCGroupConfigAEExtension.allTCToList(arrayList, new String[]{"1.2.840.10008.5.1.4.1.2.5.3", "1.2.840.10008.1.1"}, null, "1.2.840.10008.1.2");
                return arrayList;
            }
            case PPS: {
                ArrayList<TransferCapability> arrayList = new ArrayList<TransferCapability>();
                TCGroupConfigAEExtension.allTCToList(arrayList, new String[]{"1.2.840.10008.3.1.2.3.3", "1.2.840.10008.1.1"}, null, "1.2.840.10008.1.2");
                return arrayList;
            }
            case STORAGE_COMMITMENT: {
                ArrayList<TransferCapability> arrayList = new ArrayList<TransferCapability>();
                TCGroupConfigAEExtension.allTCToList(arrayList, new String[]{"1.2.840.10008.1.20.1", "1.2.840.10008.1.1"}, null, "1.2.840.10008.1.2");
                return arrayList;
            }
        }
        throw new RuntimeException("Group " + (Object)((Object)defaultGroup) + " is undefined");
    }

    private static void allTCToList(ArrayList<TransferCapability> arrayList, String[] stringArray, EnumSet<QueryOption> enumSet, String ... stringArray2) {
        String[] stringArray3 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray3[n2];
            String string2 = UID.nameOf(string).replace('/', ' ');
            TransferCapability transferCapability = new TransferCapability(string2, string, TransferCapability.Role.SCU, stringArray2);
            transferCapability.setQueryOptions(enumSet);
            arrayList.add(transferCapability);
            ++n2;
        }
    }

    public static enum DefaultGroup {
        STORAGE,
        PPS,
        QUERY_RETRIEVE,
        STORAGE_COMMITMENT;

    }

    @ConfigurableClass
    public static class TCGroupDetails {
        @ConfigurableProperty
        private List<String> excludedTransferSyntaxes = new ArrayList<String>();
        @ConfigurableProperty
        private List<String> excludedTransferCapabilities = new ArrayList<String>();

        public List<String> getExcludedTransferSyntaxes() {
            return this.excludedTransferSyntaxes;
        }

        public void setExcludedTransferSyntaxes(List<String> list) {
            this.excludedTransferSyntaxes = list;
        }

        public List<String> getExcludedTransferCapabilities() {
            return this.excludedTransferCapabilities;
        }

        public void setExcludedTransferCapabilities(List<String> list) {
            this.excludedTransferCapabilities = list;
        }
    }
}

