/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.ConnectionMonitor;
import org.dcm4che3.net.Listener;
import org.dcm4che3.net.TCPProtocolHandler;

class TCPListener
implements Listener {
    private final Connection conn;
    private final TCPProtocolHandler handler;
    private final ServerSocket ss;

    public TCPListener(Connection connection, TCPProtocolHandler tCPProtocolHandler) throws IOException, GeneralSecurityException {
        try {
            this.conn = connection;
            this.handler = tCPProtocolHandler;
            this.ss = connection.isTls() ? this.createTLSServerSocket(connection) : new ServerSocket();
            connection.setReceiveBufferSize(this.ss);
            this.ss.bind(connection.getBindPoint(), connection.getBacklog());
            connection.getDevice().execute(new Runnable(){

                @Override
                public void run() {
                    TCPListener.this.listen();
                }
            });
        }
        catch (IOException iOException) {
            throw new IOException("Unable to start TCPListener on " + connection.getHostname() + ":" + connection.getPort(), iOException);
        }
    }

    private ServerSocket createTLSServerSocket(Connection connection) throws IOException, GeneralSecurityException {
        SSLContext sSLContext = connection.getDevice().sslContext();
        SSLServerSocketFactory sSLServerSocketFactory = sSLContext.getServerSocketFactory();
        SSLServerSocket sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket();
        sSLServerSocket.setEnabledProtocols(connection.getTlsProtocols());
        sSLServerSocket.setEnabledCipherSuites(connection.getTlsCipherSuites());
        sSLServerSocket.setNeedClientAuth(connection.isTlsNeedClientAuth());
        return sSLServerSocket;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listen() {
        SocketAddress socketAddress;
        block12: {
            socketAddress = this.ss.getLocalSocketAddress();
            Connection.LOG.info("Start TCP Listener on {}", (Object)socketAddress);
            try {
                while (!this.ss.isClosed()) {
                    ConnectionMonitor connectionMonitor;
                    Socket socket;
                    block11: {
                        Connection.LOG.debug("Wait for connection on {}", (Object)socketAddress);
                        socket = this.ss.accept();
                        ConnectionMonitor connectionMonitor2 = connectionMonitor = this.conn.getDevice() != null ? this.conn.getDevice().getConnectionMonitor() : null;
                        if (this.conn.isBlackListed(socket.getInetAddress())) {
                            if (connectionMonitor != null) {
                                connectionMonitor.onConnectionRejectedBlacklisted(this.conn, socket);
                            }
                            Connection.LOG.info("Reject blacklisted connection {}", (Object)socket);
                            this.conn.close(socket);
                            continue;
                        }
                        try {
                            this.conn.setSocketSendOptions(socket);
                            if (!(socket instanceof SSLSocket)) break block11;
                            ((SSLSocket)socket).startHandshake();
                        }
                        catch (Throwable throwable) {
                            if (connectionMonitor != null) {
                                connectionMonitor.onConnectionRejected(this.conn, socket, throwable);
                            }
                            Connection.LOG.warn("Reject connection {}:", (Object)socket, (Object)throwable);
                            this.conn.close(socket);
                            continue;
                        }
                    }
                    if (connectionMonitor != null) {
                        connectionMonitor.onConnectionAccepted(this.conn, socket);
                    }
                    Connection.LOG.info("Accept connection {}", (Object)socket);
                    try {
                        this.handler.onAccept(this.conn, socket);
                    }
                    catch (Throwable throwable) {
                        Connection.LOG.warn("Exception on accepted connection {}:", (Object)socket, (Object)throwable);
                        this.conn.close(socket);
                    }
                }
            }
            catch (Throwable throwable) {
                if (this.ss.isClosed()) break block12;
                Connection.LOG.error("Exception on listing on {}:", (Object)socketAddress, (Object)throwable);
            }
        }
        Connection.LOG.info("Stop TCP Listener on {}", (Object)socketAddress);
    }

    @Override
    public SocketAddress getEndPoint() {
        return this.ss.getLocalSocketAddress();
    }

    @Override
    public void close() throws IOException {
        try {
            this.ss.close();
        }
        catch (Throwable throwable) {}
    }
}

