/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EnumSet;
import org.dcm4che3.conf.core.api.ConfigurableClass;
import org.dcm4che3.conf.core.api.ConfigurableProperty;
import org.dcm4che3.conf.core.api.LDAP;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.net.StorageOptions;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.UIDUtils;

@LDAP(objectClasses={"dicomTransferCapability", "dcmTransferCapability"})
@ConfigurableClass
public class TransferCapability
implements Serializable {
    private static final long serialVersionUID = 6386251434418693778L;
    private ApplicationEntity ae;
    @ConfigurableProperty(name="cn")
    private String commonName;
    @ConfigurableProperty(name="dicomSOPClass")
    private String sopClass;
    @ConfigurableProperty(name="dicomTransferRole")
    private Role role;
    @ConfigurableProperty(name="dicomTransferSyntax")
    private String[] transferSyntaxes;
    @LDAP(booleanBasedEnumStorageOptions={"dcmRelationalQueries", "dcmCombinedDateTimeMatching", "dcmFuzzySemanticMatching", "dcmTimezoneQueryAdjustment"}, noContainerNode=true)
    @ConfigurableProperty(name="dcmQueryOptions", enumRepresentation=ConfigurableProperty.EnumRepresentation.ORDINAL)
    private EnumSet<QueryOption> queryOptions;
    @LDAP(noContainerNode=true)
    @ConfigurableProperty(name="dcmStorageOptions")
    private StorageOptions storageOptions;

    public TransferCapability() {
        this(null, "1.2.840.10008.1.1", Role.SCU, "1.2.840.10008.1.2");
    }

    public TransferCapability(String string, String string2, Role role, String ... stringArray) {
        this.setCommonName(string);
        this.setSopClass(string2);
        this.setRole(role);
        this.setTransferSyntaxes(stringArray);
    }

    public void setApplicationEntity(ApplicationEntity applicationEntity) {
        if (applicationEntity != null && this.ae != null) {
            throw new IllegalStateException("already owned by AE " + this.ae.getAETitle());
        }
        this.ae = applicationEntity;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String string) {
        this.commonName = string;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        if (role == null) {
            throw new NullPointerException();
        }
        if (this.role == role) {
            return;
        }
        ApplicationEntity applicationEntity = this.ae;
        if (applicationEntity != null) {
            applicationEntity.removeTransferCapabilityFor(this.sopClass, this.role);
        }
        this.role = role;
        if (applicationEntity != null) {
            applicationEntity.addTransferCapability(this);
        }
    }

    public String getSopClass() {
        return this.sopClass;
    }

    public void setSopClass(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("empty sopClass");
        }
        if (string.equals(this.sopClass)) {
            return;
        }
        ApplicationEntity applicationEntity = this.ae;
        if (applicationEntity != null) {
            applicationEntity.removeTransferCapabilityFor(string, this.role);
        }
        this.sopClass = string;
        if (applicationEntity != null) {
            applicationEntity.addTransferCapability(this);
        }
    }

    public String[] getTransferSyntaxes() {
        return this.transferSyntaxes;
    }

    public void setTransferSyntaxes(String ... stringArray) {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("missing transferSyntax");
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            if (string.isEmpty()) {
                throw new IllegalArgumentException("empty transferSyntax");
            }
            ++n2;
        }
        this.transferSyntaxes = stringArray;
    }

    public boolean containsTransferSyntax(String string) {
        if ("*".equals(this.transferSyntaxes[0])) {
            return true;
        }
        String[] stringArray = this.transferSyntaxes;
        int n = this.transferSyntaxes.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (string.equals(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setQueryOptions(EnumSet<QueryOption> enumSet) {
        this.queryOptions = EnumSet.noneOf(QueryOption.class);
        if (enumSet != null) {
            this.queryOptions.addAll(enumSet);
        }
    }

    public EnumSet<QueryOption> getQueryOptions() {
        return this.queryOptions;
    }

    public void setStorageOptions(StorageOptions storageOptions) {
        this.storageOptions = storageOptions;
    }

    public StorageOptions getStorageOptions() {
        return this.storageOptions;
    }

    public String toString() {
        return this.promptTo(new StringBuilder(512), "").toString();
    }

    public TransferCapability deepCopy() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return (TransferCapability)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    public StringBuilder promptTo(StringBuilder stringBuilder, String string) {
        String string2 = String.valueOf(string) + "  ";
        StringUtils.appendLine(stringBuilder, string, "TransferCapability[cn: ", this.commonName);
        StringUtils.appendLine(stringBuilder, new Object[]{string2, "role: ", this.role});
        stringBuilder.append(string2).append("as: ");
        UIDUtils.promptTo(this.sopClass, stringBuilder).append(StringUtils.LINE_SEPARATOR);
        String[] stringArray = this.transferSyntaxes;
        int n = this.transferSyntaxes.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray[n2];
            stringBuilder.append(string2).append("ts: ");
            UIDUtils.promptTo(string3, stringBuilder).append(StringUtils.LINE_SEPARATOR);
            ++n2;
        }
        if (this.queryOptions != null) {
            stringBuilder.append(string2).append("QueryOptions").append(this.queryOptions).append(StringUtils.LINE_SEPARATOR);
        }
        if (this.storageOptions != null) {
            stringBuilder.append(string2).append(this.storageOptions).append(StringUtils.LINE_SEPARATOR);
        }
        return stringBuilder.append(string).append(']');
    }

    public static enum Role {
        SCU,
        SCP;

    }
}

