/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Listener;
import org.dcm4che3.net.UDPProtocolHandler;

class UDPListener
implements Listener {
    private static final int MAX_PACKAGE_LEN = 65536;
    private final Connection conn;
    private final UDPProtocolHandler handler;
    private final DatagramSocket ds;

    public UDPListener(Connection connection, UDPProtocolHandler uDPProtocolHandler) throws IOException, GeneralSecurityException {
        this.conn = connection;
        this.handler = uDPProtocolHandler;
        try {
            this.ds = new DatagramSocket(connection.getBindPoint());
        }
        catch (BindException bindException) {
            throw new IOException("Cannot start UDP listener on " + connection.getBindPoint().getHostName() + ":" + connection.getBindPoint().getPort(), bindException);
        }
        connection.setReceiveBufferSize(this.ds);
        connection.getDevice().execute(new Runnable(){

            @Override
            public void run() {
                UDPListener.this.listen();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listen() {
        SocketAddress socketAddress;
        block6: {
            socketAddress = this.ds.getLocalSocketAddress();
            Connection.LOG.info("Start UDP listener on {}", (Object)socketAddress);
            byte[] byArray = new byte[65536];
            try {
                while (!this.ds.isClosed()) {
                    Connection.LOG.debug("Wait for UDP datagram package on {}", (Object)socketAddress);
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, 65536);
                    this.ds.receive(datagramPacket);
                    InetAddress inetAddress = datagramPacket.getAddress();
                    if (this.conn.isBlackListed(datagramPacket.getAddress())) {
                        Connection.LOG.info("Ignore UDP datagram package received from blacklisted {}", (Object)inetAddress);
                        continue;
                    }
                    Connection.LOG.info("Received UDP datagram package from {}", (Object)inetAddress);
                    try {
                        this.handler.onReceive(this.conn, datagramPacket);
                    }
                    catch (Throwable throwable) {
                        Connection.LOG.warn("Exception processing UDP received from {}:", (Object)inetAddress, (Object)throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                if (this.ds.isClosed()) break block6;
                Connection.LOG.error("Exception on listing on {}:", (Object)socketAddress, (Object)throwable);
            }
        }
        Connection.LOG.info("Stop UDP listener on {}", (Object)socketAddress);
    }

    @Override
    public SocketAddress getEndPoint() {
        return this.ds.getLocalSocketAddress();
    }

    @Override
    public void close() throws IOException {
        try {
            this.ds.close();
        }
        catch (Throwable throwable) {}
    }
}

