/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.audit;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.AuditSourceIdentification;
import org.dcm4che3.audit.AuditSourceTypeCode;
import org.dcm4che3.conf.core.api.ConfigurableClass;
import org.dcm4che3.conf.core.api.ConfigurableProperty;
import org.dcm4che3.conf.core.api.LDAP;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.net.audit.AuditRecordRepository;
import org.dcm4che3.net.audit.AuditSuppressCriteria;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LDAP(objectClasses={"dcmAuditLogger"})
@ConfigurableClass
public class AuditLogger
extends DeviceExtension {
    private static final long serialVersionUID = 1595714214186063103L;
    private static final int MSG_PROMPT_LEN = 8192;
    private static Logger LOG = LoggerFactory.getLogger(AuditLogger.class);
    public static final String MESSAGE_ID = "DICOM+RFC3881";
    private static final int[] DIGITS_0X = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final int[] DIGITS_X0 = new int[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final byte[] BOM = new byte[]{-17, -69, -65};
    private static final char SYSLOG_VERSION = '1';
    private static final InetAddress localHost = AuditLogger.localHost();
    private static final String processID = AuditLogger.processID();
    private static final Comparator<File> FILE_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File file, File file2) {
            long l = file.lastModified() - file2.lastModified();
            return l < 0L ? -1 : (l > 0L ? 1 : 0);
        }
    };
    private static volatile AuditLogger defaultLogger;
    @ConfigurableProperty(name="dcmAuditRecordRepositoryDeviceReference", label="ARR Device", description="Device which provides the Audit Record Repository to which audit messages are sent", tags={ConfigurableProperty.Tag.PRIMARY}, isReference=true)
    private Device auditRecordRepositoryDevice;
    @ConfigurableProperty(name="dcmAuditFacility", enumRepresentation=ConfigurableProperty.EnumRepresentation.ORDINAL, defaultValue="10")
    private Facility facility = Facility.authpriv;
    @ConfigurableProperty(name="dcmAuditSuccessSeverity", enumRepresentation=ConfigurableProperty.EnumRepresentation.ORDINAL, defaultValue="5")
    private Severity successSeverity = Severity.notice;
    @ConfigurableProperty(name="dcmAuditMinorFailureSeverity", enumRepresentation=ConfigurableProperty.EnumRepresentation.ORDINAL, defaultValue="4")
    private Severity minorFailureSeverity = Severity.warning;
    @ConfigurableProperty(name="dcmAuditSeriousFailureSeverity", enumRepresentation=ConfigurableProperty.EnumRepresentation.ORDINAL, defaultValue="3")
    private Severity seriousFailureSeverity = Severity.err;
    @ConfigurableProperty(name="dcmAuditMajorFailureSeverity", enumRepresentation=ConfigurableProperty.EnumRepresentation.ORDINAL, defaultValue="2")
    private Severity majorFailureSeverity = Severity.crit;
    @ConfigurableProperty(name="dcmAuditApplicationName")
    private String applicationName;
    @ConfigurableProperty(name="dcmAuditSourceID")
    private String auditSourceID;
    @ConfigurableProperty(name="dcmAuditEnterpriseSiteID")
    private String auditEnterpriseSiteID;
    @ConfigurableProperty(name="dcmAuditSourceTypeCode")
    private String[] auditSourceTypeCodes = new String[0];
    @ConfigurableProperty(name="dcmAuditMessageID", defaultValue="DICOM+RFC3881")
    private String messageID = "DICOM+RFC3881";
    @ConfigurableProperty(name="dcmAuditMessageEncoding", defaultValue="UTF-8")
    private String encoding = "UTF-8";
    @ConfigurableProperty(name="dcmAuditMessageSchemaURI", defaultValue="http://www.dcm4che.org/DICOM/audit-message.rnc")
    private String schemaURI = "http://www.dcm4che.org/DICOM/audit-message.rnc";
    @ConfigurableProperty(name="dcmAuditTimestampInUTC", defaultValue="false")
    private boolean timestampInUTC = false;
    @ConfigurableProperty(name="dcmAuditMessageBOM", defaultValue="true")
    private boolean includeBOM = true;
    @ConfigurableProperty(name="dcmAuditMessageFormatXML", defaultValue="false")
    private boolean formatXML;
    @ConfigurableProperty(name="dicomInstalled")
    private Boolean auditLoggerInstalled;
    @ConfigurableProperty(name="dcmAuditIncludeInstanceUID")
    private Boolean doIncludeInstanceUID = false;
    @ConfigurableProperty(name="dcmAuditLoggerSpoolDirectoryURI")
    private String spoolDirectoryURI;
    private File spoolDirectory;
    private String spoolFileNamePrefix = "audit";
    private String spoolFileNameSuffix = ".log";
    @ConfigurableProperty(name="dcmAuditLoggerRetryInterval", defaultValue="0")
    private int retryInterval;
    @LDAP(noContainerNode=true, distinguishingField="cn")
    @ConfigurableProperty(name="dcmAuditSuppressCriteria")
    private final List<AuditSuppressCriteria> suppressAuditMessageFilters = new ArrayList<AuditSuppressCriteria>(0);
    @ConfigurableProperty(name="dicomNetworkConnectionReference", label="Connections", description="Connections that can be used to send audit messages", tags={ConfigurableProperty.Tag.PRIMARY}, collectionOfReferences=true)
    private List<Connection> connections = new ArrayList<Connection>(1);
    private transient MessageBuilder builder;
    private transient ActiveConnection activeConnection;
    private transient ScheduledFuture<?> retryTimer;
    private transient Exception lastException;
    private transient long lastSentTimeInMillis;
    private final transient FilenameFilter FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.startsWith(AuditLogger.this.spoolFileNamePrefix) && string.endsWith(AuditLogger.this.spoolFileNameSuffix);
        }
    };

    public List<AuditSuppressCriteria> getSuppressAuditMessageFilters() {
        return this.suppressAuditMessageFilters;
    }

    public void setSuppressAuditMessageFilters(List<AuditSuppressCriteria> list) {
        this.suppressAuditMessageFilters.clear();
        for (AuditSuppressCriteria auditSuppressCriteria : list) {
            this.suppressAuditMessageFilters.add(auditSuppressCriteria);
        }
    }

    public final Device getAuditRecordRepositoryDevice() {
        return this.auditRecordRepositoryDevice;
    }

    public String getAuditRecordRepositoryDeviceName() {
        if (this.auditRecordRepositoryDevice == null) {
            throw new IllegalStateException("AuditRecordRepositoryDevice not initalized");
        }
        return this.auditRecordRepositoryDevice.getDeviceName();
    }

    public void setAuditRecordRepositoryDevice(Device device) {
        SafeClose.close(this.activeConnection);
        this.activeConnection = null;
        this.auditRecordRepositoryDevice = device;
    }

    public final Facility getFacility() {
        return this.facility;
    }

    public final void setFacility(Facility facility) {
        if (facility == null) {
            throw new NullPointerException();
        }
        this.facility = facility;
    }

    public final Severity getSuccessSeverity() {
        return this.successSeverity;
    }

    public final void setSuccessSeverity(Severity severity) {
        if (severity == null) {
            throw new NullPointerException();
        }
        this.successSeverity = severity;
    }

    public final Severity getMinorFailureSeverity() {
        return this.minorFailureSeverity;
    }

    public final void setMinorFailureSeverity(Severity severity) {
        if (severity == null) {
            throw new NullPointerException();
        }
        this.minorFailureSeverity = severity;
    }

    public final Severity getSeriousFailureSeverity() {
        return this.seriousFailureSeverity;
    }

    public final void setSeriousFailureSeverity(Severity severity) {
        if (severity == null) {
            throw new NullPointerException();
        }
        this.seriousFailureSeverity = severity;
    }

    public final Severity getMajorFailureSeverity() {
        return this.majorFailureSeverity;
    }

    public final void setMajorFailureSeverity(Severity severity) {
        if (severity == null) {
            throw new NullPointerException();
        }
        this.majorFailureSeverity = severity;
    }

    public final String getApplicationName() {
        return this.applicationName;
    }

    private String applicationName() {
        return this.applicationName != null ? this.applicationName : this.auditSourceID();
    }

    public final void setApplicationName(String string) {
        this.applicationName = string;
    }

    public final String getAuditSourceID() {
        return this.auditSourceID;
    }

    public final void setAuditSourceID(String string) {
        this.auditSourceID = string;
    }

    private String auditSourceID() {
        return this.auditSourceID != null ? this.auditSourceID : this.getDevice().getDeviceName();
    }

    public final String getAuditEnterpriseSiteID() {
        return this.auditEnterpriseSiteID;
    }

    public final void setAuditEnterpriseSiteID(String string) {
        this.auditEnterpriseSiteID = string;
    }

    public String[] getAuditSourceTypeCodes() {
        return this.auditSourceTypeCodes;
    }

    public void setAuditSourceTypeCodes(String ... stringArray) {
        this.auditSourceTypeCodes = stringArray;
    }

    public ActiveParticipant createActiveParticipant(boolean bl, AuditMessages.RoleIDCode ... roleIDCodeArray) {
        Collection<String> collection = this.device.getApplicationAETitles();
        return this.createActiveParticipant(bl, AuditLogger.processID(), AuditMessages.alternativeUserIDForAETitle(collection.toArray(new String[collection.size()])), this.applicationName(), AuditLogger.localHost().getHostName(), roleIDCodeArray);
    }

    public ActiveParticipant createActiveParticipant(boolean bl, String string, String string2, String string3, String string4, AuditMessages.RoleIDCode ... roleIDCodeArray) {
        ActiveParticipant activeParticipant = new ActiveParticipant();
        activeParticipant.setUserID(string);
        activeParticipant.setAlternativeUserID(string2);
        activeParticipant.setUserName(string3);
        activeParticipant.setUserIsRequestor(bl);
        activeParticipant.setNetworkAccessPointID(string4);
        activeParticipant.setNetworkAccessPointTypeCode(AuditMessages.isIP(string4) ? "2" : "1");
        AuditMessages.RoleIDCode[] roleIDCodeArray2 = roleIDCodeArray;
        int n = roleIDCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AuditMessages.RoleIDCode roleIDCode = roleIDCodeArray2[n2];
            activeParticipant.getRoleIDCode().add(roleIDCode);
            ++n2;
        }
        return activeParticipant;
    }

    public AuditSourceIdentification createAuditSourceIdentification() {
        Object object;
        AuditSourceIdentification auditSourceIdentification = new AuditSourceIdentification();
        auditSourceIdentification.setAuditSourceID(this.auditSourceID());
        if (this.auditEnterpriseSiteID != null) {
            if (this.auditEnterpriseSiteID.equals("dicomInstitutionName")) {
                object = this.getDevice().getInstitutionNames();
                if (((String[])object).length > 0) {
                    auditSourceIdentification.setAuditEnterpriseSiteID(object[0]);
                }
            } else {
                auditSourceIdentification.setAuditEnterpriseSiteID(this.auditEnterpriseSiteID);
            }
        }
        String[] stringArray = this.auditSourceTypeCodes;
        int n = this.auditSourceTypeCodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object object2;
            object = stringArray[n2];
            if (((String)object).equals("dicomPrimaryDeviceType")) {
                String[] stringArray2 = this.device.getPrimaryDeviceTypes();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    object2 = stringArray2[n4];
                    AuditSourceTypeCode auditSourceTypeCode = new AuditSourceTypeCode();
                    auditSourceTypeCode.setCode((String)object2);
                    auditSourceTypeCode.setCodeSystemName("DCM");
                    auditSourceIdentification.getAuditSourceTypeCode().add(auditSourceTypeCode);
                    ++n4;
                }
            } else {
                object2 = new AuditSourceTypeCode();
                ((AuditSourceTypeCode)object2).setCode((String)object);
                auditSourceIdentification.getAuditSourceTypeCode().add((AuditSourceTypeCode)object2);
            }
            ++n2;
        }
        return auditSourceIdentification;
    }

    public final String getMessageID() {
        return this.messageID;
    }

    public final void setMessageID(String string) {
        this.messageID = string;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String string) {
        if (!Charset.isSupported(string)) {
            throw new IllegalArgumentException("Charset not supported: " + string);
        }
        this.encoding = string;
    }

    public final String getSchemaURI() {
        return this.schemaURI;
    }

    public final void setSchemaURI(String string) {
        this.schemaURI = string;
    }

    public final boolean isTimestampInUTC() {
        return this.timestampInUTC;
    }

    public final void setTimestampInUTC(boolean bl) {
        this.timestampInUTC = bl;
    }

    public final boolean isIncludeBOM() {
        return this.includeBOM;
    }

    public final void setIncludeBOM(boolean bl) {
        this.includeBOM = bl;
    }

    public final boolean isFormatXML() {
        return this.formatXML;
    }

    public final void setFormatXML(boolean bl) {
        this.formatXML = bl;
    }

    public boolean isInstalled() {
        return this.device != null && this.device.isInstalled() && (this.auditLoggerInstalled == null || this.auditLoggerInstalled != false);
    }

    public final Boolean getAuditLoggerInstalled() {
        return this.auditLoggerInstalled;
    }

    public void setAuditLoggerInstalled(Boolean bl) {
        if (bl != null && bl.booleanValue() && this.device != null && !this.device.isInstalled()) {
            throw new IllegalStateException("owning device not installed");
        }
        this.auditLoggerInstalled = bl;
    }

    public Boolean isIncludeInstanceUID() {
        return this.doIncludeInstanceUID;
    }

    public Boolean getDoIncludeInstanceUID() {
        return this.doIncludeInstanceUID;
    }

    public void setDoIncludeInstanceUID(Boolean bl) {
        this.doIncludeInstanceUID = bl;
    }

    public File getSpoolDirectory() {
        return this.spoolDirectory;
    }

    public void setSpoolDirectory(File file) {
        this.spoolDirectory = file;
    }

    public String getSpoolDirectoryURI() {
        return this.spoolDirectory != null ? this.spoolDirectory.toURI().toString() : null;
    }

    public void setSpoolDirectoryURI(String string) {
        this.spoolDirectory = string != null ? new File(URI.create(string)) : null;
    }

    public String getSpoolNameFilePrefix() {
        return this.spoolFileNamePrefix;
    }

    public void setSpoolFileNamePrefix(String string) {
        if (string.length() < 3) {
            throw new IllegalArgumentException("Spool file name prefix too short");
        }
        this.spoolFileNamePrefix = string;
    }

    public String getSpoolFileNameSuffix() {
        return this.spoolFileNameSuffix;
    }

    public void setSpoolFileNameSuffix(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Spool file name suffix cannot be empty");
        }
        this.spoolFileNameSuffix = string;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int n) {
        this.retryInterval = n;
    }

    public void addConnection(Connection connection) {
        if (!connection.getProtocol().isSyslog()) {
            throw new IllegalArgumentException("Audit Logger does not support protocol " + (Object)((Object)connection.getProtocol()));
        }
        if (this.device != null && this.device != connection.getDevice()) {
            throw new IllegalStateException(connection + " not contained by " + this.device.getDeviceName());
        }
        this.connections.add(connection);
    }

    @Override
    public void verifyNotUsed(Connection connection) {
        if (this.connections.contains(connection)) {
            throw new IllegalStateException(connection + " used by Audit Logger");
        }
    }

    public boolean removeConnection(Connection connection) {
        return this.connections.remove(connection);
    }

    public void setConnections(List<Connection> list) {
        this.connections.clear();
        for (Connection connection : list) {
            this.addConnection(connection);
        }
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public List<AuditSuppressCriteria> getAuditSuppressCriteriaList() {
        return this.suppressAuditMessageFilters;
    }

    public AuditSuppressCriteria findAuditSuppressCriteriaByCommonName(String string) {
        for (AuditSuppressCriteria auditSuppressCriteria : this.suppressAuditMessageFilters) {
            if (!auditSuppressCriteria.getCommonName().equals(string)) continue;
            return auditSuppressCriteria;
        }
        return null;
    }

    public void setAuditSuppressCriteriaList(List<AuditSuppressCriteria> list) {
        this.suppressAuditMessageFilters.clear();
        this.suppressAuditMessageFilters.addAll(list);
    }

    public void addAuditSuppressCriteria(AuditSuppressCriteria auditSuppressCriteria) {
        this.suppressAuditMessageFilters.add(auditSuppressCriteria);
    }

    public void clearAllAuditSuppressCriteria() {
        this.suppressAuditMessageFilters.clear();
    }

    public boolean isAuditMessageSuppressed(AuditMessage auditMessage) {
        for (AuditSuppressCriteria auditSuppressCriteria : this.suppressAuditMessageFilters) {
            if (!auditSuppressCriteria.match(auditMessage)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reconfigure(DeviceExtension deviceExtension) {
        this.reconfigure((AuditLogger)deviceExtension);
    }

    private void reconfigure(AuditLogger auditLogger) {
        this.setFacility(auditLogger.facility);
        this.setSuccessSeverity(auditLogger.successSeverity);
        this.setMinorFailureSeverity(auditLogger.minorFailureSeverity);
        this.setSeriousFailureSeverity(auditLogger.seriousFailureSeverity);
        this.setMajorFailureSeverity(auditLogger.majorFailureSeverity);
        this.setApplicationName(auditLogger.applicationName);
        this.setAuditSourceID(auditLogger.auditSourceID);
        this.setAuditEnterpriseSiteID(auditLogger.auditEnterpriseSiteID);
        this.setAuditSourceTypeCodes(auditLogger.auditSourceTypeCodes);
        this.setMessageID(auditLogger.messageID);
        this.setEncoding(auditLogger.encoding);
        this.setSchemaURI(auditLogger.schemaURI);
        this.setTimestampInUTC(auditLogger.timestampInUTC);
        this.setIncludeBOM(auditLogger.includeBOM);
        this.setFormatXML(auditLogger.formatXML);
        this.setSpoolDirectory(auditLogger.spoolDirectory);
        this.setSpoolFileNamePrefix(auditLogger.spoolFileNamePrefix);
        this.setSpoolFileNameSuffix(auditLogger.spoolFileNameSuffix);
        this.setRetryInterval(auditLogger.retryInterval);
        this.setAuditLoggerInstalled(auditLogger.auditLoggerInstalled);
        this.setAuditRecordRepositoryDevice(auditLogger.auditRecordRepositoryDevice);
        this.setAuditSuppressCriteriaList(auditLogger.suppressAuditMessageFilters);
        this.device.reconfigureConnections(this.connections, auditLogger.connections);
        this.closeActiveConnection();
    }

    public Calendar timeStamp() {
        return this.timestampInUTC ? new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.ENGLISH) : new GregorianCalendar(Locale.ENGLISH);
    }

    public SendStatus write(Calendar calendar, AuditMessage auditMessage) throws IncompatibleConnectionException, GeneralSecurityException, IOException {
        if (this.isAuditMessageSuppressed(auditMessage)) {
            return SendStatus.SUPPRESSED;
        }
        return this.sendMessage(this.builder().createMessage(calendar, auditMessage));
    }

    public SendStatus write(Calendar calendar, Severity severity, byte[] byArray, int n, int n2) throws IncompatibleConnectionException, GeneralSecurityException, IOException {
        return this.sendMessage(this.builder().createMessage(calendar, severity, byArray, n, n2));
    }

    private MessageBuilder builder() {
        if (this.builder == null) {
            this.builder = new MessageBuilder();
        }
        return this.builder;
    }

    private SendStatus sendMessage(DatagramPacket datagramPacket) throws IncompatibleConnectionException, GeneralSecurityException, IOException {
        if (this.getNumberOfQueuedMessages() > 0) {
            this.spoolMessage(datagramPacket);
        } else {
            try {
                this.activeConnection().sendMessage(datagramPacket);
                this.lastSentTimeInMillis = System.currentTimeMillis();
                return SendStatus.SENT;
            }
            catch (IOException iOException) {
                this.lastException = iOException;
                if (this.retryInterval > 0) {
                    LOG.info("Failed to send audit message:", (Throwable)iOException);
                    this.spoolMessage(datagramPacket);
                    this.scheduleRetry();
                }
                throw iOException;
            }
        }
        return SendStatus.QUEUED;
    }

    private synchronized void scheduleRetry() {
        if (this.retryTimer != null || this.retryInterval <= 0) {
            return;
        }
        LOG.debug("Scheduled retry in {} s", (Object)this.retryInterval);
        this.retryTimer = this.getDevice().schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AuditLogger auditLogger = AuditLogger.this;
                synchronized (auditLogger) {
                    AuditLogger.this.retryTimer = null;
                }
                AuditLogger.this.sendQueuedMessages();
            }
        }, this.retryInterval, TimeUnit.SECONDS);
    }

    private void spoolMessage(DatagramPacket datagramPacket) throws IOException {
        if (this.spoolDirectory != null) {
            this.spoolDirectory.mkdirs();
        }
        File file = null;
        try {
            try {
                file = File.createTempFile(this.spoolFileNamePrefix, this.spoolFileNameSuffix, this.spoolDirectory);
                if (this.spoolDirectory == null) {
                    this.spoolDirectory = file.getParentFile();
                }
                LOG.info("Spool audit message to {}", (Object)file);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    fileOutputStream.write(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
                }
                finally {
                    SafeClose.close(fileOutputStream);
                }
                file = null;
            }
            catch (IOException iOException) {
                throw new IOException("Failed to spool audit message", iOException);
            }
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueuedMessages() {
        Object object;
        File file = this.spoolDirectory;
        if (file == null) {
            return;
        }
        try {
            object = file.listFiles(this.FILENAME_FILTER);
            byte[] byArray = null;
            while (object != null && ((File[])object).length > 0) {
                Arrays.sort(object, FILE_COMPARATOR);
                Object object2 = object;
                int n = ((File[])object).length;
                int n2 = 0;
                while (n2 < n) {
                    block17: {
                        File file2 = object2[n2];
                        LOG.debug("Read audit message from {}", (Object)file2);
                        int n3 = (int)file2.length();
                        if (byArray == null || byArray.length < n3) {
                            byArray = new byte[n3];
                        }
                        try {
                            FileInputStream fileInputStream = new FileInputStream(file2);
                            try {
                                StreamUtils.readFully(fileInputStream, byArray, 0, n3);
                            }
                            finally {
                                SafeClose.close(fileInputStream);
                            }
                        }
                        catch (IOException iOException) {
                            LOG.warn("Failed to read audit message from {}", (Object)file2, (Object)iOException);
                            File file3 = new File(file2.getParent(), String.valueOf(file2.getPath()) + ".err");
                            file2.renameTo(file3);
                            break block17;
                        }
                        this.activeConnection().sendMessage(new DatagramPacket(byArray, 0, n3));
                        this.lastSentTimeInMillis = System.currentTimeMillis();
                        if (file2.delete()) {
                            LOG.debug("Delete spool file {}", (Object)file2);
                        } else {
                            LOG.warn("Failed to delete spool file {}", (Object)file2);
                        }
                    }
                    ++n2;
                }
                object = file.listFiles(this.FILENAME_FILTER);
            }
        }
        catch (Exception exception) {
            this.lastException = exception;
            LOG.info("Failed to send audit message:", (Throwable)exception);
            this.scheduleRetry();
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public long getLastSentTimeInMillis() {
        return this.lastSentTimeInMillis;
    }

    public int getNumberOfQueuedMessages() {
        try {
            return this.spoolDirectory.list(this.FILENAME_FILTER).length;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public File[] getQueuedMessages() {
        try {
            return this.spoolDirectory.listFiles(this.FILENAME_FILTER);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public synchronized void waitForNoQueuedMessages(long l) throws InterruptedException {
        while (this.getNumberOfQueuedMessages() > 0) {
            this.wait(l);
        }
    }

    public synchronized void closeActiveConnection() {
        ActiveConnection activeConnection = this.activeConnection;
        if (activeConnection != null) {
            try {
                activeConnection.close();
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
            this.activeConnection = null;
        }
    }

    private synchronized ActiveConnection activeConnection() throws IncompatibleConnectionException {
        ActiveConnection activeConnection = this.activeConnection;
        if (activeConnection != null) {
            return activeConnection;
        }
        Device device = this.auditRecordRepositoryDevice;
        if (this.auditRecordRepositoryDevice == null) {
            throw new IllegalStateException("No AuditRecordRepositoryDevice initalized");
        }
        AuditRecordRepository auditRecordRepository = device.getDeviceExtension(AuditRecordRepository.class);
        if (auditRecordRepository == null) {
            throw new IllegalStateException("AuditRecordRepositoryDevice " + this.auditRecordRepositoryDevice.getDeviceName() + " does not provide Audit Record Repository");
        }
        for (Connection connection : auditRecordRepository.getConnections()) {
            if (!connection.isInstalled() || !connection.isServer()) continue;
            for (Connection connection2 : this.connections) {
                if (!connection2.isInstalled() || !connection2.isCompatible(connection)) continue;
                this.activeConnection = connection2.getProtocol().isTCP() ? new TCPConnection(connection2, connection) : new UDPConnection(connection2, connection);
                return this.activeConnection;
            }
        }
        throw new IncompatibleConnectionException("No compatible connection to " + auditRecordRepository + " available on " + this);
    }

    public static String processID() {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        int n = string.indexOf(64);
        return n > 0 ? string.substring(0, n) : Integer.toString(new Random().nextInt() & Integer.MAX_VALUE);
    }

    public static InetAddress localHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private Severity severityOf(AuditMessage auditMessage) {
        String string = auditMessage.getEventIdentification().getEventOutcomeIndicator();
        if (string.length() == 1) {
            switch (string.charAt(0)) {
                case '0': {
                    return this.successSeverity;
                }
                case '4': {
                    return this.minorFailureSeverity;
                }
                case '8': {
                    return this.seriousFailureSeverity;
                }
            }
        } else if (string.equals("12")) {
            return this.majorFailureSeverity;
        }
        throw new IllegalArgumentException("Illegal eventOutcomeIndicator: " + string);
    }

    private int prival(Severity severity) {
        return this.facility.ordinal() << 3 | severity.ordinal();
    }

    public static AuditLogger getDefaultLogger() {
        return defaultLogger;
    }

    public static void setDefaultLogger(AuditLogger auditLogger) {
        defaultLogger = auditLogger;
    }

    private static String toString(DatagramPacket datagramPacket) {
        try {
            int n = datagramPacket.getLength();
            boolean bl = n > 8192;
            String string = new String(datagramPacket.getData(), 0, bl ? 8192 : n, "UTF-8");
            if (bl) {
                string = String.valueOf(string) + "...";
            }
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private abstract class ActiveConnection
    implements Closeable {
        final Connection conn;
        final Connection remoteConn;

        ActiveConnection(Connection connection, Connection connection2) {
            this.conn = connection;
            this.remoteConn = connection2;
        }

        abstract void sendMessage(DatagramPacket var1) throws IOException, IncompatibleConnectionException, GeneralSecurityException;
    }

    public static enum Facility {
        kern,
        user,
        mail,
        daemon,
        auth,
        syslog,
        lpr,
        news,
        uucp,
        cron,
        authpriv,
        ftp,
        ntp,
        audit,
        console,
        cron2,
        local0,
        local1,
        local2,
        local3,
        local4,
        local5,
        local6,
        local7;

    }

    private class MessageBuilder
    extends ByteArrayOutputStream {
        private MessageBuilder() {
        }

        DatagramPacket createMessage(Calendar calendar, AuditMessage auditMessage) {
            block2: {
                try {
                    this.reset();
                    this.writeHeader(AuditLogger.this.severityOf(auditMessage), calendar);
                    AuditMessages.toXML(auditMessage, AuditLogger.this.builder, AuditLogger.this.formatXML, AuditLogger.this.encoding, AuditLogger.this.schemaURI);
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)iOException);
                }
            }
            return new DatagramPacket(this.buf, 0, this.count);
        }

        DatagramPacket createMessage(Calendar calendar, Severity severity, byte[] byArray, int n, int n2) {
            block2: {
                try {
                    this.reset();
                    this.writeHeader(severity, calendar);
                    this.write(byArray, n, n2);
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)iOException);
                }
            }
            return new DatagramPacket(this.buf, 0, this.count);
        }

        void writeHeader(Severity severity, Calendar calendar) throws IOException {
            this.write(60);
            this.writeInt(AuditLogger.this.prival(severity));
            this.write(62);
            this.write(49);
            this.write(32);
            this.write(calendar);
            this.write(32);
            if (localHost != null) {
                this.write(localHost.getCanonicalHostName().getBytes(AuditLogger.this.encoding));
            } else {
                this.write(45);
            }
            this.write(32);
            this.write(AuditLogger.this.applicationName().getBytes(AuditLogger.this.encoding));
            this.write(32);
            this.write(processID.getBytes(AuditLogger.this.encoding));
            this.write(32);
            if (AuditLogger.this.messageID != null) {
                this.write(AuditLogger.this.messageID.getBytes(AuditLogger.this.encoding));
            } else {
                this.write(45);
            }
            this.write(32);
            this.write(45);
            this.write(32);
            if (AuditLogger.this.includeBOM && AuditLogger.this.encoding.equals("UTF-8")) {
                this.write(BOM);
            }
        }

        void writeInt(int n) {
            if (n >= 100) {
                this.writeNNN(n);
            } else if (n >= 10) {
                this.writeNN(n);
            } else {
                this.writeN(n);
            }
        }

        void write(Calendar calendar) {
            this.writeNNNN(calendar.get(1));
            this.write(45);
            this.writeNN(calendar.get(2) + 1);
            this.write(45);
            this.writeNN(calendar.get(5));
            this.write(84);
            this.writeNN(calendar.get(11));
            this.write(58);
            this.writeNN(calendar.get(12));
            this.write(58);
            this.writeNN(calendar.get(13));
            this.write(46);
            this.writeNNN(calendar.get(14));
            int n = calendar.get(15) + calendar.get(16);
            if (n == 0) {
                this.write(90);
            } else {
                if ((n /= 60000) > 0) {
                    this.write(43);
                } else {
                    this.write(45);
                    n = -n;
                }
                this.writeNN(n / 60);
                this.write(58);
                this.writeNN(n % 60);
            }
        }

        void writeNNNN(int n) {
            this.writeNN(n / 100);
            this.writeNN(n % 100);
        }

        void writeNNN(int n) {
            this.writeN(n / 100);
            this.writeNN(n % 100);
        }

        void writeNN(int n) {
            this.write(DIGITS_X0[n]);
            this.write(DIGITS_0X[n]);
        }

        void writeN(int n) {
            this.write(DIGITS_0X[n]);
        }
    }

    public static enum SendStatus {
        SENT,
        QUEUED,
        SUPPRESSED;

    }

    public static enum Severity {
        emerg,
        alert,
        crit,
        err,
        warning,
        notice,
        info,
        debug;

    }

    private class TCPConnection
    extends ActiveConnection {
        Socket sock;
        OutputStream out;
        ScheduledFuture<?> idleTimer;

        TCPConnection(Connection connection, Connection connection2) {
            super(connection, connection2);
        }

        void connect() throws IOException, IncompatibleConnectionException, GeneralSecurityException {
            if (this.sock == null) {
                this.sock = this.conn.connect(this.remoteConn);
                this.out = this.sock.getOutputStream();
            }
        }

        @Override
        synchronized void sendMessage(DatagramPacket datagramPacket) throws IOException, IncompatibleConnectionException, GeneralSecurityException {
            this.stopIdleTimer();
            this.connect();
            try {
                this.trySendMessage(datagramPacket);
            }
            catch (IOException iOException) {
                LOG.info("Failed to send audit message to {} - reconnect", (Object)this.sock, (Object)iOException);
                this.close();
                this.connect();
                this.trySendMessage(datagramPacket);
            }
            this.startIdleTimer();
        }

        void trySendMessage(DatagramPacket datagramPacket) throws IOException {
            LOG.info("Send audit message to {}", (Object)this.sock);
            if (LOG.isDebugEnabled()) {
                LOG.debug(AuditLogger.toString(datagramPacket));
            }
            this.out.write(Integer.toString(datagramPacket.getLength()).getBytes(AuditLogger.this.encoding));
            this.out.write(32);
            this.out.write(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
            this.out.flush();
        }

        private void startIdleTimer() {
            int n = this.conn.getIdleTimeout();
            if (n > 0) {
                LOG.debug("Start Idle timeout of {} ms for {}", (Object)n, (Object)this.sock);
                try {
                    this.idleTimer = this.conn.getDevice().schedule(new Runnable(){

                        @Override
                        public void run() {
                            TCPConnection.this.onIdleTimerExpired();
                        }
                    }, n, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    LOG.warn("Failed to start Idle timeout", (Throwable)exception);
                }
            }
        }

        private void stopIdleTimer() {
            if (this.idleTimer != null) {
                LOG.debug("Stop Idle timer for {}", (Object)this.sock);
                this.idleTimer.cancel(false);
                this.idleTimer = null;
            }
        }

        @Override
        public synchronized void close() {
            this.stopIdleTimer();
            this.closeSocket();
        }

        private void closeSocket() {
            if (this.sock != null) {
                this.conn.close(this.sock);
            }
            this.sock = null;
            this.out = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onIdleTimerExpired() {
            ScheduledFuture<?> scheduledFuture = this.idleTimer;
            TCPConnection tCPConnection = this;
            synchronized (tCPConnection) {
                if (scheduledFuture != this.idleTimer) {
                    LOG.debug("Detect restart of Idle timer for {}", (Object)this.sock);
                } else {
                    LOG.info("Idle timeout for {} expired", (Object)this.sock);
                    this.idleTimer = null;
                    this.closeSocket();
                }
            }
        }
    }

    private class UDPConnection
    extends ActiveConnection {
        DatagramSocket ds;

        UDPConnection(Connection connection, Connection connection2) {
            super(connection, connection2);
        }

        @Override
        void sendMessage(DatagramPacket datagramPacket) throws IOException {
            if (this.ds == null) {
                this.ds = this.conn.createDatagramSocket();
            }
            InetSocketAddress inetSocketAddress = this.remoteConn.getEndPoint();
            LOG.info("Send audit message to {}", (Object)inetSocketAddress);
            if (LOG.isDebugEnabled()) {
                LOG.debug(AuditLogger.toString(datagramPacket));
            }
            datagramPacket.setSocketAddress(inetSocketAddress);
            this.ds.send(datagramPacket);
        }

        @Override
        public void close() {
            if (this.ds != null) {
                this.ds.close();
                this.ds = null;
            }
        }
    }
}

