/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.audit;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.conf.core.api.ConfigurableClass;
import org.dcm4che3.conf.core.api.ConfigurableProperty;
import org.dcm4che3.conf.core.api.LDAP;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.net.audit.AuditRecordHandler;
import org.dcm4che3.net.audit.SyslogProtocolHandler;

@LDAP(objectClasses={"dcmAuditRecordRepository"})
@ConfigurableClass
public class AuditRecordRepository
extends DeviceExtension {
    private static final long serialVersionUID = -2279487409324427161L;
    @ConfigurableProperty(name="dicomInstalled")
    private Boolean arrInstalled;
    @ConfigurableProperty(name="dicomNetworkConnectionReference", collectionOfReferences=true)
    private final List<Connection> connections = new ArrayList<Connection>(1);
    private transient AuditRecordHandler handler;

    static {
        Connection.registerTCPProtocolHandler(Connection.Protocol.SYSLOG_TLS, SyslogProtocolHandler.INSTANCE);
        Connection.registerUDPProtocolHandler(Connection.Protocol.SYSLOG_UDP, SyslogProtocolHandler.INSTANCE);
    }

    public boolean isInstalled() {
        return this.device != null && this.device.isInstalled() && (this.arrInstalled == null || this.arrInstalled != false);
    }

    public final Boolean getArrInstalled() {
        return this.arrInstalled;
    }

    public void setArrInstalled(Boolean bl) {
        if (bl != null && bl.booleanValue() && this.device != null && !this.device.isInstalled()) {
            throw new IllegalStateException("owning device not installed");
        }
        this.arrInstalled = bl;
    }

    public void addConnection(Connection connection) {
        if (!connection.getProtocol().isSyslog()) {
            throw new IllegalArgumentException("Audit Record Repository does not support protocol " + (Object)((Object)connection.getProtocol()));
        }
        if (this.device != null && this.device != connection.getDevice()) {
            throw new IllegalStateException(connection + " not contained by " + this.device.getDeviceName());
        }
        this.connections.add(connection);
    }

    public boolean removeConnection(Connection connection) {
        return this.connections.remove(connection);
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public void setConnections(List<Connection> list) {
        this.connections.clear();
        for (Connection connection : list) {
            this.addConnection(connection);
        }
    }

    public AuditRecordHandler getAuditRecordHandler() {
        return this.handler;
    }

    public void setAuditRecordHandler(AuditRecordHandler auditRecordHandler) {
        this.handler = auditRecordHandler;
    }

    @Override
    public void reconfigure(DeviceExtension deviceExtension) {
        this.reconfigure((AuditRecordRepository)deviceExtension);
    }

    private void reconfigure(AuditRecordRepository auditRecordRepository) {
        this.setArrInstalled(auditRecordRepository.arrInstalled);
        this.device.reconfigureConnections(this.connections, auditRecordRepository.connections);
    }

    public void onMessage(byte[] byArray, int n, int n2, Connection connection, InetAddress inetAddress) {
        if (this.handler == null) {
            throw new IllegalStateException("No AuditRecordHandler initialized");
        }
        this.handler.onMessage(byArray, n, n2, connection, inetAddress);
    }
}

