/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.audit;

import java.util.List;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.EventID;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.EventTypeCode;
import org.dcm4che3.audit.RoleIDCode;
import org.dcm4che3.conf.core.api.ConfigurableClass;
import org.dcm4che3.conf.core.api.ConfigurableProperty;
import org.dcm4che3.conf.core.api.LDAP;
import org.dcm4che3.data.Code;

@LDAP(objectClasses={"dcmAuditSuppressCriteria"})
@ConfigurableClass
public class AuditSuppressCriteria {
    @ConfigurableProperty(name="cn")
    private String commonName;
    @ConfigurableProperty(name="dcmAuditEventID")
    private EventID[] eventIDs = new EventID[0];
    @ConfigurableProperty(name="dcmAuditEventTypeCode")
    private EventTypeCode[] eventTypeCodes = new EventTypeCode[0];
    @ConfigurableProperty(name="dcmAuditEventActionCode")
    private String[] eventActionCodes = new String[0];
    @ConfigurableProperty(name="dcmAuditEventOutcomeIndicator")
    private String[] eventOutcomeIndicators = new String[0];
    @ConfigurableProperty(name="dcmAuditUserID")
    private String[] userIDs = new String[0];
    @ConfigurableProperty(name="dcmAuditAlternativeUserID")
    private String[] alternativeUserIDs = new String[0];
    @ConfigurableProperty(name="dcmAuditUserRoleIDCode")
    private RoleIDCode[] roleIDCodes = new RoleIDCode[0];
    @ConfigurableProperty(name="dcmAuditNetworkAccessPointID")
    private String[] networkAccessPointIDs = new String[0];
    @ConfigurableProperty(name="dcmAuditUserIsRequestor")
    private Boolean userIsRequestor;

    public AuditSuppressCriteria() {
    }

    public void setCommonName(String string) {
        this.commonName = string;
    }

    public AuditSuppressCriteria(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("cn must not be empty");
        }
        this.commonName = string;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public EventID[] getEventIDs() {
        return this.eventIDs;
    }

    public void setEventIDs(EventID ... eventIDArray) {
        this.eventIDs = eventIDArray;
    }

    public String[] getEventIDsAsStringArray() {
        return AuditSuppressCriteria.toStringArray(this.eventIDs);
    }

    public void setEventIDsAsStringArray(String[] stringArray) {
        this.setEventIDs(AuditSuppressCriteria.toEventIDArray(stringArray));
    }

    public EventTypeCode[] getEventTypeCodes() {
        return this.eventTypeCodes;
    }

    public void setEventTypeCodes(EventTypeCode ... eventTypeCodeArray) {
        this.eventTypeCodes = eventTypeCodeArray;
    }

    public String[] getEventTypeCodesAsStringArray() {
        return AuditSuppressCriteria.toStringArray(this.eventTypeCodes);
    }

    public void setEventTypeCodesAsStringArray(String ... stringArray) {
        this.setEventTypeCodes(AuditSuppressCriteria.toEventTypeCodeArray(stringArray));
    }

    public String[] getEventActionCodes() {
        return this.eventActionCodes;
    }

    public void setEventActionCodes(String ... stringArray) {
        this.eventActionCodes = stringArray;
    }

    public String[] getEventOutcomeIndicators() {
        return this.eventOutcomeIndicators;
    }

    public void setEventOutcomeIndicators(String ... stringArray) {
        this.eventOutcomeIndicators = stringArray;
    }

    public String[] getUserIDs() {
        return this.userIDs;
    }

    public void setUserIDs(String ... stringArray) {
        this.userIDs = stringArray;
    }

    public String[] getAlternativeUserIDs() {
        return this.alternativeUserIDs;
    }

    public void setAlternativeUserIDs(String ... stringArray) {
        this.alternativeUserIDs = stringArray;
    }

    public RoleIDCode[] getUserRoleIDCodes() {
        return this.roleIDCodes;
    }

    public void setUserRoleIDCodes(RoleIDCode ... roleIDCodeArray) {
        this.roleIDCodes = roleIDCodeArray;
    }

    public String[] getUserRoleIDCodesAsStringArray() {
        return AuditSuppressCriteria.toStringArray(this.roleIDCodes);
    }

    public void setUserRoleIDCodesAsStringArray(String ... stringArray) {
        this.setUserRoleIDCodes(AuditSuppressCriteria.toRoleIDCodeArray(stringArray));
    }

    public String[] getNetworkAccessPointIDs() {
        return this.networkAccessPointIDs;
    }

    public void setNetworkAccessPointIDs(String ... stringArray) {
        this.networkAccessPointIDs = stringArray;
    }

    public Boolean getUserIsRequestor() {
        return this.userIsRequestor;
    }

    public void setUserIsRequestor(Boolean bl) {
        this.userIsRequestor = bl;
    }

    public boolean match(AuditMessage auditMessage) {
        if (!this.match(auditMessage.getEventIdentification())) {
            return false;
        }
        return this.match(auditMessage.getActiveParticipant());
    }

    private boolean match(EventIdentification eventIdentification) {
        if (!this.matchEventID(eventIdentification.getEventID())) {
            return false;
        }
        if (!this.matchEventTypeCodes(eventIdentification.getEventTypeCode())) {
            return false;
        }
        if (!this.isEmptyOrContains(this.eventActionCodes, eventIdentification.getEventActionCode())) {
            return false;
        }
        return this.isEmptyOrContains(this.eventOutcomeIndicators, eventIdentification.getEventOutcomeIndicator());
    }

    private boolean matchEventID(EventID eventID) {
        if (this.eventIDs.length == 0) {
            return true;
        }
        EventID[] eventIDArray = this.eventIDs;
        int n = this.eventIDs.length;
        int n2 = 0;
        while (n2 < n) {
            EventID eventID2 = eventIDArray[n2];
            if (eventID2.getCode().equals(eventID.getCode()) && this.equals(eventID2.getCodeSystemName(), eventID.getCodeSystemName()) && this.equals(eventID2.getCodeSystem(), eventID.getCodeSystem())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean equals(Object object, Object object2) {
        return object != null ? object.equals(object2) : object2 == null;
    }

    private boolean matchEventTypeCodes(List<EventTypeCode> list) {
        if (this.eventTypeCodes.length == 0) {
            return true;
        }
        for (EventTypeCode eventTypeCode : list) {
            EventTypeCode[] eventTypeCodeArray = this.eventTypeCodes;
            int n = this.eventTypeCodes.length;
            int n2 = 0;
            while (n2 < n) {
                EventTypeCode eventTypeCode2 = eventTypeCodeArray[n2];
                if (eventTypeCode2.getCode().equals(eventTypeCode.getCode()) && this.equals(eventTypeCode2.getCodeSystemName(), eventTypeCode.getCodeSystemName()) && this.equals(eventTypeCode2.getCodeSystem(), eventTypeCode.getCodeSystem())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean match(List<ActiveParticipant> list) {
        if (!this.containsActiveParticipantCriteria()) {
            return true;
        }
        for (ActiveParticipant activeParticipant : list) {
            if (!this.match(activeParticipant)) continue;
            return true;
        }
        return false;
    }

    private boolean match(ActiveParticipant activeParticipant) {
        if (!this.isEmptyOrContains(this.userIDs, activeParticipant.getUserID())) {
            return false;
        }
        if (!this.isEmptyOrContains(this.alternativeUserIDs, activeParticipant.getAlternativeUserID())) {
            return false;
        }
        if (!this.isEmptyOrContains(this.networkAccessPointIDs, activeParticipant.getNetworkAccessPointID())) {
            return false;
        }
        if (!this.matchRoleIDCodes(activeParticipant.getRoleIDCode())) {
            return false;
        }
        return this.userIsRequestor == null || activeParticipant.isUserIsRequestor() == this.userIsRequestor.booleanValue();
    }

    private boolean matchRoleIDCodes(List<RoleIDCode> list) {
        if (this.roleIDCodes.length == 0) {
            return true;
        }
        for (RoleIDCode roleIDCode : list) {
            RoleIDCode[] roleIDCodeArray = this.roleIDCodes;
            int n = this.roleIDCodes.length;
            int n2 = 0;
            while (n2 < n) {
                RoleIDCode roleIDCode2 = roleIDCodeArray[n2];
                if (roleIDCode2.getCode().equals(roleIDCode.getCode()) && this.equals(roleIDCode2.getCodeSystemName(), roleIDCode.getCodeSystemName()) && this.equals(roleIDCode2.getCodeSystem(), roleIDCode.getCodeSystem())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean containsActiveParticipantCriteria() {
        return this.userIDs.length == 0 && this.alternativeUserIDs.length == 0 && this.roleIDCodes.length == 0 && this.networkAccessPointIDs.length == 0 && this.userIsRequestor == null;
    }

    private boolean isEmptyOrContains(String[] stringArray, String string) {
        if (stringArray.length == 0) {
            return true;
        }
        if (string == null) {
            return false;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string.equals(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String[] toStringArray(EventID ... eventIDArray) {
        String[] stringArray = new String[eventIDArray.length];
        int n = 0;
        while (n < eventIDArray.length) {
            stringArray[n] = new Code(eventIDArray[n].getCode(), eventIDArray[n].getCodeSystemName(), null, eventIDArray[n].getDisplayName()).toString();
            ++n;
        }
        return stringArray;
    }

    private static String[] toStringArray(EventTypeCode ... eventTypeCodeArray) {
        String[] stringArray = new String[eventTypeCodeArray.length];
        int n = 0;
        while (n < eventTypeCodeArray.length) {
            stringArray[n] = new Code(eventTypeCodeArray[n].getCode(), eventTypeCodeArray[n].getCodeSystemName(), null, eventTypeCodeArray[n].getDisplayName()).toString();
            ++n;
        }
        return stringArray;
    }

    private static String[] toStringArray(RoleIDCode ... roleIDCodeArray) {
        String[] stringArray = new String[roleIDCodeArray.length];
        int n = 0;
        while (n < roleIDCodeArray.length) {
            stringArray[n] = new Code(roleIDCodeArray[n].getCode(), roleIDCodeArray[n].getCodeSystemName(), null, roleIDCodeArray[n].getDisplayName()).toString();
            ++n;
        }
        return stringArray;
    }

    private static EventID[] toEventIDArray(String ... stringArray) {
        EventID[] eventIDArray = new EventID[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            Code code = new Code(stringArray[n]);
            eventIDArray[n] = new EventID();
            eventIDArray[n].setCode(code.getCodeValue());
            eventIDArray[n].setCodeSystemName(code.getCodingSchemeDesignator());
            eventIDArray[n].setDisplayName(code.getCodeMeaning());
            ++n;
        }
        return eventIDArray;
    }

    private static EventTypeCode[] toEventTypeCodeArray(String ... stringArray) {
        EventTypeCode[] eventTypeCodeArray = new EventTypeCode[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            Code code = new Code(stringArray[n]);
            eventTypeCodeArray[n] = new EventTypeCode();
            eventTypeCodeArray[n].setCode(code.getCodeValue());
            eventTypeCodeArray[n].setCodeSystemName(code.getCodingSchemeDesignator());
            eventTypeCodeArray[n].setDisplayName(code.getCodeMeaning());
            ++n;
        }
        return eventTypeCodeArray;
    }

    private static RoleIDCode[] toRoleIDCodeArray(String ... stringArray) {
        RoleIDCode[] roleIDCodeArray = new RoleIDCode[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            Code code = new Code(stringArray[n]);
            roleIDCodeArray[n] = new RoleIDCode();
            roleIDCodeArray[n].setCode(code.getCodeValue());
            roleIDCodeArray[n].setCodeSystemName(code.getCodingSchemeDesignator());
            roleIDCodeArray[n].setDisplayName(code.getCodeMeaning());
            ++n;
        }
        return roleIDCodeArray;
    }
}

