/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.audit;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.TCPProtocolHandler;
import org.dcm4che3.net.UDPProtocolHandler;
import org.dcm4che3.net.audit.AuditRecordRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum SyslogProtocolHandler implements TCPProtocolHandler,
UDPProtocolHandler
{
    INSTANCE;

    private static final int INIT_MSG_LEN = 8192;
    private static final int MAX_MSG_LEN = 65536;
    private static final int MAX_MSG_PREFIX = 200;
    private static final int MSG_PROMPT_LEN = 8192;
    private static Logger LOG;

    static {
        LOG = LoggerFactory.getLogger(SyslogProtocolHandler.class);
    }

    @Override
    public void onAccept(Connection connection, Socket socket) throws IOException {
        int n;
        InputStream inputStream = socket.getInputStream();
        byte[] byArray = new byte[8192];
        socket.setSoTimeout(connection.getIdleTimeout());
        while ((n = this.readMessageLength(inputStream, socket)) > 0) {
            if (n > 65536) {
                LOG.warn("Message length: {} received from {} exceeds limit {}", new Object[]{n, socket, 65536});
                break;
            }
            if (n > byArray.length) {
                byArray = new byte[n];
            }
            if (this.readMessage(inputStream, byArray, n) < n) {
                LOG.warn("Connection closed by remote host {} during receive of message", (Object)socket);
                break;
            }
            LOG.info("Received Syslog message of {} bytes from {}", (Object)n, (Object)socket);
            this.onMessage(byArray, 0, n, connection, socket.getInetAddress());
        }
        connection.close(socket);
    }

    private int readMessageLength(InputStream inputStream, Socket socket) throws IOException {
        int n;
        try {
            n = inputStream.read();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            LOG.info("Timeout expired for connection to {}", (Object)socket);
            return -1;
        }
        if (n < 0) {
            return -1;
        }
        int n2 = 0;
        do {
            int n3;
            if ((n3 = n - 48) < 0 || n3 > 9) {
                LOG.warn("Illegal character code: {} in message length received from {}", (Object)n, (Object)socket);
                return -1;
            }
            n2 = (n2 << 3) + (n2 << 1) + n3;
        } while ((n = inputStream.read()) > 0 && n != 32);
        return n2;
    }

    private int readMessage(InputStream inputStream, byte[] byArray, int n) throws IOException {
        int n2;
        int n3 = 0;
        while (n3 < n && (n2 = inputStream.read(byArray, n3, n - n3)) > 0) {
            n3 += n2;
        }
        return n3;
    }

    @Override
    public void onReceive(Connection connection, DatagramPacket datagramPacket) {
        LOG.info("Received UDP Syslog message of {} bytes from {}", (Object)datagramPacket.getLength(), (Object)datagramPacket.getAddress());
        this.onMessage(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength(), connection, datagramPacket.getAddress());
    }

    private void onMessage(byte[] byArray, int n, int n2, Connection connection, InetAddress inetAddress) {
        int n3;
        AuditRecordRepository auditRecordRepository = connection.getDevice().getDeviceExtension(AuditRecordRepository.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug(SyslogProtocolHandler.prompt(byArray, 8192));
        }
        if ((n3 = SyslogProtocolHandler.indexOfXML(byArray, n, Math.min(200, n2))) != -1) {
            int n4 = n2 - n3 + n;
            auditRecordRepository.onMessage(byArray, n3, n4, connection, inetAddress);
        } else {
            LOG.warn("Ignore unexpected message from {}: {}", (Object)inetAddress, (Object)SyslogProtocolHandler.prompt(byArray, 200));
        }
    }

    private static int indexOfXML(byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4 = -1;
        while (n3 <= n2) {
            if (byArray[n3] == 60) {
                if (SyslogProtocolHandler.isAuditMessage(byArray, n3) || SyslogProtocolHandler.isIHEYr4(byArray, n3)) {
                    return n4 == -1 ? n3 : n4;
                }
                if (n4 == -1 && SyslogProtocolHandler.isXMLDecl(byArray, n3)) {
                    n4 = n3;
                }
            }
            ++n3;
        }
        return -1;
    }

    private static boolean isXMLDecl(byte[] byArray, int n) {
        return n + 4 < byArray.length && byArray[n + 1] == 63 && byArray[n + 2] == 120 && byArray[n + 3] == 109 && byArray[n + 4] == 108;
    }

    private static boolean isAuditMessage(byte[] byArray, int n) {
        return n + 12 < byArray.length && byArray[n + 1] == 65 && byArray[n + 2] == 117 && byArray[n + 3] == 100 && byArray[n + 4] == 105 && byArray[n + 5] == 116 && byArray[n + 6] == 77 && byArray[n + 7] == 101 && byArray[n + 8] == 115 && byArray[n + 9] == 115 && byArray[n + 10] == 97 && byArray[n + 11] == 103 && byArray[n + 12] == 101;
    }

    private static boolean isIHEYr4(byte[] byArray, int n) {
        return n + 6 < byArray.length && byArray[n + 1] == 73 && byArray[n + 2] == 72 && byArray[n + 3] == 69 && byArray[n + 4] == 89 && byArray[n + 5] == 114 && byArray[n + 6] == 52;
    }

    private static String prompt(byte[] byArray, int n) {
        try {
            return byArray.length > n ? String.valueOf(new String(byArray, 0, n, "UTF-8")) + "..." : new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }
}

