/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.service;

import java.io.IOException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.PDVInputStream;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.DicomService;

public abstract class AbstractDicomService
implements DicomService {
    private final String[] sopClasses;

    protected AbstractDicomService(String ... stringArray) {
        this.sopClasses = (String[])stringArray.clone();
    }

    @Override
    public final String[] getSOPClasses() {
        return this.sopClasses;
    }

    @Override
    public void onClose(Association association) {
    }

    @Override
    public void onDimseRQ(Association association, PresentationContext presentationContext, Dimse dimse, Attributes attributes, PDVInputStream pDVInputStream) throws IOException {
        this.onDimseRQ(association, presentationContext, dimse, attributes, this.readDataset(presentationContext, pDVInputStream));
    }

    private Attributes readDataset(PresentationContext presentationContext, PDVInputStream pDVInputStream) throws IOException {
        if (pDVInputStream == null) {
            return null;
        }
        Attributes attributes = pDVInputStream.readDataset(presentationContext.getTransferSyntax());
        Dimse.LOG.debug("Dataset:\n{}", (Object)attributes);
        return attributes;
    }

    protected abstract void onDimseRQ(Association var1, PresentationContext var2, Dimse var3, Attributes var4, Attributes var5) throws IOException;
}

