/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.UID;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.DataWriter;
import org.dcm4che3.net.DimseRSPHandler;
import org.dcm4che3.net.InputStreamDataWriter;
import org.dcm4che3.net.service.BasicCStoreSCUResp;
import org.dcm4che3.net.service.CStoreSCU;
import org.dcm4che3.net.service.InstanceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCStoreSCU<T extends InstanceLocator>
extends Observable
implements CStoreSCU<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(BasicCStoreSCU.class);
    protected volatile int status = 65280;
    protected int priority = 0;
    protected int nr_instances;
    protected List<T> completed = Collections.synchronizedList(new ArrayList());
    protected List<T> warning = Collections.synchronizedList(new ArrayList());
    protected List<T> failed = Collections.synchronizedList(new ArrayList());
    protected int outstandingRSP = 0;
    protected Object outstandingRSPLock = new Object();

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public boolean cancel() {
        if (this.status == 65280) {
            this.status = 65024;
            return true;
        }
        return false;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public List<T> getCompleted() {
        return this.completed;
    }

    @Override
    public List<T> getWarning() {
        return this.warning;
    }

    @Override
    public List<T> getFailed() {
        return this.failed;
    }

    @Override
    public int getRemaining() {
        return this.nr_instances - this.completed.size() - this.warning.size() - this.failed.size();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public BasicCStoreSCUResp cstore(List<T> var1_1, Association var2_2, int var3_3) {
        if (var2_2 == null) {
            throw new IllegalStateException("null Store Association");
        }
        if (var1_1 == null) {
            throw new IllegalStateException("null Store Instances");
        }
        this.nr_instances = var1_1.size();
        try {
            var4_4 = var1_1.iterator();
            block11: while (var4_4.hasNext()) {
                var5_5 = (InstanceLocator)var4_4.next();
                if (this.status == 65024) break;
                try {
                    var6_6 = this.selectTransferSyntaxFor(var2_2, var5_5);
                    var7_7 = this.createDataWriter(var5_5, var6_6);
                }
                catch (Exception var8_9) {
                    BasicCStoreSCU.LOG.info("Unable to store {}/{} to {}", new Object[]{UID.nameOf(var5_5.cuid), UID.nameOf(var5_5.tsuid), var2_2.getRemoteAET(), var8_9});
                    this.failed.add(var5_5);
                    continue;
                }
                try {
                    this.cstore(var2_2, var5_5, var6_6, var7_7);
                    continue;
                }
                catch (Exception var8_10) {
                    BasicCStoreSCU.LOG.warn("Unable to perform sub-operation on association to {}", (Object)var2_2.getRemoteAET(), (Object)var8_10);
                    this.failed.add(var5_5);
                    ** while (var4_4.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    this.failed.add((InstanceLocator)var4_4.next());
                    continue;
lbl32:
                    // 1 sources

                }
            }
            this.waitForOutstandingCStoreRSP(var2_2);
            this.setFinalStatus();
            var10_11 = this.makeRSP(this.status);
            return var10_11;
        }
        finally {
            try {
                this.close();
            }
            catch (Throwable var11_12) {
                BasicCStoreSCU.LOG.warn("Exception thrown by {}.close()", (Object)this.getClass().getName(), (Object)var11_12);
            }
        }
    }

    private void setFinalStatus() {
        if (this.status != 65024) {
            this.status = this.failed.size() > 0 ? (this.failed.size() == this.nr_instances ? 42754 : 45056) : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForOutstandingCStoreRSP(Association association) {
        try {
            Object object = this.outstandingRSPLock;
            synchronized (object) {
                while (this.outstandingRSP > 0) {
                    this.outstandingRSPLock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            LOG.warn("Failed to wait for outstanding RSP on association to {}", (Object)association.getRemoteAET(), (Object)interruptedException);
        }
    }

    protected void releaseStoreAssociation(Association association) {
        try {
            association.release();
        }
        catch (IOException iOException) {
            LOG.warn("Failed to release association to {}", (Object)association.getRemoteAET(), (Object)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int cstore(Association association, T t, String string, DataWriter dataWriter) throws IOException, InterruptedException {
        int n = association.nextMessageID();
        CStoreRSPHandler cStoreRSPHandler = new CStoreRSPHandler(this, n, t);
        association.cstore(((InstanceLocator)t).cuid, ((InstanceLocator)t).iuid, this.priority, dataWriter, string, cStoreRSPHandler);
        Object object = this.outstandingRSPLock;
        synchronized (object) {
            ++this.outstandingRSP;
        }
        return n;
    }

    protected String selectTransferSyntaxFor(Association association, T t) throws Exception {
        return ((InstanceLocator)t).tsuid;
    }

    protected DataWriter createDataWriter(T t, String string) throws Exception {
        DicomInputStream dicomInputStream = new DicomInputStream(((InstanceLocator)t).getFile());
        dicomInputStream.readFileMetaInformation();
        return new InputStreamDataWriter(dicomInputStream);
    }

    private BasicCStoreSCUResp makeRSP(int n) {
        BasicCStoreSCUResp basicCStoreSCUResp = new BasicCStoreSCUResp();
        basicCStoreSCUResp.setStatus(n);
        basicCStoreSCUResp.setCompleted(this.completed.size());
        basicCStoreSCUResp.setFailed(this.failed.size());
        basicCStoreSCUResp.setWarning(this.warning.size());
        if (!this.failed.isEmpty()) {
            String[] stringArray = new String[this.failed.size()];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = ((InstanceLocator)this.failed.get((int)0)).iuid;
                ++n2;
            }
            basicCStoreSCUResp.setFailedUIDs(stringArray);
        }
        return basicCStoreSCUResp;
    }

    protected void close() {
    }

    private static final class CStoreRSPHandler
    extends DimseRSPHandler {
        private final T inst;
        final /* synthetic */ BasicCStoreSCU this$0;

        public CStoreRSPHandler(int n, T t) {
            this.this$0 = var1_1;
            super(n);
            this.inst = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDimseRSP(Association association, Attributes attributes, Attributes attributes2) {
            super.onDimseRSP(association, attributes, attributes2);
            int n = attributes.getInt(2304, -1);
            if (n == 0) {
                this.this$0.completed.add(this.inst);
            } else if ((n & 0xB000) == 45056) {
                this.this$0.warning.add(this.inst);
            } else {
                this.this$0.failed.add(this.inst);
            }
            Object object = this.this$0.outstandingRSPLock;
            synchronized (object) {
                if (--this.this$0.outstandingRSP == 0) {
                    this.this$0.outstandingRSPLock.notify();
                }
            }
            this.this$0.setChanged();
            this.this$0.notifyObservers();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClose(Association association) {
            super.onClose(association);
            Object object = this.this$0.outstandingRSPLock;
            synchronized (object) {
                this.this$0.outstandingRSP = 0;
                this.this$0.outstandingRSPLock.notify();
            }
        }
    }
}

