/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.service;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Commands;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.QueryTask;

public class BasicQueryTask
implements QueryTask {
    protected final Association as;
    protected final PresentationContext pc;
    protected final Attributes rq;
    protected final Attributes keys;
    protected volatile boolean canceled;
    protected boolean optionalKeysNotSupported = false;

    public BasicQueryTask(Association association, PresentationContext presentationContext, Attributes attributes, Attributes attributes2) {
        this.as = association;
        this.pc = presentationContext;
        this.rq = attributes;
        this.keys = attributes2;
    }

    public boolean isOptionalKeysNotSupported() {
        return this.optionalKeysNotSupported;
    }

    public void setOptionalKeysNotSupported(boolean bl) {
        this.optionalKeysNotSupported = bl;
    }

    @Override
    public void onCancelRQ(Association association) {
        this.canceled = true;
    }

    @Override
    public void run() {
        try {
            int n = this.rq.getInt(272, -1);
            this.as.addCancelRQHandler(n, this);
            try {
                try {
                    while (!this.canceled && this.hasMoreMatches()) {
                        Attributes attributes = this.adjust(this.nextMatch());
                        if (attributes == null) continue;
                        int n2 = this.optionalKeysNotSupported ? 65281 : 65280;
                        this.as.writeDimseRSP(this.pc, Commands.mkCFindRSP(this.rq, n2), attributes);
                    }
                    int n3 = this.canceled ? 65024 : 0;
                    this.as.writeDimseRSP(this.pc, Commands.mkCFindRSP(this.rq, n3));
                }
                catch (DicomServiceException dicomServiceException) {
                    Attributes attributes = dicomServiceException.mkRSP(32800, n);
                    this.as.writeDimseRSP(this.pc, attributes, dicomServiceException.getDataset());
                    this.as.removeCancelRQHandler(n);
                    this.close();
                }
            }
            finally {
                this.as.removeCancelRQHandler(n);
                this.close();
            }
        }
        catch (IOException iOException) {}
    }

    protected void close() {
    }

    protected Attributes nextMatch() throws DicomServiceException {
        throw new NoSuchElementException();
    }

    protected boolean hasMoreMatches() throws DicomServiceException {
        return false;
    }

    protected Attributes adjust(Attributes attributes) throws DicomServiceException {
        String[] stringArray;
        if (attributes == null) {
            return null;
        }
        Attributes attributes2 = new Attributes(attributes.size());
        if (!this.keys.contains(524293) && (stringArray = attributes.getStrings(524293)) != null) {
            attributes2.setString(524293, VR.CS, stringArray);
        }
        attributes2.addSelected(attributes, this.keys);
        return attributes2;
    }
}

