/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.service;

import java.io.IOException;
import java.util.List;
import java.util.Observable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Commands;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.CStoreSCU;
import org.dcm4che3.net.service.InstanceLocator;
import org.dcm4che3.net.service.RetrieveTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicRetrieveTask<T extends InstanceLocator>
implements RetrieveTask {
    protected static final Logger LOG = LoggerFactory.getLogger(BasicRetrieveTask.class);
    protected final List<T> insts;
    protected final Dimse rq;
    protected final Association rqas;
    protected final Association storeas;
    protected final PresentationContext pc;
    protected final Attributes rqCmd;
    protected final int msgId;
    protected final int priority;
    protected boolean pendingRSP;
    protected int pendingRSPInterval;
    protected int outstandingRSP = 0;
    protected Object outstandingRSPLock = new Object();
    private CStoreSCU<T> storescu;
    private ScheduledFuture<?> writePendingRSP;

    public BasicRetrieveTask(Dimse dimse, Association association, PresentationContext presentationContext, Attributes attributes, List<T> list, Association association2, CStoreSCU<T> cStoreSCU) {
        this.rq = dimse;
        this.rqas = association;
        this.storeas = association2;
        this.pc = presentationContext;
        this.rqCmd = attributes;
        this.insts = list;
        this.msgId = attributes.getInt(272, -1);
        this.priority = attributes.getInt(1792, 0);
        this.storescu = cStoreSCU;
    }

    public void setSendPendingRSP(boolean bl) {
        this.pendingRSP = bl;
    }

    public void setSendPendingRSPInterval(int n) {
        this.pendingRSPInterval = n;
    }

    public boolean isCMove() {
        return this.rq == Dimse.C_MOVE_RQ;
    }

    public Association getRequestAssociation() {
        return this.rqas;
    }

    public Association getStoreAssociation() {
        return this.storeas;
    }

    @Override
    public void onCancelRQ(Association association) {
        this.storescu.cancel();
    }

    @Override
    public void run() {
        this.rqas.addCancelRQHandler(this.msgId, this);
        ((Observable)((Object)this.storescu)).addObserver(this);
        try {
            if (this.pendingRSPInterval > 0) {
                this.startWritingAsyncRSP();
            }
            this.storescu.cstore(this.insts, this.storeas, this.priority);
            if (this.isCMove()) {
                this.releaseStoreAssociation(this.storeas);
            }
            this.stopWritingAsyncRSP();
            this.writeRSP();
        }
        finally {
            this.rqas.removeCancelRQHandler(this.msgId);
            try {
                this.close();
            }
            catch (Throwable throwable) {
                LOG.warn("Exception thrown by {}.close()", (Object)this.getClass().getName(), (Object)throwable);
            }
        }
    }

    protected void releaseStoreAssociation(Association association) {
        try {
            association.release();
        }
        catch (IOException iOException) {
            LOG.warn("{}: failed to release association to {}", new Object[]{this.rqas, association.getRemoteAET(), iOException});
        }
    }

    private void startWritingAsyncRSP() {
        this.writePendingRSP = this.rqas.getApplicationEntity().getDevice().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                BasicRetrieveTask.this.writeRSP();
            }
        }, 0L, this.pendingRSPInterval, TimeUnit.SECONDS);
    }

    private void stopWritingAsyncRSP() {
        if (this.writePendingRSP != null) {
            this.writePendingRSP.cancel(false);
        }
    }

    private void writeRSP() {
        try {
            Attributes attributes = Commands.mkRSP(this.rqCmd, this.storescu.getStatus(), this.rq);
            if (this.storescu.getStatus() == 65280 || this.storescu.getStatus() == 65024) {
                attributes.setInt(4128, VR.US, this.storescu.getRemaining());
            }
            attributes.setInt(4129, VR.US, this.storescu.getCompleted().size());
            attributes.setInt(4130, VR.US, this.storescu.getFailed().size());
            attributes.setInt(4131, VR.US, this.storescu.getWarning().size());
            Attributes attributes2 = null;
            if (!this.storescu.getFailed().isEmpty() && this.storescu.getStatus() != 65280) {
                attributes2 = new Attributes(1);
                String[] stringArray = new String[this.storescu.getFailed().size()];
                int n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = ((InstanceLocator)this.storescu.getFailed().get((int)n)).iuid;
                    ++n;
                }
                attributes2.setString(524376, VR.UI, stringArray);
            }
            this.rqas.writeDimseRSP(this.pc, attributes, attributes2);
        }
        catch (IOException iOException) {
            this.pendingRSP = false;
            this.stopWritingAsyncRSP();
            LOG.warn("{}: Unable to send C-GET or C-MOVE RSP on association to {}", new Object[]{this.rqas, this.rqas.getRemoteAET(), iOException});
        }
    }

    protected void close() {
    }

    @Override
    public void update(Observable observable, Object object) {
        this.storescu = (CStoreSCU)((Object)observable);
        if (this.pendingRSP && this.storescu.getStatus() == 65280) {
            this.writeRSP();
        }
    }
}

