/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.service;

import java.io.IOException;
import java.util.HashMap;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.DimseRQHandler;
import org.dcm4che3.net.PDVInputStream;
import org.dcm4che3.net.pdu.CommonExtendedNegotiation;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.DicomServiceException;

public class DicomServiceRegistry
implements DimseRQHandler {
    private final HashMap<String, DimseRQHandler> services = new HashMap();

    public void addDicomService(DicomService dicomService) {
        this.addDimseRQHandler(dicomService, dicomService.getSOPClasses());
    }

    public synchronized void addDimseRQHandler(DimseRQHandler dimseRQHandler, String ... stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.services.put(string, dimseRQHandler);
            ++n2;
        }
    }

    public void removeDicomService(DicomService dicomService) {
        this.removeDimseRQHandler(dicomService.getSOPClasses());
    }

    public synchronized void removeDimseRQHandler(String ... stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.services.remove(string);
            ++n2;
        }
    }

    @Override
    public void onDimseRQ(Association association, PresentationContext presentationContext, Dimse dimse, Attributes attributes, PDVInputStream pDVInputStream) throws IOException {
        try {
            this.lookupService(association, dimse, attributes).onDimseRQ(association, presentationContext, dimse, attributes, pDVInputStream);
        }
        catch (DicomServiceException dicomServiceException) {
            Association.LOG.info("{}: processing {} failed. Caused by:\t", new Object[]{association, dimse.toString(attributes, presentationContext.getPCID(), presentationContext.getTransferSyntax()), dicomServiceException});
            Attributes attributes2 = dicomServiceException.mkRSP(dimse.commandFieldOfRSP(), attributes.getInt(272, 0));
            association.tryWriteDimseRSP(presentationContext, attributes2, dicomServiceException.getDataset());
        }
    }

    private DimseRQHandler lookupService(Association association, Dimse dimse, Attributes attributes) throws DicomServiceException {
        String string = attributes.getString(dimse.tagOfSOPClassUID());
        if (string == null) {
            throw new DicomServiceException(530);
        }
        DimseRQHandler dimseRQHandler = this.services.get(string);
        if (dimseRQHandler != null) {
            return dimseRQHandler;
        }
        if (dimse == Dimse.C_STORE_RQ) {
            CommonExtendedNegotiation commonExtendedNegotiation = association.getCommonExtendedNegotiationFor(string);
            if (commonExtendedNegotiation != null) {
                String[] stringArray = commonExtendedNegotiation.getRelatedGeneralSOPClassUIDs();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray[n2];
                    dimseRQHandler = this.services.get(string2);
                    if (dimseRQHandler != null) {
                        return dimseRQHandler;
                    }
                    ++n2;
                }
                dimseRQHandler = this.services.get(commonExtendedNegotiation.getServiceClassUID());
                if (dimseRQHandler != null) {
                    return dimseRQHandler;
                }
            }
            if ((dimseRQHandler = this.services.get("*")) != null) {
                return dimseRQHandler;
            }
        }
        throw new DicomServiceException(dimse.isCService() ? 290 : 280);
    }

    @Override
    public void onClose(Association association) {
        for (DimseRQHandler dimseRQHandler : this.services.values()) {
            dimseRQHandler.onClose(association);
        }
    }
}

