/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.service;

import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IOD;
import org.dcm4che3.data.VR;
import org.dcm4che3.data.ValidationResult;
import org.dcm4che3.net.service.DicomServiceException;

public enum QueryRetrieveLevel {
    PATIENT,
    STUDY,
    SERIES,
    IMAGE,
    FRAME{

        @Override
        protected IOD queryKeysIOD(QueryRetrieveLevel queryRetrieveLevel, boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected IOD retrieveKeysIOD(QueryRetrieveLevel queryRetrieveLevel, boolean bl) {
            return IMAGE.retrieveKeysIOD(queryRetrieveLevel, bl);
        }
    };

    private static final int[] UNIQUE_KEYS;
    private static final VR[] UNIQUE_KEYS_VR;
    private static final int[] UNIQUE_KEYS_VM;

    static {
        UNIQUE_KEYS = new int[]{0x100020, 0x20000D, 0x20000E, 524312};
        UNIQUE_KEYS_VR = new VR[]{VR.LO, VR.UI, VR.UI, VR.UI};
        UNIQUE_KEYS_VM = new int[]{1, -1, -1, -1};
    }

    private QueryRetrieveLevel() {
    }

    public void validateQueryKeys(Attributes attributes, QueryRetrieveLevel queryRetrieveLevel, boolean bl) throws DicomServiceException {
        QueryRetrieveLevel.check(attributes.validate(this.queryKeysIOD(queryRetrieveLevel, bl)));
    }

    public void validateRetrieveKeys(Attributes attributes, QueryRetrieveLevel queryRetrieveLevel, boolean bl) throws DicomServiceException {
        QueryRetrieveLevel.check(attributes.validate(this.retrieveKeysIOD(queryRetrieveLevel, bl)));
    }

    protected IOD queryKeysIOD(QueryRetrieveLevel queryRetrieveLevel, boolean bl) {
        if (this.compareTo(queryRetrieveLevel) < 0) {
            throw new IllegalArgumentException("rootLevel:" + (Object)((Object)queryRetrieveLevel));
        }
        IOD iOD = new IOD();
        int n = 0;
        while (n < queryRetrieveLevel.ordinal()) {
            iOD.add(new IOD.DataElement(UNIQUE_KEYS[n], UNIQUE_KEYS_VR[n], IOD.DataElementType.TYPE_3, 1, 1, 0));
            ++n;
        }
        n = this.ordinal();
        IOD.DataElementType dataElementType = bl ? IOD.DataElementType.TYPE_3 : IOD.DataElementType.TYPE_1;
        int n2 = queryRetrieveLevel.ordinal();
        while (n2 < n) {
            iOD.add(new IOD.DataElement(UNIQUE_KEYS[n2], UNIQUE_KEYS_VR[n2], dataElementType, 1, 1, 0));
            ++n2;
        }
        n2 = n + 1;
        while (n2 < UNIQUE_KEYS.length) {
            iOD.add(new IOD.DataElement(UNIQUE_KEYS[n2], VR.UI, IOD.DataElementType.TYPE_0, -1, -1, 0));
            ++n2;
        }
        return iOD;
    }

    protected IOD retrieveKeysIOD(QueryRetrieveLevel queryRetrieveLevel, boolean bl) {
        if (this.compareTo(queryRetrieveLevel) < 0) {
            throw new IllegalArgumentException("rootLevel:" + (Object)((Object)queryRetrieveLevel));
        }
        IOD iOD = new IOD();
        int n = 0;
        while (n < queryRetrieveLevel.ordinal()) {
            iOD.add(new IOD.DataElement(UNIQUE_KEYS[n], UNIQUE_KEYS_VR[n], IOD.DataElementType.TYPE_0, -1, -1, 0));
            ++n;
        }
        n = this.ordinal();
        IOD.DataElementType dataElementType = bl ? IOD.DataElementType.TYPE_3 : IOD.DataElementType.TYPE_1;
        int n2 = queryRetrieveLevel.ordinal();
        while (n2 < n) {
            iOD.add(new IOD.DataElement(UNIQUE_KEYS[n2], UNIQUE_KEYS_VR[n2], dataElementType, 1, 1, 0));
            ++n2;
        }
        iOD.add(new IOD.DataElement(UNIQUE_KEYS[n], UNIQUE_KEYS_VR[n], IOD.DataElementType.TYPE_1, UNIQUE_KEYS_VM[n], UNIQUE_KEYS_VM[n], 0));
        n2 = n + 1;
        while (n2 < UNIQUE_KEYS.length) {
            iOD.add(new IOD.DataElement(UNIQUE_KEYS[n2], VR.UI, IOD.DataElementType.TYPE_0, -1, -1, 0));
            ++n2;
        }
        return iOD;
    }

    private static void check(ValidationResult validationResult) throws DicomServiceException {
        if (!validationResult.isValid()) {
            throw new DicomServiceException(43264, validationResult.getErrorComment()).setOffendingElements(validationResult.getOffendingElements());
        }
    }

    public static QueryRetrieveLevel valueOf(String string) {
        return Enum.valueOf(QueryRetrieveLevel.class, string);
    }

    /* synthetic */ QueryRetrieveLevel(String string, int n, QueryRetrieveLevel queryRetrieveLevel) {
        this();
    }
}

