/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.util;

public class ByteUtils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final int[] EMPTY_INTS = new int[0];
    public static final float[] EMPTY_FLOATS = new float[0];
    public static final double[] EMPTY_DOUBLES = new double[0];

    public static int bytesToVR(byte[] byArray, int n) {
        return ByteUtils.bytesToUShortBE(byArray, n);
    }

    public static int bytesToUShort(byte[] byArray, int n, boolean bl) {
        return bl ? ByteUtils.bytesToUShortBE(byArray, n) : ByteUtils.bytesToUShortLE(byArray, n);
    }

    public static int bytesToUShortBE(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF);
    }

    public static int bytesToUShortLE(byte[] byArray, int n) {
        return ((byArray[n + 1] & 0xFF) << 8) + (byArray[n] & 0xFF);
    }

    public static int bytesToShort(byte[] byArray, int n, boolean bl) {
        return bl ? ByteUtils.bytesToShortBE(byArray, n) : ByteUtils.bytesToShortLE(byArray, n);
    }

    public static int bytesToShortBE(byte[] byArray, int n) {
        return (byArray[n] << 8) + (byArray[n + 1] & 0xFF);
    }

    public static int bytesToShortLE(byte[] byArray, int n) {
        return (byArray[n + 1] << 8) + (byArray[n] & 0xFF);
    }

    public static void bytesToShorts(byte[] byArray, int n, short[] sArray, int n2, int n3, boolean bl) {
        if (bl) {
            ByteUtils.bytesToShortsBE(byArray, n, sArray, n2, n3);
        } else {
            ByteUtils.bytesToShortsLE(byArray, n, sArray, n2, n3);
        }
    }

    public static void bytesToShortsBE(byte[] byArray, int n, short[] sArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            sArray[n2 + n4] = (short)ByteUtils.bytesToShortBE(byArray, n + (n4 << 1));
            ++n4;
        }
    }

    public static void bytesToShortsLE(byte[] byArray, int n, short[] sArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            sArray[n2 + n4] = (short)ByteUtils.bytesToShortLE(byArray, n + (n4 << 1));
            ++n4;
        }
    }

    public static int bytesToInt(byte[] byArray, int n, boolean bl) {
        return bl ? ByteUtils.bytesToIntBE(byArray, n) : ByteUtils.bytesToIntLE(byArray, n);
    }

    public static int bytesToIntBE(byte[] byArray, int n) {
        return (byArray[n] << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
    }

    public static int bytesToIntLE(byte[] byArray, int n) {
        return (byArray[n + 3] << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 1] & 0xFF) << 8) + (byArray[n] & 0xFF);
    }

    public static int bytesToTag(byte[] byArray, int n, boolean bl) {
        return bl ? ByteUtils.bytesToTagBE(byArray, n) : ByteUtils.bytesToTagLE(byArray, n);
    }

    public static int bytesToTagBE(byte[] byArray, int n) {
        return ByteUtils.bytesToIntBE(byArray, n);
    }

    public static int bytesToTagLE(byte[] byArray, int n) {
        return (byArray[n + 1] << 24) + ((byArray[n] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 8) + (byArray[n + 2] & 0xFF);
    }

    public static float bytesToFloat(byte[] byArray, int n, boolean bl) {
        return bl ? ByteUtils.bytesToFloatBE(byArray, n) : ByteUtils.bytesToFloatLE(byArray, n);
    }

    public static float bytesToFloatBE(byte[] byArray, int n) {
        return Float.intBitsToFloat(ByteUtils.bytesToIntBE(byArray, n));
    }

    public static float bytesToFloatLE(byte[] byArray, int n) {
        return Float.intBitsToFloat(ByteUtils.bytesToIntLE(byArray, n));
    }

    public static long bytesToLong(byte[] byArray, int n, boolean bl) {
        return bl ? ByteUtils.bytesToLongBE(byArray, n) : ByteUtils.bytesToLongLE(byArray, n);
    }

    public static long bytesToLongBE(byte[] byArray, int n) {
        return ((long)byArray[n] << 56) + ((long)(byArray[n + 1] & 0xFF) << 48) + ((long)(byArray[n + 2] & 0xFF) << 40) + ((long)(byArray[n + 3] & 0xFF) << 32) + ((long)(byArray[n + 4] & 0xFF) << 24) + (long)((byArray[n + 5] & 0xFF) << 16) + (long)((byArray[n + 6] & 0xFF) << 8) + (long)(byArray[n + 7] & 0xFF);
    }

    public static long bytesToLongLE(byte[] byArray, int n) {
        return ((long)byArray[n + 7] << 56) + ((long)(byArray[n + 6] & 0xFF) << 48) + ((long)(byArray[n + 5] & 0xFF) << 40) + ((long)(byArray[n + 4] & 0xFF) << 32) + ((long)(byArray[n + 3] & 0xFF) << 24) + (long)((byArray[n + 2] & 0xFF) << 16) + (long)((byArray[n + 1] & 0xFF) << 8) + (long)(byArray[n] & 0xFF);
    }

    public static double bytesToDouble(byte[] byArray, int n, boolean bl) {
        return bl ? ByteUtils.bytesToDoubleBE(byArray, n) : ByteUtils.bytesToDoubleLE(byArray, n);
    }

    public static double bytesToDoubleBE(byte[] byArray, int n) {
        return Double.longBitsToDouble(ByteUtils.bytesToLongBE(byArray, n));
    }

    public static double bytesToDoubleLE(byte[] byArray, int n) {
        return Double.longBitsToDouble(ByteUtils.bytesToLongLE(byArray, n));
    }

    public static byte[] shortToBytes(int n, byte[] byArray, int n2, boolean bl) {
        return bl ? ByteUtils.shortToBytesBE(n, byArray, n2) : ByteUtils.shortToBytesLE(n, byArray, n2);
    }

    public static byte[] shortToBytesBE(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 8);
        byArray[n2 + 1] = (byte)n;
        return byArray;
    }

    public static byte[] shortToBytesLE(int n, byte[] byArray, int n2) {
        byArray[n2 + 1] = (byte)(n >> 8);
        byArray[n2] = (byte)n;
        return byArray;
    }

    public static byte[] intToBytes(int n, byte[] byArray, int n2, boolean bl) {
        return bl ? ByteUtils.intToBytesBE(n, byArray, n2) : ByteUtils.intToBytesLE(n, byArray, n2);
    }

    public static byte[] intToBytesBE(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 24);
        byArray[n2 + 1] = (byte)(n >> 16);
        byArray[n2 + 2] = (byte)(n >> 8);
        byArray[n2 + 3] = (byte)n;
        return byArray;
    }

    public static byte[] intToBytesLE(int n, byte[] byArray, int n2) {
        byArray[n2 + 3] = (byte)(n >> 24);
        byArray[n2 + 2] = (byte)(n >> 16);
        byArray[n2 + 1] = (byte)(n >> 8);
        byArray[n2] = (byte)n;
        return byArray;
    }

    public static byte[] tagToBytes(int n, byte[] byArray, int n2, boolean bl) {
        return bl ? ByteUtils.tagToBytesBE(n, byArray, n2) : ByteUtils.tagToBytesLE(n, byArray, n2);
    }

    public static byte[] tagToBytesBE(int n, byte[] byArray, int n2) {
        return ByteUtils.intToBytesBE(n, byArray, n2);
    }

    public static byte[] tagToBytesLE(int n, byte[] byArray, int n2) {
        byArray[n2 + 1] = (byte)(n >> 24);
        byArray[n2] = (byte)(n >> 16);
        byArray[n2 + 3] = (byte)(n >> 8);
        byArray[n2 + 2] = (byte)n;
        return byArray;
    }

    public static byte[] floatToBytes(float f, byte[] byArray, int n, boolean bl) {
        return bl ? ByteUtils.floatToBytesBE(f, byArray, n) : ByteUtils.floatToBytesLE(f, byArray, n);
    }

    public static byte[] floatToBytesBE(float f, byte[] byArray, int n) {
        return ByteUtils.intToBytesBE(Float.floatToIntBits(f), byArray, n);
    }

    public static byte[] floatToBytesLE(float f, byte[] byArray, int n) {
        return ByteUtils.intToBytesLE(Float.floatToIntBits(f), byArray, n);
    }

    public static byte[] doubleToBytes(double d, byte[] byArray, int n, boolean bl) {
        return bl ? ByteUtils.doubleToBytesBE(d, byArray, n) : ByteUtils.doubleToBytesLE(d, byArray, n);
    }

    public static byte[] doubleToBytesBE(double d, byte[] byArray, int n) {
        return ByteUtils.longToBytesBE(Double.doubleToLongBits(d), byArray, n);
    }

    public static byte[] doubleToBytesLE(double d, byte[] byArray, int n) {
        return ByteUtils.longToBytesLE(Double.doubleToLongBits(d), byArray, n);
    }

    public static byte[] longToBytes(long l, byte[] byArray, int n, boolean bl) {
        return bl ? ByteUtils.longToBytesBE(l, byArray, n) : ByteUtils.longToBytesLE(l, byArray, n);
    }

    public static byte[] longToBytesBE(long l, byte[] byArray, int n) {
        byArray[n] = (byte)(l >> 56);
        byArray[n + 1] = (byte)(l >> 48);
        byArray[n + 2] = (byte)(l >> 40);
        byArray[n + 3] = (byte)(l >> 32);
        byArray[n + 4] = (byte)(l >> 24);
        byArray[n + 5] = (byte)(l >> 16);
        byArray[n + 6] = (byte)(l >> 8);
        byArray[n + 7] = (byte)l;
        return byArray;
    }

    public static byte[] longToBytesLE(long l, byte[] byArray, int n) {
        byArray[n + 7] = (byte)(l >> 56);
        byArray[n + 6] = (byte)(l >> 48);
        byArray[n + 5] = (byte)(l >> 40);
        byArray[n + 4] = (byte)(l >> 32);
        byArray[n + 3] = (byte)(l >> 24);
        byArray[n + 2] = (byte)(l >> 16);
        byArray[n + 1] = (byte)(l >> 8);
        byArray[n] = (byte)l;
        return byArray;
    }

    public static byte[][] swapShorts(byte[][] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            byte[] byArray2 = byArray[n2];
            if (n != 0) {
                ByteUtils.swapLastFirst(byArray[n2 - 1], byArray2);
            }
            int n3 = byArray2.length - n;
            ByteUtils.swapShorts(byArray2, n, n3 & 0xFFFFFFFE);
            n = n3 & 1;
            ++n2;
        }
        return byArray;
    }

    public static byte[] swapShorts(byte[] byArray, int n, int n2) {
        ByteUtils.checkLength(n2, 2);
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            ByteUtils.swap(byArray, n3, n3 + 1);
            n3 += 2;
        }
        return byArray;
    }

    public static byte[] swapInts(byte[] byArray, int n, int n2) {
        ByteUtils.checkLength(n2, 4);
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            ByteUtils.swap(byArray, n3, n3 + 3);
            ByteUtils.swap(byArray, n3 + 1, n3 + 2);
            n3 += 4;
        }
        return byArray;
    }

    public static byte[] swapLongs(byte[] byArray, int n, int n2) {
        ByteUtils.checkLength(n2, 8);
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            ByteUtils.swap(byArray, n3, n3 + 7);
            ByteUtils.swap(byArray, n3 + 1, n3 + 6);
            ByteUtils.swap(byArray, n3 + 2, n3 + 5);
            ByteUtils.swap(byArray, n3 + 3, n3 + 4);
            n3 += 8;
        }
        return byArray;
    }

    private static void checkLength(int n, int n2) {
        if (n < 0 || n % n2 != 0) {
            throw new IllegalArgumentException("length: " + n);
        }
    }

    private static void swap(byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        byArray[n] = byArray[n2];
        byArray[n2] = by;
    }

    private static void swapLastFirst(byte[] byArray, byte[] byArray2) {
        int n = byArray.length - 1;
        byte by = byArray2[0];
        byArray2[0] = byArray[n];
        byArray[n] = by;
    }
}

