/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.util;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class StringUtils {
    public static String LINE_SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });
    public static String[] EMPTY_STRING = new String[0];

    public static StringBuilder appendLine(StringBuilder stringBuilder, Object ... objectArray) {
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            stringBuilder.append(object);
            ++n2;
        }
        return stringBuilder.append(LINE_SEPARATOR);
    }

    public static String concat(String[] stringArray, char c) {
        Object object;
        int n = stringArray.length;
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            String string = stringArray[0];
            return string != null ? string : "";
        }
        int n2 = n - 1;
        Object object2 = stringArray;
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object = object2[n4];
            if (object != null) {
                n2 += ((String)object).length();
            }
            ++n4;
        }
        object = new char[n2];
        n4 = 0;
        n3 = 0;
        while (n4 < n) {
            if (n4 != 0) {
                object[n3++] = c;
            }
            if ((object2 = stringArray[n4]) != null) {
                int n5 = ((String)object2).length();
                ((String)object2).getChars(0, n5, (char[])object, n3);
                n3 += n5;
            }
            ++n4;
        }
        return new String((char[])object);
    }

    public static Object splitAndTrim(String string, char c) {
        int n = 1;
        int n2 = -1;
        while ((n2 = string.indexOf(c, n2 + 1)) >= 0) {
            ++n;
        }
        if (n == 1) {
            return StringUtils.substring(string, 0, string.length());
        }
        String[] stringArray = new String[n];
        int n3 = string.length();
        while (--n >= 0) {
            n2 = string.lastIndexOf(c, n3 - 1);
            stringArray[n] = StringUtils.substring(string, n2 + 1, n3);
            n3 = n2;
        }
        return stringArray;
    }

    public static String[] split(String string, char c) {
        if (string == null || string.isEmpty()) {
            return EMPTY_STRING;
        }
        int n = 1;
        int n2 = -1;
        while ((n2 = string.indexOf(c, n2 + 1)) >= 0) {
            ++n;
        }
        if (n == 1) {
            return new String[]{string};
        }
        String[] stringArray = new String[n];
        int n3 = string.length();
        while (--n >= 0) {
            n2 = string.lastIndexOf(c, n3 - 1);
            stringArray[n] = string.substring(n2 + 1, n3);
            n3 = n2;
        }
        return stringArray;
    }

    public static String cut(String string, int n, char c) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        while ((n2 = string.indexOf(c, n4)) >= 0) {
            if (n3++ == n) {
                return string.substring(n4, n2);
            }
            n4 = n2 + 1;
        }
        return n3 == n ? string.substring(n4) : "";
    }

    private static String substring(String string, int n, int n2) {
        while (n < n2 && string.charAt(n) <= ' ') {
            ++n;
        }
        while (n < n2 && string.charAt(n2 - 1) <= ' ') {
            --n2;
        }
        return n < n2 ? string.substring(n, n2) : "";
    }

    public static String trimTrailing(String string) {
        int n = string.length();
        while (n > 0 && string.charAt(n - 1) <= ' ') {
            --n;
        }
        return string.substring(0, n);
    }

    public static int parseIS(String string) {
        return string != null && string.length() != 0 ? Integer.parseInt(string.charAt(0) == '+' ? string.substring(1) : string) : 0;
    }

    public static double parseDS(String string) {
        return string != null && string.length() != 0 ? Double.parseDouble(string.replace(',', '.')) : 0.0;
    }

    public static String formatDS(float f) {
        int n;
        String string = Float.toString(f);
        if (string.startsWith(".0", (n = string.length()) - 2)) {
            return string.substring(0, n - 2);
        }
        int n2 = string.indexOf(69, n - 5);
        return n2 > 0 && string.startsWith(".0", n2 - 2) ? StringUtils.cut(string, n2 - 2, n2) : string;
    }

    public static String formatDS(double d) {
        int n;
        String string = Double.toString(d);
        if (string.startsWith(".0", (n = string.length()) - 2)) {
            return string.substring(0, n - 2);
        }
        int n2 = n - 16;
        int n3 = string.indexOf(69, n - 5);
        return n3 < 0 ? (n2 > 0 ? string.substring(0, 16) : string) : (string.startsWith(".0", n3 - 2) ? StringUtils.cut(string, n3 - 2, n3) : (n2 > 0 ? StringUtils.cut(string, n3 - n2, n3) : string));
    }

    private static String cut(String string, int n, int n2) {
        int n3 = string.length();
        char[] cArray = new char[n3 - (n2 - n)];
        string.getChars(0, n, cArray, 0);
        string.getChars(n2, n3, cArray, n);
        return new String(cArray);
    }

    public static boolean matches(String string, String string2, boolean bl, boolean bl2) {
        if (string2 == null || string2.isEmpty()) {
            return true;
        }
        if (string == null || string.isEmpty()) {
            return bl;
        }
        return StringUtils.containsWildCard(string2) ? StringUtils.compilePattern(string2, bl2).matcher(string).matches() : (bl2 ? string2.equalsIgnoreCase(string) : string2.equals(string));
    }

    public static Pattern compilePattern(String string, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "*?", true);
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            char c = string2.charAt(0);
            if (c == '*') {
                stringBuilder.append(".*");
                continue;
            }
            if (c == '?') {
                stringBuilder.append(".");
                continue;
            }
            stringBuilder.append("\\Q").append(string2).append("\\E");
        }
        return Pattern.compile(stringBuilder.toString(), bl ? 2 : 0);
    }

    public static boolean containsWildCard(String string) {
        return string.indexOf(42) >= 0 || string.indexOf(63) >= 0;
    }

    public static String[] maskNull(String[] stringArray) {
        return StringUtils.maskNull(stringArray, EMPTY_STRING);
    }

    public static <T> T maskNull(T t, T t2) {
        return t == null ? t2 : t;
    }

    public static <T> T nullify(T t, T t2) {
        return t2.equals(t) ? null : (T)t;
    }

    public static String maskEmpty(String string, String string2) {
        return string == null || string.isEmpty() ? string2 : string;
    }

    public static String truncate(String string, int n) {
        return string.length() > n ? string.substring(0, n) : string;
    }

    public static <T> boolean equals(T t, T t2) {
        return t == t2 || t != null && t.equals(t2);
    }

    public static String replaceSystemProperties(String string) {
        int n = string.indexOf("${");
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = -1;
        do {
            stringBuilder.append(string.substring(n2 + 1, n));
            n2 = string.indexOf(125, n + 2);
            if (n2 == -1) {
                n2 = n - 1;
                break;
            }
            String string2 = System.getProperty(string.substring(n + 2, n2));
            stringBuilder.append(string2 != null ? string2 : string.substring(n, n2 + 1));
        } while ((n = string.indexOf("${", n2 + 1)) != -1);
        stringBuilder.append(string.substring(n2 + 1));
        return stringBuilder.toString();
    }

    @Deprecated
    public static String resourceURL(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = classLoader.getResource(string);
        return uRL != null ? uRL.toString() : null;
    }

    public static boolean isUpperCase(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (Character.toUpperCase(c) != c) {
                return false;
            }
            ++n2;
        }
        return n != 0;
    }
}

