/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.util;

public class TagUtils {
    private static char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String shortToHexString(int n) {
        char[] cArray = new char[]{HEX_DIGITS[n >>> 12 & 0xF], HEX_DIGITS[n >>> 8 & 0xF], HEX_DIGITS[n >>> 4 & 0xF], HEX_DIGITS[n >>> 0 & 0xF]};
        return new String(cArray);
    }

    public static String toHexString(int n) {
        char[] cArray = new char[]{HEX_DIGITS[n >>> 28], HEX_DIGITS[n >>> 24 & 0xF], HEX_DIGITS[n >>> 20 & 0xF], HEX_DIGITS[n >>> 16 & 0xF], HEX_DIGITS[n >>> 12 & 0xF], HEX_DIGITS[n >>> 8 & 0xF], HEX_DIGITS[n >>> 4 & 0xF], HEX_DIGITS[n >>> 0 & 0xF]};
        return new String(cArray);
    }

    public static String toHexString(byte[] byArray) {
        char[] cArray = new char[byArray.length << 1];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            cArray[n2++] = HEX_DIGITS[byArray[n] >>> 4 & 0xF];
            cArray[n2++] = HEX_DIGITS[byArray[n] & 0xF];
            ++n;
        }
        return new String(cArray);
    }

    public static String toString(int n) {
        char[] cArray = new char[]{'(', HEX_DIGITS[n >>> 28], HEX_DIGITS[n >>> 24 & 0xF], HEX_DIGITS[n >>> 20 & 0xF], HEX_DIGITS[n >>> 16 & 0xF], ',', HEX_DIGITS[n >>> 12 & 0xF], HEX_DIGITS[n >>> 8 & 0xF], HEX_DIGITS[n >>> 4 & 0xF], HEX_DIGITS[n >>> 0 & 0xF], ')'};
        return new String(cArray);
    }

    public static int groupNumber(int n) {
        return n >>> 16;
    }

    public static int elementNumber(int n) {
        return n & 0xFFFF;
    }

    public static boolean isGroupLength(int n) {
        return TagUtils.elementNumber(n) == 0;
    }

    public static boolean isPrivateCreator(int n) {
        return (n & 0x10000) != 0 && (n & 0xFF00) == 0 && (n & 0xF0) != 0;
    }

    public static boolean isPrivateGroup(int n) {
        return (n & 0x10000) != 0;
    }

    public static boolean isPrivateTag(int n) {
        return (n & 0x10000) != 0 && (n & 0xFF00) != 0;
    }

    public static int toTag(int n, int n2) {
        return n << 16 | n2;
    }

    public static int toPrivateTag(int n, int n2) {
        return n & 0xFFFF0000 | ((n & 0xFF) << 8 | n2 & 0xFF);
    }

    public static int creatorTagOf(int n) {
        return n & 0xFFFF0000 | n >>> 8 & 0xFF;
    }

    public static int groupLengthTagOf(int n) {
        return n & 0xFFFF0000;
    }

    public static boolean isItem(int n) {
        return n == -73728 || n == -73715 || n == -73507;
    }

    public static boolean isFileMetaInformation(int n) {
        return (n & 0xFFFF0000) == 131072;
    }

    public static int normalizeRepeatingGroup(int n) {
        int n2 = n & 0xFFE00000;
        return n2 == 0x50000000 || n2 == 0x60000000 ? n & 0xFFE0FFFF : n;
    }
}

