/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonNumber;
import javax.json.JsonValue;

abstract class JsonNumberImpl
implements JsonNumber {
    JsonNumberImpl() {
    }

    static JsonNumber getJsonNumber(int n) {
        return new JsonIntNumber(n);
    }

    static JsonNumber getJsonNumber(long l) {
        return new JsonLongNumber(l);
    }

    static JsonNumber getJsonNumber(BigInteger bigInteger) {
        return new JsonBigDecimalNumber(new BigDecimal(bigInteger));
    }

    static JsonNumber getJsonNumber(double d) {
        return new JsonBigDecimalNumber(BigDecimal.valueOf(d));
    }

    static JsonNumber getJsonNumber(BigDecimal bigDecimal) {
        return new JsonBigDecimalNumber(bigDecimal);
    }

    @Override
    public boolean isIntegral() {
        return this.bigDecimalValue().scale() == 0;
    }

    @Override
    public int intValue() {
        return this.bigDecimalValue().intValue();
    }

    @Override
    public int intValueExact() {
        return this.bigDecimalValue().intValueExact();
    }

    @Override
    public long longValue() {
        return this.bigDecimalValue().longValue();
    }

    @Override
    public long longValueExact() {
        return this.bigDecimalValue().longValueExact();
    }

    @Override
    public double doubleValue() {
        return this.bigDecimalValue().doubleValue();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.bigDecimalValue().toBigInteger();
    }

    @Override
    public BigInteger bigIntegerValueExact() {
        return this.bigDecimalValue().toBigIntegerExact();
    }

    @Override
    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    @Override
    public int hashCode() {
        return this.bigDecimalValue().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof JsonNumber)) {
            return false;
        }
        JsonNumber jsonNumber = (JsonNumber)object;
        return this.bigDecimalValue().equals(jsonNumber.bigDecimalValue());
    }

    @Override
    public String toString() {
        return this.bigDecimalValue().toString();
    }

    private static final class JsonBigDecimalNumber
    extends JsonNumberImpl {
        private final BigDecimal bigDecimal;

        JsonBigDecimalNumber(BigDecimal bigDecimal) {
            this.bigDecimal = bigDecimal;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            return this.bigDecimal;
        }
    }

    private static final class JsonIntNumber
    extends JsonNumberImpl {
        private final int num;
        private BigDecimal bigDecimal;

        JsonIntNumber(int n) {
            this.num = n;
        }

        @Override
        public boolean isIntegral() {
            return true;
        }

        @Override
        public int intValue() {
            return this.num;
        }

        @Override
        public int intValueExact() {
            return this.num;
        }

        @Override
        public long longValue() {
            return this.num;
        }

        @Override
        public long longValueExact() {
            return this.num;
        }

        @Override
        public double doubleValue() {
            return this.num;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            BigDecimal bigDecimal = this.bigDecimal;
            if (bigDecimal == null) {
                this.bigDecimal = bigDecimal = new BigDecimal(this.num);
            }
            return bigDecimal;
        }

        @Override
        public String toString() {
            return Integer.toString(this.num);
        }
    }

    private static final class JsonLongNumber
    extends JsonNumberImpl {
        private final long num;
        private BigDecimal bigDecimal;

        JsonLongNumber(long l) {
            this.num = l;
        }

        @Override
        public boolean isIntegral() {
            return true;
        }

        @Override
        public long longValue() {
            return this.num;
        }

        @Override
        public long longValueExact() {
            return this.num;
        }

        @Override
        public double doubleValue() {
            return this.num;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            BigDecimal bigDecimal = this.bigDecimal;
            if (bigDecimal == null) {
                this.bigDecimal = bigDecimal = new BigDecimal(this.num);
            }
            return bigDecimal;
        }

        @Override
        public String toString() {
            return Long.toString(this.num);
        }
    }
}

