/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.json.stream.JsonGenerator;
import org.glassfish.json.JsonGeneratorImpl;
import org.glassfish.json.api.BufferPool;

public class JsonPrettyGeneratorImpl
extends JsonGeneratorImpl {
    private int indentLevel;
    private static final String INDENT = "    ";

    public JsonPrettyGeneratorImpl(Writer writer, BufferPool bufferPool) {
        super(writer, bufferPool);
    }

    public JsonPrettyGeneratorImpl(OutputStream outputStream, BufferPool bufferPool) {
        super(outputStream, bufferPool);
    }

    public JsonPrettyGeneratorImpl(OutputStream outputStream, Charset charset, BufferPool bufferPool) {
        super(outputStream, charset, bufferPool);
    }

    @Override
    public JsonGenerator writeStartObject() {
        super.writeStartObject();
        ++this.indentLevel;
        return this;
    }

    @Override
    public JsonGenerator writeStartObject(String string) {
        super.writeStartObject(string);
        ++this.indentLevel;
        return this;
    }

    @Override
    public JsonGenerator writeStartArray() {
        super.writeStartArray();
        ++this.indentLevel;
        return this;
    }

    @Override
    public JsonGenerator writeStartArray(String string) {
        super.writeStartArray(string);
        ++this.indentLevel;
        return this;
    }

    @Override
    public JsonGenerator writeEnd() {
        this.writeNewLine();
        --this.indentLevel;
        this.writeIndent();
        super.writeEnd();
        return this;
    }

    private void writeIndent() {
        int n = 0;
        while (n < this.indentLevel) {
            this.writeString(INDENT);
            ++n;
        }
    }

    @Override
    protected void writeComma() {
        super.writeComma();
        this.writeChar('\n');
        this.writeIndent();
    }

    private void writeNewLine() {
        this.writeChar('\n');
    }
}

