/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import org.glassfish.json.JsonArrayBuilderImpl;
import org.glassfish.json.JsonMessages;
import org.glassfish.json.JsonObjectBuilderImpl;
import org.glassfish.json.JsonParserImpl;
import org.glassfish.json.api.BufferPool;

class JsonReaderImpl
implements JsonReader {
    private final JsonParserImpl parser;
    private boolean readDone;
    private final BufferPool bufferPool;

    JsonReaderImpl(Reader reader, BufferPool bufferPool) {
        this.parser = new JsonParserImpl(reader, bufferPool);
        this.bufferPool = bufferPool;
    }

    JsonReaderImpl(InputStream inputStream, BufferPool bufferPool) {
        this.parser = new JsonParserImpl(inputStream, bufferPool);
        this.bufferPool = bufferPool;
    }

    JsonReaderImpl(InputStream inputStream, Charset charset, BufferPool bufferPool) {
        this.parser = new JsonParserImpl(inputStream, charset, bufferPool);
        this.bufferPool = bufferPool;
    }

    @Override
    public JsonStructure read() {
        if (this.readDone) {
            throw new IllegalStateException(JsonMessages.READER_READ_ALREADY_CALLED());
        }
        this.readDone = true;
        if (this.parser.hasNext()) {
            JsonParser.Event event = this.parser.next();
            if (event == JsonParser.Event.START_ARRAY) {
                return this.readArray(new JsonArrayBuilderImpl(this.bufferPool));
            }
            if (event == JsonParser.Event.START_OBJECT) {
                return this.readObject(new JsonObjectBuilderImpl(this.bufferPool));
            }
        }
        throw new JsonException("Internal Error");
    }

    @Override
    public JsonObject readObject() {
        if (this.readDone) {
            throw new IllegalStateException(JsonMessages.READER_READ_ALREADY_CALLED());
        }
        this.readDone = true;
        if (this.parser.hasNext()) {
            JsonParser.Event event = this.parser.next();
            if (event == JsonParser.Event.START_OBJECT) {
                return this.readObject(new JsonObjectBuilderImpl(this.bufferPool));
            }
            if (event == JsonParser.Event.START_ARRAY) {
                throw new JsonException(JsonMessages.READER_EXPECTED_OBJECT_GOT_ARRAY());
            }
        }
        throw new JsonException("Internal Error");
    }

    @Override
    public JsonArray readArray() {
        if (this.readDone) {
            throw new IllegalStateException(JsonMessages.READER_READ_ALREADY_CALLED());
        }
        this.readDone = true;
        if (this.parser.hasNext()) {
            JsonParser.Event event = this.parser.next();
            if (event == JsonParser.Event.START_ARRAY) {
                return this.readArray(new JsonArrayBuilderImpl(this.bufferPool));
            }
            if (event == JsonParser.Event.START_OBJECT) {
                throw new JsonException(JsonMessages.READER_EXPECTED_ARRAY_GOT_OBJECT());
            }
        }
        throw new JsonException("Internal Error");
    }

    @Override
    public void close() {
        this.readDone = true;
        this.parser.close();
    }

    private JsonArray readArray(JsonArrayBuilder jsonArrayBuilder) {
        while (this.parser.hasNext()) {
            JsonParser.Event event = this.parser.next();
            switch (event) {
                case START_ARRAY: {
                    JsonArray jsonArray = this.readArray(new JsonArrayBuilderImpl(this.bufferPool));
                    jsonArrayBuilder.add(jsonArray);
                    break;
                }
                case START_OBJECT: {
                    JsonObject jsonObject = this.readObject(new JsonObjectBuilderImpl(this.bufferPool));
                    jsonArrayBuilder.add(jsonObject);
                    break;
                }
                case VALUE_STRING: {
                    jsonArrayBuilder.add(this.parser.getString());
                    break;
                }
                case VALUE_NUMBER: {
                    if (this.parser.isDefinitelyInt()) {
                        jsonArrayBuilder.add(this.parser.getInt());
                        break;
                    }
                    jsonArrayBuilder.add(this.parser.getBigDecimal());
                    break;
                }
                case VALUE_TRUE: {
                    jsonArrayBuilder.add(JsonValue.TRUE);
                    break;
                }
                case VALUE_FALSE: {
                    jsonArrayBuilder.add(JsonValue.FALSE);
                    break;
                }
                case VALUE_NULL: {
                    jsonArrayBuilder.addNull();
                    break;
                }
                case END_ARRAY: {
                    return jsonArrayBuilder.build();
                }
                default: {
                    throw new JsonException("Internal Error");
                }
            }
        }
        throw new JsonException("Internal Error");
    }

    private JsonObject readObject(JsonObjectBuilder jsonObjectBuilder) {
        String string = null;
        while (this.parser.hasNext()) {
            JsonParser.Event event = this.parser.next();
            switch (event) {
                case START_ARRAY: {
                    JsonArray jsonArray = this.readArray(new JsonArrayBuilderImpl(this.bufferPool));
                    jsonObjectBuilder.add(string, jsonArray);
                    break;
                }
                case START_OBJECT: {
                    JsonObject jsonObject = this.readObject(new JsonObjectBuilderImpl(this.bufferPool));
                    jsonObjectBuilder.add(string, jsonObject);
                    break;
                }
                case KEY_NAME: {
                    string = this.parser.getString();
                    break;
                }
                case VALUE_STRING: {
                    jsonObjectBuilder.add(string, this.parser.getString());
                    break;
                }
                case VALUE_NUMBER: {
                    if (this.parser.isDefinitelyInt()) {
                        jsonObjectBuilder.add(string, this.parser.getInt());
                        break;
                    }
                    jsonObjectBuilder.add(string, this.parser.getBigDecimal());
                    break;
                }
                case VALUE_TRUE: {
                    jsonObjectBuilder.add(string, JsonValue.TRUE);
                    break;
                }
                case VALUE_FALSE: {
                    jsonObjectBuilder.add(string, JsonValue.FALSE);
                    break;
                }
                case VALUE_NULL: {
                    jsonObjectBuilder.addNull(string);
                    break;
                }
                case END_OBJECT: {
                    return jsonObjectBuilder.build();
                }
                default: {
                    throw new JsonException("Internal Error");
                }
            }
        }
        throw new JsonException("Internal Error");
    }
}

