/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.net.URL;
import java.security.AccessController;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.equinox.internal.app.Activator;
import org.eclipse.equinox.internal.app.AppPersistence;
import org.eclipse.equinox.internal.app.EclipseAppContainer;
import org.eclipse.equinox.internal.app.EclipseAppHandle;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.service.condpermadmin.BundleSignerCondition;
import org.osgi.service.condpermadmin.ConditionInfo;

public class EclipseAppDescriptor
extends ApplicationDescriptor {
    static final String APP_TYPE = "eclipse.application.type";
    static final String APP_DEFAULT = "eclipse.application.default";
    static final String APP_TYPE_MAIN_THREAD = "main.thread";
    static final String APP_TYPE_ANY_THREAD = "any.thread";
    static final int FLAG_VISIBLE = 1;
    static final int FLAG_CARD_SINGLETON_GLOGAL = 2;
    static final int FLAG_CARD_SINGLETON_SCOPED = 4;
    static final int FLAG_CARD_UNLIMITED = 8;
    static final int FLAG_CARD_LIMITED = 16;
    static final int FLAG_TYPE_MAIN_THREAD = 32;
    static final int FLAG_TYPE_ANY_THREAD = 64;
    static final int FLAG_DEFAULT_APP = 128;
    private long instanceID = 0L;
    private ServiceRegistration sr;
    private Boolean locked = Boolean.FALSE;
    private final EclipseAppContainer appContainer;
    private final Bundle contributor;
    private final int flags;
    private final int cardinality;
    private final String name;
    private final URL iconURL;
    private final boolean[] registrationLock = new boolean[]{true};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected EclipseAppDescriptor(Bundle bundle, String string, String string2, String string3, int n, int n2, EclipseAppContainer eclipseAppContainer) {
        super(string);
        this.name = string2;
        this.contributor = bundle;
        this.appContainer = eclipseAppContainer;
        this.locked = AppPersistence.isLocked(this) ? Boolean.TRUE : Boolean.FALSE;
        this.flags = n;
        this.cardinality = n2;
        URL uRL = null;
        if (string3 != null && string3.length() > 0) {
            Enumeration enumeration;
            if (string3.charAt(0) == '/') {
                string3 = string3.substring(1);
            }
            String string4 = "/";
            String string5 = string3;
            int n3 = string3.lastIndexOf(47);
            if (n3 > 0 && n3 < string3.length() - 1) {
                string4 = string3.substring(0, n3);
                string5 = string3.substring(n3 + 1);
            }
            if ((enumeration = bundle.findEntries(string4, string5, false)) != null && enumeration.hasMoreElements()) {
                uRL = (URL)enumeration.nextElement();
            }
        }
        this.iconURL = uRL;
    }

    protected Map getPropertiesSpecific(String string) {
        return this.getServiceProperties();
    }

    protected ApplicationHandle launchSpecific(Map map) throws Exception {
        if (this.getLocked().booleanValue()) {
            throw new IllegalStateException("Cannot launch a locked application.");
        }
        EclipseAppHandle eclipseAppHandle = this.createAppHandle(map);
        try {
            this.appContainer.launch(eclipseAppHandle);
        }
        catch (Throwable throwable) {
            try {
                eclipseAppHandle.destroy();
            }
            catch (Throwable throwable2) {}
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw (Error)throwable;
        }
        return eclipseAppHandle;
    }

    protected synchronized void lockSpecific() {
        this.locked = Boolean.TRUE;
        this.refreshProperties();
    }

    protected synchronized void unlockSpecific() {
        this.locked = Boolean.FALSE;
        this.refreshProperties();
    }

    void refreshProperties() {
        ServiceRegistration serviceRegistration = this.getServiceRegistration();
        if (serviceRegistration != null) {
            try {
                serviceRegistration.setProperties((Dictionary)this.getServiceProperties());
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setServiceRegistration(ServiceRegistration serviceRegistration) {
        boolean[] blArray = this.registrationLock;
        synchronized (this.registrationLock) {
            this.sr = serviceRegistration;
            this.registrationLock[0] = serviceRegistration != null;
            this.registrationLock.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceRegistration getServiceRegistration() {
        boolean[] blArray = this.registrationLock;
        synchronized (this.registrationLock) {
            if (this.sr == null && this.registrationLock[0]) {
                try {
                    this.registrationLock.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.sr;
        }
    }

    private synchronized Boolean getLocked() {
        return this.locked;
    }

    Hashtable getServiceProperties() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(10);
        hashtable.put("service.pid", this.getApplicationId());
        if (this.name != null) {
            hashtable.put("application.name", this.name);
        }
        hashtable.put("application.container", "org.eclipse.equinox.app");
        hashtable.put("application.location", this.getLocation());
        Boolean bl = this.appContainer.isLocked(this) == 0 ? Boolean.TRUE : Boolean.FALSE;
        hashtable.put("application.launchable", bl);
        hashtable.put("application.locked", this.getLocked());
        Boolean bl2 = (this.flags & 1) != 0 ? Boolean.TRUE : Boolean.FALSE;
        hashtable.put("application.visible", bl2);
        hashtable.put(APP_TYPE, this.getThreadTypeString());
        if ((this.flags & 0x80) != 0) {
            hashtable.put(APP_DEFAULT, Boolean.TRUE);
        }
        if (this.iconURL != null) {
            hashtable.put("application.icon", this.iconURL);
        }
        return hashtable;
    }

    private String getLocation() {
        if (this.contributor == null) {
            return "";
        }
        return Activator.getLocation(this.contributor);
    }

    private EclipseAppHandle createAppHandle(Map map) throws ApplicationException {
        EclipseAppHandle eclipseAppHandle = new EclipseAppHandle(this.getInstanceID(), map, this);
        this.appContainer.lock(eclipseAppHandle);
        String[] stringArray = new String[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.application.ApplicationHandle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.equinox.app.IApplicationContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz2.getName();
        ServiceRegistration serviceRegistration = (ServiceRegistration)AccessController.doPrivileged(this.appContainer.getRegServiceAction(stringArray, eclipseAppHandle, eclipseAppHandle.getServiceProperties()));
        eclipseAppHandle.setServiceRegistration(serviceRegistration);
        return eclipseAppHandle;
    }

    EclipseAppContainer getContainerManager() {
        return this.appContainer;
    }

    public boolean matchDNChain(String string) {
        if (this.contributor == null) {
            return false;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.osgi.service.condpermadmin.BundleSignerCondition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return BundleSignerCondition.getCondition((Bundle)this.contributor, (ConditionInfo)new ConditionInfo(clazz.getName(), new String[]{string})).isSatisfied();
    }

    protected boolean isLaunchableSpecific() {
        return true;
    }

    public void unregister() {
        ServiceRegistration serviceRegistration = this.getServiceRegistration();
        if (serviceRegistration != null) {
            this.setServiceRegistration(null);
            serviceRegistration.unregister();
        }
    }

    String getThreadTypeString() {
        if ((this.flags & 0x40) != 0) {
            return APP_TYPE_ANY_THREAD;
        }
        return APP_TYPE_MAIN_THREAD;
    }

    int getThreadType() {
        return this.flags & 0x60;
    }

    int getCardinalityType() {
        return this.flags & 0x1E;
    }

    int getCardinality() {
        return this.cardinality;
    }

    private synchronized String getInstanceID() {
        if (this.instanceID == Long.MAX_VALUE) {
            this.instanceID = 0L;
        }
        return String.valueOf(this.getApplicationId()) + "." + this.instanceID++;
    }
}

