/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cdviewer;

import com.agfa.pacs.config.ConfigLevel;
import com.agfa.pacs.config.ConfigType;
import com.agfa.pacs.config.IConfigurationCache;
import com.agfa.pacs.config.IConfigurationSource;
import com.agfa.pacs.config.PacsConfigParser;
import com.agfa.pacs.impaxee.cdviewer.ConfigurationItem;
import com.agfa.pacs.impaxee.cdviewer.ConfigurationItems;
import com.agfa.pacs.impaxee.cdviewer.ServerConfigParser;
import com.agfa.pacs.logging.ALogger;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CDViewerConfig
implements IConfigurationSource {
    public static final String DEFAULT_ROLE_NAME = "Default";
    private static ALogger log = ALogger.getLogger(CDViewerConfig.class);
    private Object lock = new Object();
    private boolean initiated = false;

    public IConfigurationSource.ConfigSourcePriority getPriority() {
        return IConfigurationSource.ConfigSourcePriority.Lowest;
    }

    public boolean isSupportingRoles() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestKey(IConfigurationCache iConfigurationCache, String string, String string2, String string3) {
        if (!this.initiated) {
            Object object = this.lock;
            synchronized (object) {
                block9: {
                    if (!this.initiated) break block9;
                    return false;
                }
                try {
                    InputStream inputStream = this.getClass().getResourceAsStream("/config.xml");
                    PacsConfigParser.readModuleConfig(null, (InputStream)inputStream, (IConfigurationCache)iConfigurationCache);
                    inputStream.close();
                    File file = new File("HANGING.XML");
                    if (file.exists()) {
                        Map<String, ConfigurationItems> map = ServerConfigParser.parseCacheFiles(null, file, ConfigLevel.User);
                        for (Map.Entry<String, ConfigurationItems> entry : map.entrySet()) {
                            this.initialize(entry.getKey(), iConfigurationCache, entry.getValue());
                        }
                    }
                }
                catch (Exception exception) {
                    log.error("Config Error", (Throwable)exception);
                }
                this.initiated = true;
                return true;
            }
        }
        return false;
    }

    private void initialize(String string, IConfigurationCache iConfigurationCache, ConfigurationItems configurationItems) {
        if (configurationItems.items != null && configurationItems.items.size() > 0) {
            for (ConfigurationItem configurationItem : configurationItems.items) {
                if (configurationItem.getType() == null) continue;
                String[] stringArray = StringUtils.split((String)configurationItem.getKeyName(), (char)'.');
                try {
                    iConfigurationCache.initValue(configurationItem.getLevel(), stringArray, configurationItem.getType(), configurationItem.getValue(), DEFAULT_ROLE_NAME);
                }
                catch (Exception exception) {
                    log.error("Error on config initialisation", (Throwable)exception);
                }
            }
        }
    }

    public boolean valueModified(String string, ConfigLevel configLevel, String string2, Object object, ConfigType configType) {
        return false;
    }

    public void notifyPluginNotCached(String string, List<String> list, String string2) {
    }

    public boolean requestKeyUpdate(IConfigurationCache iConfigurationCache, String string, List<String> list, String string2) {
        return false;
    }

    public boolean requestKeyUpdate(IConfigurationCache iConfigurationCache, String string, String string2, String string3) {
        return this.requestKeyUpdate(iConfigurationCache, string, Collections.singletonList(string2), string3);
    }

    public void notifyPluginNotCached(String string, String string2, String string3) {
        this.notifyPluginNotCached(string, Collections.singletonList(string2), string3);
    }

    public void storeConfig() {
    }

    public void storeForRole(String string) {
    }
}

