/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cdviewer;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.PersonNameUtilities;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.util.PatientComparatorFactory;
import com.agfa.pacs.impaxee.cdviewer.Messages;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.glue.cycling.ImpaxEECycleListProvider;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.listtext.cycling.CycleListProviderFactory;
import com.agfa.pacs.listtext.cycling.ICycleListProvider;
import com.agfa.pacs.listtext.lta.util.DicomTagDictionaryFactory;
import com.agfa.pacs.logging.ALogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.dcm4che3.data.PersonName;

public class CDViewerStudyChooserDialog
extends JDialog
implements ListSelectionListener,
PropertyChangeListener {
    private static final ALogger log = ALogger.getLogger(CDViewerStudyChooserDialog.class);
    private static final String EVENTID_IS_SELECTED = "IS_SELECTED";
    private static List<IPatientInfo> pats;
    Map<IPatientInfo, JTable> patInfoTableMap;
    JPanel panelButtonsBottom;
    JButton btnLoad;
    JButton btnCancel;

    @Override
    public int getDefaultCloseOperation() {
        return 2;
    }

    public CDViewerStudyChooserDialog(List<IPatientInfo> list, Window window) {
        super(window);
        pats = list;
        Collections.sort(pats, PatientComparatorFactory.getPatientInfoComparator());
        this.createAndInstallComponents();
        this.setModal(true);
        this.setTitle(Messages.getString("DialogNotForDiagnost.StudySelection"));
    }

    private void createAndInstallComponents() {
        this.patInfoTableMap = new HashMap<IPatientInfo, JTable>();
        JPanel jPanel = ComponentFactory.instance.createPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        boolean bl = false;
        for (IPatientInfo object2 : pats) {
            JPanel jPanel2 = ComponentFactory.instance.createPanel((LayoutManager)new BorderLayout());
            PersonName personName = new PersonName(object2.getString(0x100010), true);
            TitledBorder titledBorder = ComponentFactory.instance.createTitledBorder(PersonNameUtilities.personNameToHRReverse((PersonName)personName));
            jPanel2.setBorder(titledBorder);
            PatientTableModel patientTableModel = new PatientTableModel(object2);
            bl = bl || patientTableModel.isOneSelected();
            patientTableModel.addPropertyChangeListener(this);
            JTable jTable = ComponentFactory.instance.createTable((TableModel)patientTableModel);
            jTable.getColumnModel().getColumn(0).setMaxWidth(GUI.getScaledDiagnosticInt((int)26));
            jTable.getColumnModel().getColumn(0).setPreferredWidth(GUI.getScaledDiagnosticInt((int)26));
            jTable.getColumnModel().getColumn(1).setMaxWidth(GUI.getScaledDiagnosticInt((int)140));
            jTable.getColumnModel().getColumn(1).setPreferredWidth(GUI.getScaledDiagnosticInt((int)140));
            jTable.getColumnModel().getColumn(2).setMaxWidth(GUI.getScaledDiagnosticInt((int)140));
            jTable.getColumnModel().getColumn(2).setPreferredWidth(GUI.getScaledDiagnosticInt((int)140));
            this.patInfoTableMap.put(object2, jTable);
            jTable.getSelectionModel().addListSelectionListener(this);
            jTable.setFillsViewportHeight(true);
            jTable.setSelectionMode(0);
            jTable.getTableHeader().setReorderingAllowed(false);
            jTable.getTableHeader().addMouseListener(new ColumnHeaderListener());
            jTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    JTable jTable;
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = (jTable = (JTable)mouseEvent.getSource()).getSelectedRow()) != -1) {
                        IStudyInfo iStudyInfo = ((PatientTableModel)jTable.getModel()).getStudyInfo(n);
                        CDViewerStudyChooserDialog.this.loadStudy(iStudyInfo);
                    }
                }
            });
            jPanel2.add((Component)jTable.getTableHeader(), "First");
            jPanel2.add((Component)jTable, "Center");
            jPanel.add(jPanel2);
        }
        JScrollPane jScrollPane = ComponentFactory.instance.createScrollPane((Component)jPanel, Integer.valueOf(20), Integer.valueOf(31), Boolean.valueOf(false), Boolean.valueOf(false));
        jScrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.add((Component)jScrollPane, "Center");
        this.panelButtonsBottom = ComponentFactory.instance.createPanel((LayoutManager)new FlowLayout(1));
        this.btnLoad = ComponentFactory.instance.createButton((Action)new LoadAction());
        this.btnLoad.setEnabled(bl);
        this.btnCancel = ComponentFactory.instance.createButton((Action)new CancelAction());
        this.panelButtonsBottom.add(this.btnLoad);
        this.panelButtonsBottom.add(this.btnCancel);
        this.add((Component)this.panelButtonsBottom, "South");
        this.pack();
        this.setSize(GUI.getScaledDiagnosticDimension((int)800, (int)((int)((double)this.getPreferredSize().height * 1.2))));
    }

    private void loadStudy(IStudyInfo iStudyInfo) {
        ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>();
        arrayList.add(iStudyInfo);
        try {
            CycleListProviderFactory.getInstance().getCycleListProvider().addToCycleListAndDisplay(arrayList, false);
            this.dispose();
        }
        catch (Exception exception) {
            log.error("Error adding study infos to cycle list!", (Throwable)exception);
        }
    }

    private void loadStudies(List<IStudyInfo> list) {
        try {
            ICycleListProvider iCycleListProvider = CycleListProviderFactory.getInstance().getCycleListProvider();
            ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>(Arrays.asList(iCycleListProvider.getStudies()));
            ArrayList<IStudyInfo> arrayList2 = new ArrayList<IStudyInfo>();
            ArrayList<IStudyInfo> arrayList3 = new ArrayList<IStudyInfo>();
            for (IStudyInfo iStudyInfo : arrayList) {
                if (this.listContaintsElement(list, iStudyInfo)) continue;
                arrayList2.add(iStudyInfo);
            }
            for (IStudyInfo iStudyInfo : list) {
                if (this.listContaintsElement(arrayList, iStudyInfo)) continue;
                arrayList3.add(iStudyInfo);
            }
            iCycleListProvider.removeFromCycleList(arrayList2, false);
            iCycleListProvider.addToCycleListAndDisplay(arrayList3, false);
            this.dispose();
        }
        catch (Exception exception) {
            log.error("Error adding study infos to cycle list!", (Throwable)exception);
        }
    }

    private boolean isMemoryEnough(List<IStudyInfo> list) {
        int n = 0;
        for (IStudyInfo iStudyInfo : list) {
            int n2 = iStudyInfo.getAttributes().getInt(2101768, 0);
            if (n2 <= 0) {
                n2 = DataInfoUtilities.getLevel((IDataInfo)iStudyInfo, (Level)Level.Object).size();
            }
            n += n2;
        }
        return DataManager.getInstance().getRequiredMemory(n) < ImpaxEECycleListProvider.AVAILABLE_MEMORY;
    }

    private boolean listContaintsElement(List<IStudyInfo> list, IStudyInfo iStudyInfo) {
        for (IStudyInfo iStudyInfo2 : list) {
            if (!iStudyInfo2.getUID().equals(iStudyInfo.getUID())) continue;
            return true;
        }
        return false;
    }

    public static List<IPatientInfo> getPatients() {
        return pats;
    }

    public void addComponent(JPanel jPanel, int n, int n2, Component component) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add(component, gridBagConstraints);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            for (JTable jTable : this.patInfoTableMap.values()) {
                ListSelectionModel listSelectionModel2 = jTable.getSelectionModel();
                if (listSelectionModel2 == listSelectionModel) continue;
                jTable.getSelectionModel().removeListSelectionListener(this);
                jTable.clearSelection();
                jTable.getSelectionModel().addListSelectionListener(this);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (EVENTID_IS_SELECTED.equals(propertyChangeEvent.getPropertyName())) {
            List<IStudyInfo> list;
            JTable object2 = null;
            for (JTable object3 : this.patInfoTableMap.values()) {
                if (object3.getModel() != propertyChangeEvent.getSource()) {
                    object3.getSelectionModel().removeListSelectionListener(this);
                    object3.clearSelection();
                    ((PatientTableModel)object3.getModel()).clearSelection();
                    object3.getSelectionModel().addListSelectionListener(this);
                    continue;
                }
                object2 = object3;
            }
            if (object2 != null && (list = this.generateSelectedStudiesList()).size() > 1 && !this.isMemoryEnough(list)) {
                JOptionPane.showMessageDialog(this, Messages.getString("StudySelect.Warning.NotEnoughMemory"));
                ((PatientTableModel)object2.getModel()).removePropertyChangeListener(this);
                int n = (Integer)propertyChangeEvent.getOldValue();
                if (n != -1) {
                    object2.getModel().setValueAt(false, n, 0);
                } else {
                    ((PatientTableModel)object2.getModel()).selectAll();
                }
                ((PatientTableModel)object2.getModel()).addPropertyChangeListener(this);
            }
            this.btnLoad.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        }
    }

    private List<IStudyInfo> generateSelectedStudiesList() {
        ArrayList<IStudyInfo> arrayList = new ArrayList<IStudyInfo>();
        for (JTable jTable : this.patInfoTableMap.values()) {
            int n = 0;
            while (n < jTable.getModel().getRowCount()) {
                if (((Boolean)jTable.getModel().getValueAt(n, 0)).booleanValue()) {
                    arrayList.add(((PatientTableModel)jTable.getModel()).getStudyInfo(n));
                }
                ++n;
            }
        }
        return arrayList;
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(Messages.getString("Close"));
            super.putValue("ShortDescription", Messages.getString("DialogNotForDiagnost.CloseTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CDViewerStudyChooserDialog.this.setVisible(false);
        }
    }

    public static class ColumnHeaderListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JTable jTable = ((JTableHeader)mouseEvent.getSource()).getTable();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = jTable.convertColumnIndexToModel(n);
            if (n != -1 && n2 == 0) {
                ((PatientTableModel)jTable.getModel()).selectAll();
            }
        }
    }

    private class LoadAction
    extends AbstractAction {
        public LoadAction() {
            super(Messages.getString("DialogNotForDiagnost.Load"));
            super.putValue("ShortDescription", Messages.getString("DialogNotForDiagnost.LoadTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List list = CDViewerStudyChooserDialog.this.generateSelectedStudiesList();
            CDViewerStudyChooserDialog.this.loadStudies(list);
        }
    }

    private static class PatientTableModel
    extends AbstractTableModel {
        Object[][] data;
        String[] columnNames = new String[]{"[x]", DicomTagDictionaryFactory.getLocaleDictionary().getNameForTag(524320), DicomTagDictionaryFactory.getLocaleDictionary().getNameForTag(524384), DicomTagDictionaryFactory.getLocaleDictionary().getNameForTag(528432)};
        Map<Integer, IStudyInfo> row2StudyInfoMap = new HashMap<Integer, IStudyInfo>();
        private List<PropertyChangeListener> propertyChangeListeners = null;

        private PatientTableModel(IPatientInfo iPatientInfo) {
            this.data = new Object[iPatientInfo.getStudies().size()][4];
            int n = 0;
            ArrayList arrayList = new ArrayList(iPatientInfo.getStudies());
            Collections.sort(arrayList, DateTimeUtils.getStudyComparator());
            for (IStudyInfo iStudyInfo : arrayList) {
                String string2;
                this.row2StudyInfoMap.put(n, iStudyInfo);
                Date date = DateTimeUtils.getStudyDateTime((IDataInfo)iStudyInfo);
                StringBuilder stringBuilder = new StringBuilder();
                for (String string2 : iStudyInfo.getSeries()) {
                    String string3 = string2.getString(524384);
                    if (stringBuilder.indexOf(string3) >= 0) continue;
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(string3);
                }
                string2 = iStudyInfo.getString(528432);
                this.data[n][0] = CycleListProviderFactory.getInstance().getCycleListProvider().isStudyDisplayed(iStudyInfo.getUID());
                this.data[n][1] = date != null ? DateTimeUtils.dateTime2String((Date)date) : "N/A";
                this.data[n][2] = stringBuilder;
                this.data[n][3] = string2;
                ++n;
            }
        }

        public void selectAll() {
            boolean bl = this.areAllSelected();
            int n = 0;
            while (n < this.data.length) {
                this.data[n][0] = !bl;
                this.fireTableCellUpdated(n, 0);
                ++n;
            }
            this.propertyChange(new PropertyChangeEvent(this, CDViewerStudyChooserDialog.EVENTID_IS_SELECTED, -1, this.isOneSelected()));
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public IStudyInfo getStudyInfo(int n) {
            return this.row2StudyInfoMap.get(n);
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.data[n][n2] = object;
                this.propertyChange(new PropertyChangeEvent(this, CDViewerStudyChooserDialog.EVENTID_IS_SELECTED, n, this.isOneSelected()));
            } else {
                super.setValueAt(object, n, n2);
            }
            super.fireTableCellUpdated(n, n2);
        }

        public void clearSelection() {
            int n = 0;
            while (n < this.data.length) {
                this.data[n][0] = false;
                super.fireTableCellUpdated(n, 0);
                ++n;
            }
        }

        public boolean isOneSelected() {
            boolean bl = false;
            int n = 0;
            while (n < this.data.length) {
                bl = bl || (Boolean)this.data[n][0] != false;
                ++n;
            }
            return bl;
        }

        public boolean areAllSelected() {
            int n = 0;
            while (n < this.data.length) {
                if (!((Boolean)this.data[n][0]).booleanValue()) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.propertyChangeListeners == null) {
                return;
            }
            this.propertyChangeListeners.remove(propertyChangeListener);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.propertyChangeListeners == null) {
                this.propertyChangeListeners = new Vector<PropertyChangeListener>();
            }
            if (this.propertyChangeListeners.indexOf(propertyChangeListener) < 0) {
                this.propertyChangeListeners.add(propertyChangeListener);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.propertyChangeListeners != null) {
                int n = 0;
                while (n < this.propertyChangeListeners.size()) {
                    this.propertyChangeListeners.get(n).propertyChange(propertyChangeEvent);
                    ++n;
                }
            }
        }
    }
}

