/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cdviewer;

import com.agfa.hap.pacs.impaxee.import_.MimeTypeMapper;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.AnonymousPAction;
import com.agfa.pacs.impaxee.actions.ui.ActionUIFactory;
import com.agfa.pacs.impaxee.actions.ui.ActionUIScope;
import com.agfa.pacs.impaxee.actions.ui.IActionUI;
import com.agfa.pacs.impaxee.cdviewer.IReportVisualizer;
import com.agfa.pacs.impaxee.cdviewer.Messages;
import com.agfa.pacs.impaxee.cdviewer.doc.DocumentReport;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.plugin.IconDefinition;
import com.agfa.pacs.listtext.lta.reports.IReport;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.OpenLink;
import com.agfa.pacs.tools.StreamUtil;
import com.agfa.pacs.tools.TempDirectoryProvider;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorCellRenderer;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import org.dcm4che3.data.Attributes;

public class ReportPanel
extends MultiMonitorPanel {
    private static final ALogger log = ALogger.getLogger(ReportPanel.class);
    private final IReportVisualizer visualizer;
    private JComboBox<IReport> comboBox;
    private IActionUI actionUI;
    private boolean isEnabled;

    public ReportPanel(IReportVisualizer iReportVisualizer) {
        super((LayoutManager)new BorderLayout());
        this.visualizer = iReportVisualizer;
        this.initComponents();
    }

    private void initComponents() {
        this.comboBox = ComponentFactory.instance.createMultiMonitorComboBox(IReport.class);
        this.comboBox.setRenderer((ListCellRenderer<IReport>)((Object)new ReportCellRenderer()));
        this.comboBox.setToolTipText(Messages.getString("Action.SelectStructuredReport.ToolTip"));
        this.add(this.comboBox, "Center");
        try {
            this.actionUI = ActionUIFactory.createUI((PAction)new OpenStructuredReportAction(), (ActionUIScope)ActionUIScope.Other);
            if (this.actionUI != null) {
                this.add(this.actionUI.getComponent(), "East");
            }
        }
        catch (Exception exception) {
            log.error("Initializing OpenSR action failed.", (Throwable)exception);
        }
    }

    void setReports(IReport[] iReportArray) {
        DefaultComboBoxModel<Object> defaultComboBoxModel = iReportArray == null || iReportArray.length == 0 ? new DefaultComboBoxModel() : new DefaultComboBoxModel<IReport>(iReportArray);
        this.comboBox.setModel(defaultComboBoxModel);
        this.isEnabled = defaultComboBoxModel.getSize() > 0;
        this.comboBox.setEnabled(this.isEnabled);
        if (this.actionUI != null) {
            this.actionUI.getAction().fireEnabledChanged();
        }
    }

    private static void openDocumentReport(IReport iReport) {
        block17: {
            Attributes attributes = iReport.getReportObject();
            try {
                String string = MimeTypeMapper.getInstance().getExtensionForMimeType(attributes.getString(4325394));
                if (string != null) {
                    File file = TempDirectoryProvider.createTemporaryFile((String)"IMPAXEE_", (String)("." + string));
                    file.deleteOnExit();
                    try {
                        Throwable throwable = null;
                        Object var5_8 = null;
                        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                            byte[] byArray = attributes.getBytes(4325393);
                            int n = byArray.length;
                            try {
                                n = (int)attributes.getDouble("TIANI", 7405670, (double)byArray.length);
                                if (n > byArray.length) {
                                    log.error("The tag RealFileSize indicates a file size that is larger than the encapsulated document!");
                                    n = byArray.length;
                                }
                            }
                            catch (Exception exception) {
                                log.error("Unable to parse tag RealFileSize as number", (Throwable)exception);
                            }
                            StreamUtil.writeStream((byte[])byArray, (int)0, (int)n, (OutputStream)outputStream);
                            OpenLink.openFile((File)file);
                            break block17;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception exception) {
                        log.error("Could not write to file", (Throwable)exception);
                    }
                    break block17;
                }
                log.warn("Unknown mime type");
            }
            catch (Exception exception) {
                log.error("Failed to store/open document report", (Throwable)exception);
            }
        }
    }

    private class OpenStructuredReportAction
    extends AnonymousPAction {
        public OpenStructuredReportAction() {
            super(new IconDefinition("openSR.svg", OpenStructuredReportAction.class));
        }

        public String getCaption() {
            return Messages.getString("Action.OpenStructuredReport.Caption");
        }

        public String getToolTipText() {
            return Messages.getString("Action.OpenStructuredReport.ToolTip");
        }

        protected boolean isEnabledImpl() {
            return ReportPanel.this.isEnabled;
        }

        public boolean perform(Component component) {
            IReport iReport = (IReport)ReportPanel.this.comboBox.getSelectedItem();
            if (iReport instanceof DocumentReport) {
                ReportPanel.openDocumentReport(iReport);
            } else {
                ReportPanel.this.visualizer.selectReport(iReport);
                ReportPanel.this.visualizer.display();
            }
            return true;
        }
    }

    private static class ReportCellRenderer
    extends MultiMonitorCellRenderer<IReport> {
        private ReportCellRenderer() {
        }

        protected String getText(IReport iReport) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(iReport.getTitle());
            if (iReport.getCreationDate() != null) {
                stringBuilder.append(" [");
                stringBuilder.append(DateTimeUtils.date2ShortString((Date)iReport.getCreationDate()));
                stringBuilder.append(']');
            }
            if (iReport.getVerificationState() != null) {
                stringBuilder.append(" (");
                stringBuilder.append(iReport.getVerificationState());
                stringBuilder.append(')');
            }
            return stringBuilder.toString();
        }

        protected String getToolTipText(IReport iReport, String string) {
            return string;
        }
    }
}

