/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cdviewer.actions;

import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.tools.OpenLink;
import java.awt.Component;
import java.io.File;
import java.util.Locale;

abstract class AbstractHelpAction
extends AbstractPAction {
    private static final String HELP_DIRECTORY_NAME = "HELP";
    private File helpFile = null;

    public AbstractHelpAction(String string, String string2) {
        super(string, AbstractHelpAction.class);
        this.initHelpFile(string2.toUpperCase(Locale.ENGLISH));
    }

    private void initHelpFile(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(Locale.getDefault().getLanguage().toUpperCase(Locale.ENGLISH));
        stringBuilder.append(".PDF");
        this.helpFile = new File(HELP_DIRECTORY_NAME, stringBuilder.toString());
        if (!this.helpFile.exists()) {
            this.helpFile = new File(HELP_DIRECTORY_NAME, String.valueOf(string) + ".PDF");
            if (!this.helpFile.exists()) {
                this.helpFile = null;
            }
        }
        if (this.helpFile != null) {
            this.helpFile = new File(this.helpFile.getAbsolutePath());
        }
    }

    protected boolean isEnabledImpl() {
        return this.helpFile != null;
    }

    public String getGroupName() {
        return "INTERNAL";
    }

    public boolean perform(Component component) {
        if (this.helpFile != null) {
            OpenLink.openFile((File)this.helpFile);
        }
        return true;
    }
}

