/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cdviewer.cache;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.impaxee.cdviewer.retriever.CDDiskPixelDataInfo;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.memcache.DataCache;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import org.dcm4che3.data.Attributes;

public class NonPersistentCache
extends DataCache {
    private static final ALogger log = ALogger.getLogger(NonPersistentCache.class);
    private static final int PERSISTANCE_DISK = 3;
    private Map<String, CDDiskPixelDataInfo> pixelDatas = Collections.synchronizedMap(new Hashtable());
    private Map<String, Object> directCache = Collections.synchronizedMap(new Hashtable());
    private int objCounter = 0;
    private long arraySize = 0L;

    public IPixelDataInfo getPixelDataInfo(String string, String string2, int n, Attributes attributes) {
        return this.pixelDatas.get(this.getKey(string2, n));
    }

    private String getKey(String string, int n) {
        return String.valueOf(string) + "_" + Integer.toString(n);
    }

    public void registerPixels(CDDiskPixelDataInfo cDDiskPixelDataInfo, String string, int n) {
        CacheID cacheID = new CacheID(this.getKey(string, n), 3);
        cDDiskPixelDataInfo.setCacheID(cacheID);
        this.pixelDatas.put(cacheID.getID(), cDDiskPixelDataInfo);
    }

    public void addPersistentBytes(byte[] byArray, CacheID cacheID) {
        if (this.directCache.containsKey(cacheID.getID())) {
            log.info("Data already in");
        }
        this.directCache.put(cacheID.getID(), byArray);
    }

    public void addPersistentInts(int[] nArray, CacheID cacheID) {
        this.directCache.put(cacheID.getID(), nArray);
    }

    public void addPersistentShorts(short[] sArray, CacheID cacheID) {
        this.directCache.put(cacheID.getID(), sArray);
    }

    public void addPersistentObject(Object object, CacheID cacheID) {
        this.directCache.put(cacheID.getID(), object);
    }

    public void addPersistentObject(Object object, Class<?> clazz, CacheID cacheID) {
        this.directCache.put(cacheID.getID(), object);
    }

    public boolean exists(Class<?> clazz, CacheID cacheID) {
        return this.directCache.containsKey(cacheID.getID());
    }

    public boolean isInMemory(CacheID cacheID) {
        return true;
    }

    public byte[] referencePersistentBytes(CacheID cacheID) {
        CDDiskPixelDataInfo cDDiskPixelDataInfo;
        if (cacheID.getType() == 3 && (cDDiskPixelDataInfo = this.pixelDatas.get(cacheID.getID())) != null) {
            return cDDiskPixelDataInfo.readFromDisk();
        }
        return (byte[])this.directCache.get(cacheID.getID());
    }

    public int[] referencePersistentInts(CacheID cacheID) {
        return (int[])this.directCache.get(cacheID.getID());
    }

    public Object referencePersistentObject(CacheID cacheID, Class<?> clazz) {
        Object object = this.directCache.get(cacheID.getID());
        if (clazz == ByteArrayContainer.class && !(object instanceof ByteArrayContainer)) {
            object = new ByteArrayContainer(this.referencePersistentBytes(cacheID));
        }
        return object;
    }

    public short[] referencePersistentShorts(CacheID cacheID) {
        return (short[])this.directCache.get(cacheID.getID());
    }

    public void releaseReference(CacheID cacheID) {
    }

    public void releaseModifiedReference(CacheID cacheID) {
        this.releaseReference(cacheID);
    }

    public void releaseModifiedArrayReference(CacheID cacheID, long[] lArray, long[] lArray2) {
        this.releaseReference(cacheID);
    }

    public void remove(CacheID cacheID) {
        Object object = this.directCache.remove(cacheID.getID());
        if (object != null) {
            if (object instanceof byte[]) {
                this.arraySize -= (long)((byte[])object).length;
            } else if (object instanceof short[]) {
                this.arraySize -= (long)(((short[])object).length * 2);
            } else if (object instanceof int[]) {
                this.arraySize -= (long)(((int[])object).length * 4);
            } else {
                --this.objCounter;
            }
            log.info("Occupied :" + this.arraySize + " and objects:" + this.objCounter);
        }
    }
}

