/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cdviewer.decoder;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IMemoryPool;
import com.agfa.pacs.data.shared.pixel.IImagePixel;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.data.shared.pixel.PixelDataException;
import com.agfa.pacs.data.shared.pixel.decoder.IPixelDataDecoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class NativeDicomPixelDataDecoder
implements IPixelDataDecoder {
    private final IMemoryPool memPool = DataCacheProviderFactory.getMemoryPool();
    private final List<String> supportedTransferSyntaxUIDs = new ArrayList<String>();

    public NativeDicomPixelDataDecoder() {
        this.supportedTransferSyntaxUIDs.add("1.2.840.10008.1.2");
        this.supportedTransferSyntaxUIDs.add("1.2.840.10008.1.2.1");
        this.supportedTransferSyntaxUIDs.add("1.2.840.10008.1.2.1.99");
        this.supportedTransferSyntaxUIDs.add("1.2.840.10008.1.2.2");
    }

    public List<String> getSupportedTransferSyntaxUIDs() {
        return new ArrayList<String>(this.supportedTransferSyntaxUIDs);
    }

    public String getType() {
        return "NATIVE";
    }

    public Object decode(IImagePixel iImagePixel, byte[] byArray, String string) throws PixelDataException {
        return this.decode(iImagePixel, new ByteArrayContainer(byArray), string);
    }

    public Object decode(IImagePixel iImagePixel, ByteArrayContainer byteArrayContainer, String string) throws PixelDataException {
        int n = iImagePixel.getBitsAllocated();
        int n2 = iImagePixel.getRows();
        int n3 = iImagePixel.getColumns();
        int n4 = n2 * n3;
        int n5 = iImagePixel.getPlanarConfiguration();
        int n6 = n4;
        PhotometricInterpretation photometricInterpretation = iImagePixel.getPhotometricInterpretation();
        byte[] byArray = byteArrayContainer.data;
        block2 : switch (n) {
            case 8: {
                switch (photometricInterpretation) {
                    case InverseMonochrome: 
                    case Monochrome: 
                    case IndexedColor: {
                        return byArray;
                    }
                    case RGBColor: {
                        switch (n5) {
                            case 0: {
                                int[] nArray = this.memPool.allocInts((long)n4);
                                int n7 = 0;
                                while (n7 < n4) {
                                    nArray[n7] = byArray[3 * n7] << 16 & 0xFF0000 | byArray[3 * n7 + 1] << 8 & 0xFF00 | byArray[3 * n7 + 2] & 0xFF;
                                    ++n7;
                                }
                                this.memPool.free(byArray);
                                return nArray;
                            }
                            case 1: {
                                int[] nArray = this.memPool.allocInts((long)n4);
                                int n8 = 0;
                                while (n8 < n4) {
                                    nArray[n8] = byArray[n8] << 16 & 0xFF0000 | byArray[n8 + n4] << 8 & 0xFF00 | byArray[n8 + n4 * 2] & 0xFF;
                                    ++n8;
                                }
                                this.memPool.free(byArray);
                                return nArray;
                            }
                        }
                        break block2;
                    }
                    case YBRFull: {
                        switch (n5) {
                            case 0: {
                                int[] nArray = this.memPool.allocInts((long)n4);
                                int n9 = 0;
                                while (n9 < n4) {
                                    int n10 = byArray[3 * n9] & 0xFF;
                                    int n11 = (byArray[3 * n9 + 1] & 0xFF) - 128;
                                    int n12 = (byArray[3 * n9 + 2] & 0xFF) - 128;
                                    int n13 = (int)((double)n10 + 1.402 * (double)n12);
                                    int n14 = (int)((double)n10 - 0.34414 * (double)n11 - 0.71414 * (double)n12);
                                    int n15 = (int)((double)n10 + 1.772 * (double)n11);
                                    nArray[n9] = n13 << 16 & 0xFF0000 | n14 << 8 & 0xFF00 | n15 & 0xFF;
                                    ++n9;
                                }
                                this.memPool.free(byArray);
                                return nArray;
                            }
                            case 1: {
                                int[] nArray = this.memPool.allocInts((long)n4);
                                int n16 = 0;
                                while (n16 < n4) {
                                    int n17 = byArray[n16] & 0xFF;
                                    int n18 = (byArray[n4 + n16] & 0xFF) - 128;
                                    int n19 = (byArray[2 * n4 + n16] & 0xFF) - 128;
                                    int n20 = (int)((double)n17 + 1.402 * (double)n19);
                                    int n21 = (int)((double)n17 - 0.34414 * (double)n18 - 0.71414 * (double)n19);
                                    int n22 = (int)((double)n17 + 1.772 * (double)n18);
                                    nArray[n16] = n20 << 16 & 0xFF0000 | n21 << 8 & 0xFF00 | n22 & 0xFF;
                                    ++n16;
                                }
                                this.memPool.free(byArray);
                                return nArray;
                            }
                        }
                        break block2;
                    }
                    case YBRFull422: {
                        int[] nArray = this.memPool.allocInts((long)n4);
                        try {
                            int n23 = 0;
                            int n24 = 0;
                            while (n24 < n4) {
                                int n25 = byArray[n23] & 0xFF;
                                int n26 = byArray[n23 + 1] & 0xFF;
                                int n27 = (byArray[n23 + 2] & 0xFF) - 128;
                                int n28 = (byArray[n23 + 3] & 0xFF) - 128;
                                n23 += 4;
                                int n29 = (int)((double)n25 + 1.402 * (double)n28);
                                int n30 = (int)((double)n25 - 0.34414 * (double)n27 - 0.71414 * (double)n28);
                                int n31 = (int)((double)n25 + 1.772 * (double)n27);
                                if (n29 < 0) {
                                    n29 = 0;
                                }
                                if (n30 < 0) {
                                    n30 = 0;
                                }
                                if (n31 < 0) {
                                    n31 = 0;
                                }
                                if (n29 > 255) {
                                    n29 = 255;
                                }
                                if (n30 > 255) {
                                    n30 = 255;
                                }
                                if (n31 > 255) {
                                    n31 = 255;
                                }
                                nArray[n24] = n29 << 16 | n30 << 8 | n31;
                                n29 = (int)((double)n26 + 1.402 * (double)n28);
                                n30 = (int)((double)n26 - 0.34414 * (double)n27 - 0.71414 * (double)n28);
                                n31 = (int)((double)n26 + 1.772 * (double)n27);
                                if (n29 < 0) {
                                    n29 = 0;
                                }
                                if (n30 < 0) {
                                    n30 = 0;
                                }
                                if (n31 < 0) {
                                    n31 = 0;
                                }
                                if (n29 > 255) {
                                    n29 = 255;
                                }
                                if (n30 > 255) {
                                    n30 = 255;
                                }
                                if (n31 > 255) {
                                    n31 = 255;
                                }
                                nArray[n24 + 1] = n29 << 16 | n30 << 8 | n31;
                                n24 += 2;
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            arrayIndexOutOfBoundsException.printStackTrace();
                        }
                        this.memPool.free(byArray);
                        return nArray;
                    }
                    case YBRPartial422: {
                        int[] nArray = this.memPool.allocInts((long)n4);
                        try {
                            int n32 = 0;
                            int n33 = 0;
                            while (n33 < n4) {
                                int n34 = (byArray[n32] & 0xFF) - 16;
                                int n35 = (byArray[n32 + 1] & 0xFF) - 16;
                                int n36 = (byArray[n32 + 2] & 0xFF) - 128;
                                int n37 = (byArray[n32 + 3] & 0xFF) - 128;
                                n32 += 4;
                                int n38 = (int)((double)n34 + 1.402 * (double)n37);
                                int n39 = (int)((double)n34 - 0.34414 * (double)n36 - 0.71414 * (double)n37);
                                int n40 = (int)((double)n34 + 1.772 * (double)n36);
                                if (n38 < 0) {
                                    n38 = 0;
                                }
                                if (n39 < 0) {
                                    n39 = 0;
                                }
                                if (n40 < 0) {
                                    n40 = 0;
                                }
                                if (n38 > 255) {
                                    n38 = 255;
                                }
                                if (n39 > 255) {
                                    n39 = 255;
                                }
                                if (n40 > 255) {
                                    n40 = 255;
                                }
                                nArray[n33] = n38 << 16 | n39 << 8 | n40;
                                n38 = (int)((double)n35 + 1.402 * (double)n37);
                                n39 = (int)((double)n35 - 0.34414 * (double)n36 - 0.71414 * (double)n37);
                                n40 = (int)((double)n35 + 1.772 * (double)n36);
                                if (n38 < 0) {
                                    n38 = 0;
                                }
                                if (n39 < 0) {
                                    n39 = 0;
                                }
                                if (n40 < 0) {
                                    n40 = 0;
                                }
                                if (n38 > 255) {
                                    n38 = 255;
                                }
                                if (n39 > 255) {
                                    n39 = 255;
                                }
                                if (n40 > 255) {
                                    n40 = 255;
                                }
                                nArray[n33 + 1] = n38 << 16 | n39 << 8 | n40;
                                n33 += 2;
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            arrayIndexOutOfBoundsException.printStackTrace();
                        }
                        this.memPool.free(byArray);
                        return nArray;
                    }
                }
                break;
            }
            case 16: {
                if (n6 > byArray.length / 2) {
                    n6 = byArray.length / 2;
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, byteArrayContainer.offset, byteArrayContainer.length);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                short[] sArray = this.memPool.allocShorts((long)n4);
                byteBuffer.asShortBuffer().get(sArray, 0, n6);
                this.memPool.free(byArray);
                return sArray;
            }
        }
        return null;
    }
}

