/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cdviewer.reports;

import com.agfa.hap.pacs.impaxee.reports.ReportType;
import com.agfa.pacs.impaxee.cdviewer.reports.CDCDAReportView;
import com.agfa.pacs.listtext.lta.reports.CDAReportViewUtil;
import com.agfa.pacs.listtext.lta.reports.IReport;
import com.agfa.pacs.listtext.lta.reports.IReportViewProvider;
import com.agfa.pacs.listtext.lta.reports.provider.AbstractReportViewProvider;
import com.agfa.pacs.listtext.lta.reports.ui.IReportView;
import com.agfa.pacs.listtext.lta.reports.ui.IReportsView;
import com.agfa.pacs.logging.ALogger;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class CDCDAReportViewProvider
extends AbstractReportViewProvider
implements IReportViewProvider,
HttpHandler {
    private Map<String, String> reportCache = new HashMap<String, String>();
    private AtomicInteger startServerLatch = new AtomicInteger(1);
    private String baseURL;

    public IReportView createReportView(IReport iReport, IReportsView iReportsView) {
        ReportType reportType = iReport.getType();
        if (CDAReportViewUtil.supportsReport((ReportType)reportType)) {
            String string = iReport.getReportInfo().getSOPInstanceUID();
            String string2 = CDAReportViewUtil.convertSRToHTML((IReport)iReport);
            this.startServer();
            this.reportCache.put(string, string2);
            CDCDAReportView cDCDAReportView = new CDCDAReportView(this.baseURL);
            cDCDAReportView.init(iReport);
            return cDCDAReportView;
        }
        return null;
    }

    private void startServer() {
        if (this.startServerLatch.decrementAndGet() == 0) {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(0);
            try {
                HttpServer httpServer = HttpServer.create(inetSocketAddress, 0);
                httpServer.createContext("/", this);
                httpServer.start();
                this.baseURL = "http://localhost:" + httpServer.getAddress().getPort() + "/";
            }
            catch (IOException iOException) {
                ALogger.getLogger(CDCDAReportViewProvider.class).error("Could not start embedded webserver");
            }
        }
    }

    protected ReportType[] getSupportedTypesImpl() {
        return new ReportType[]{ReportType.CDAReport};
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        String string;
        String string2;
        Object object;
        InetAddress inetAddress = httpExchange.getRemoteAddress().getAddress();
        if (!inetAddress.isLoopbackAddress()) {
            httpExchange.sendResponseHeaders(400, 0L);
            object = httpExchange.getResponseBody();
            ((OutputStream)object).close();
        }
        if ((string2 = this.reportCache.get(string = StringUtils.substringAfterLast((String)(object = httpExchange.getRequestURI().getPath()), (String)"/"))) == null) {
            httpExchange.sendResponseHeaders(404, 0L);
            OutputStream outputStream = httpExchange.getResponseBody();
            outputStream.close();
        } else {
            httpExchange.sendResponseHeaders(200, 0L);
            OutputStream outputStream = httpExchange.getResponseBody();
            IOUtils.write((char[])string2.toCharArray(), (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
            outputStream.close();
        }
    }
}

