/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cdviewer.security;

import com.agfa.pacs.security.permission.AuditingPermissions;
import com.agfa.pacs.security.permission.IPermission;
import com.agfa.pacs.security.permission.PermissionFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;

public class CDViewerPermissions
extends AuditingPermissions {
    private Hashtable<String, IPermission> permissions = new Hashtable();
    private Set<String> allowed = new HashSet<String>();
    private static final String PRINT_PERM = "Print";
    private static final String SHOW_UNREAD = "ViewUnreported";
    private static final String SHOW_OVERLAY_MENU = "ImageAreaPermissions/AllowedToSeeOverlaySubMenu";

    public CDViewerPermissions() {
        for (IPermission iPermission : PermissionFactory.getInstance().getPermissions()) {
            this.permissions.put(iPermission.getPath(), iPermission);
        }
        this.allowed.add(PRINT_PERM);
        this.allowed.add(SHOW_OVERLAY_MENU);
        this.allowed.add(SHOW_UNREAD);
    }

    public Set<String> getAllPermissions() {
        return Collections.unmodifiableSet(this.permissions.keySet());
    }

    public String getLocalizedName(String string) {
        return string;
    }

    public IPermission getPermission(String string) {
        return this.permissions.get(string);
    }

    public boolean isAllowed(String string, List<IAdaptable> list) {
        return this.isAllowed(string);
    }

    public boolean isAllowed(String string) {
        return this.allowed.contains(string);
    }

    public boolean isAllowedForRole(String string, String string2) {
        return this.isAllowed(string);
    }

    public Boolean isAllowedForRoleNoCollection(String string, String string2) {
        return this.isAllowed(string);
    }

    public void modifyPermissionImpl(String string, String string2, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void removePermissionSettingImpl(String string, String string2) {
        throw new UnsupportedOperationException();
    }
}

