/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.pixeldata.rle;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IMemoryPool;
import com.agfa.pacs.data.shared.pixel.IImagePixel;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.data.shared.pixel.PixelDataException;
import com.agfa.pacs.data.shared.pixel.decoder.IPixelDataDecoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class RLEPixelDataDecoder
implements IPixelDataDecoder {
    private static final IMemoryPool memPool = DataCacheProviderFactory.getMemoryPool();
    private final List<String> supportedTransferSyntaxUIDs = new ArrayList<String>();

    public RLEPixelDataDecoder() {
        this.supportedTransferSyntaxUIDs.add("1.2.840.10008.1.2.5");
    }

    public List<String> getSupportedTransferSyntaxUIDs() {
        return this.supportedTransferSyntaxUIDs;
    }

    public String getType() {
        return "RLE";
    }

    private static byte[] readFrame(ByteArrayContainer byteArrayContainer, int n) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteArrayContainer.getData(), byteArrayContainer.getOffset(), byteArrayContainer.getDataLength());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n2 = byteBuffer.getInt();
        int[] nArray = new int[n2];
        int n3 = n * n2;
        byte[] byArray = memPool.allocBytes((long)n3);
        int n4 = 0;
        while (n4 < n2) {
            nArray[n4] = byteBuffer.getInt();
            ++n4;
        }
        n4 = n2;
        int n5 = 0;
        while (n5 < n2) {
            byteBuffer.position(nArray[n5]);
            int n6 = n5;
            while (n6 < n3) {
                int n7;
                int n8;
                byte by = byteBuffer.get();
                if (!byteBuffer.hasRemaining()) break;
                if (by >= 0) {
                    n8 = by + 1;
                    n7 = 0;
                    while (n7 < n8) {
                        byArray[n6] = byteBuffer.get();
                        n6 += n4;
                        ++n7;
                    }
                    continue;
                }
                if (by <= -128) continue;
                n8 = -by + 1;
                n7 = byteBuffer.get();
                int n9 = 0;
                while (n9 < n8) {
                    byArray[n6] = n7;
                    n6 += n4;
                    ++n9;
                }
            }
            ++n5;
        }
        return byArray;
    }

    public Object decode(IImagePixel iImagePixel, byte[] byArray, String string) throws PixelDataException {
        return this.decode(iImagePixel, new ByteArrayContainer(byArray), string);
    }

    public Object decode(IImagePixel iImagePixel, ByteArrayContainer byteArrayContainer, String string) throws PixelDataException {
        int n = iImagePixel.getBitsAllocated();
        int n2 = iImagePixel.getRows();
        int n3 = iImagePixel.getColumns();
        int n4 = n2 * n3;
        PhotometricInterpretation photometricInterpretation = iImagePixel.getPhotometricInterpretation();
        byte[] byArray = RLEPixelDataDecoder.readFrame(byteArrayContainer, n4);
        switch (n) {
            case 8: {
                if (PhotometricInterpretation.InverseMonochrome.equals((Object)photometricInterpretation) || PhotometricInterpretation.Monochrome.equals((Object)photometricInterpretation)) {
                    return byArray;
                }
                if (PhotometricInterpretation.IndexedColor.equals((Object)photometricInterpretation)) {
                    return byArray;
                }
                if (PhotometricInterpretation.RGBColor.equals((Object)photometricInterpretation)) {
                    int[] nArray = memPool.allocInts((long)n4);
                    int n5 = 0;
                    while (n5 < n4) {
                        nArray[n5] = byArray[3 * n5] << 16 & 0xFF0000 | byArray[3 * n5 + 1] << 8 & 0xFF00 | byArray[3 * n5 + 2] & 0xFF;
                        ++n5;
                    }
                    memPool.free(byArray);
                    return nArray;
                }
                if (!PhotometricInterpretation.YBRFull.equals((Object)photometricInterpretation)) break;
                int[] nArray = memPool.allocInts((long)n4);
                int n6 = 0;
                while (n6 < n4) {
                    int n7 = byArray[3 * n6] & 0xFF;
                    int n8 = byArray[3 * n6 + 1] & 0xFF;
                    int n9 = byArray[3 * n6 + 2] & 0xFF;
                    int n10 = (int)((double)n7 + 1.402 * (double)(n9 - 128));
                    int n11 = (int)((double)n7 - 0.34414 * (double)(n8 - 128) - 0.71414 * (double)(n9 - 128));
                    int n12 = (int)((double)n7 + 1.772 * (double)(n8 - 128));
                    nArray[n6] = n10 << 16 & 0xFF0000 | n11 << 8 & 0xFF00 | n12 & 0xFF;
                    ++n6;
                }
                memPool.free(byArray);
                return nArray;
            }
            case 16: {
                return null;
            }
        }
        return null;
    }
}

