/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.dispatch.exp;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventDispatcher;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.event.ListenerSynchronization;
import com.agfa.pacs.event.context.EventPropagatedContext;
import com.agfa.pacs.event.context.EventPropagatedContextManager;
import com.agfa.pacs.event.dispatch.exp.StackSet;
import com.agfa.pacs.event.dispatch.exp.TaskProcessor;
import com.agfa.pacs.event.internal.Event;
import com.agfa.pacs.event.internal.Transfer;
import com.agfa.pacs.event.internal.debug.DebugStreamFactory;
import com.agfa.pacs.event.internal.debug.IDebugStream;
import com.agfa.pacs.event.internal.task.Task;
import com.agfa.pacs.event.internal.task.TaskGroup;
import com.agfa.pacs.event.internal.tools.EventEngineSemaphore;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;

public class EventDispatcher
implements IEventDispatcher {
    private static final ALogger LOGGER = ALogger.getLogger(EventDispatcher.class);
    private static final String DEBUG_STREAM_NAME = "EventDispatcher";
    private static final boolean DEBUG = DebugStreamFactory.isDebugEnabled();
    private final IDebugStream dbgStream;
    protected final List<StackSet> stack = new ArrayList<StackSet>();
    protected int countWorkingThreads;

    public EventDispatcher() {
        int n = Runtime.getRuntime().availableProcessors() - 1;
        long l = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        if (l < 196L) {
            n = 2;
        }
        this.countWorkingThreads = Math.max(2, n);
        int n2 = (int)ConfigurationProviderFactory.getConfig().getLong("com.agfa.pacs.event.processingThreads");
        if (n2 > 0) {
            this.countWorkingThreads = n2;
        }
        LOGGER.debug("Multi Processor Distribution used. (Task Processor Count = {})", (Object)this.countWorkingThreads);
        StackSet stackSet = new StackSet(0, this.countWorkingThreads, this.stack, new EventEngineSemaphore(10));
        stackSet.startThreads();
        this.stack.add(0, stackSet);
        StackSet stackSet2 = new StackSet(1, this.countWorkingThreads, this.stack, null);
        stackSet2.startThreads();
        this.stack.add(1, stackSet2);
        this.dbgStream = DEBUG ? DebugStreamFactory.getDebugStream((String)DEBUG_STREAM_NAME) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Event event) {
        int n;
        Thread thread;
        event.timestamp = System.currentTimeMillis();
        if (EventPropagatedContextManager.getThreadLocalContext() != null) {
            event.senderLocalContext = EventPropagatedContextManager.clone((EventPropagatedContext)EventPropagatedContextManager.getThreadLocalContext());
        }
        if ((thread = Thread.currentThread()) instanceof TaskProcessor) {
            n = ((TaskProcessor)thread).getStackDepth();
            event.stackDepth = n + 1;
            while (this.stack.size() <= event.stackDepth) {
                List<StackSet> list = this.stack;
                synchronized (list) {
                    StackSet stackSet = new StackSet(this.stack.size(), this.countWorkingThreads, this.stack, null);
                    stackSet.startThreads();
                    this.stack.add(stackSet);
                }
            }
        } else {
            event.stackDepth = 0;
        }
        this.distribute(event, thread, this.stack.get(event.stackDepth));
        if (event.transfer == Transfer.EXCLUSIVE) {
            n = this.waitForExclusive(event, thread) ? 1 : 0;
            if (DEBUG) {
                this.dbgStream.sdebug("Blocked to wait for listeners processing EXTERNAL event: %s", new Object[]{n != 0});
            }
        }
    }

    protected void distribute(Event event, Thread thread, StackSet stackSet) {
        TaskGroup taskGroup = null;
        try {
            boolean bl;
            if (event.transfer == Transfer.FLUSHED || event.transfer == Transfer.BLOCKING) {
                bl = this.waitForFlushing(event, thread);
                if (DEBUG) {
                    this.dbgStream.sdebug("Blocked to wait for EventEngine flushed BEFORE send(): %s", new Object[]{bl});
                }
            }
            taskGroup = new TaskGroup(event);
            if (DEBUG) {
                this.dbgStream.fdebug("******* Processing task group: %s", new Object[]{taskGroup});
            }
            if (event.stackDepth > 0) {
                IListenerSynchronization iListenerSynchronization;
                TaskProcessor taskProcessor = (TaskProcessor)thread;
                if (event.transfer == Transfer.EXCLUSIVE && (iListenerSynchronization = taskProcessor.senderHistory.getSync()) != null) {
                    Task task = taskGroup.head;
                    while (task != null) {
                        if (task.l != null && task.l.getSync() == iListenerSynchronization) {
                            ((ListenerSynchronization)iListenerSynchronization).allowBypass((IEvent)event);
                            if (DEBUG) {
                                this.dbgStream.fdebug("Allowed event bypass for listener sync: %s", new Object[]{(ListenerSynchronization)iListenerSynchronization});
                            }
                        }
                        task = task.next;
                    }
                }
            }
            this.send(taskGroup);
            if (event.transfer == Transfer.BLOCKING) {
                bl = this.waitForFlushing(event, thread);
                if (DEBUG) {
                    this.dbgStream.sdebug("Blocked to wait for EventEngine flushed after send(): %s", new Object[]{bl});
                }
            }
        }
        catch (RuntimeException runtimeException) {
            if (taskGroup == null) {
                throw runtimeException;
            }
            LOGGER.error("RuntimeException while sending event ", (Throwable)runtimeException);
        }
        catch (Throwable throwable) {
            LOGGER.error("Error while sending event ", throwable);
        }
    }

    public void send(TaskGroup taskGroup) {
        Event event = taskGroup.event;
        if (event.transfer == Transfer.EXCLUSIVE) {
            int n = event.syncSem.addP_nonBlocking(taskGroup.count);
            if (DEBUG) {
                this.dbgStream.sdebug("Acquired permits [NON BLOCKING] from exlusiveSem [%s]", new Object[]{n});
            }
        }
        StackSet stackSet = this.stack.get(event.stackDepth);
        int n = stackSet.flushSem.addP_nonBlocking(taskGroup.count);
        if (DEBUG) {
            this.dbgStream.sdebug("Acquired permits [NON BLOCKING] from StackSet[%s].flushSem [%s]", new Object[]{stackSet.stackDepth, n});
        }
        if (taskGroup.event.isInternal()) {
            stackSet.expandedTasks.putUninterruptly(taskGroup);
        } else {
            if (stackSet.maxExtSem != null && !event.isInternal()) {
                boolean bl = stackSet.maxExtSem.P_uninterruptly();
                if (DEBUG) {
                    this.dbgStream.sdebug("Blocked to acquire StackSet[%s].maxExtSem: %s", new Object[]{stackSet.stackDepth, bl});
                }
            }
            stackSet.expandedTasks.putUninterruptly(taskGroup);
        }
    }

    private boolean waitForFlushing(Event event, Thread thread) {
        boolean bl = false;
        int n = event.stackDepth;
        while (n < this.stack.size()) {
            EventEngineSemaphore eventEngineSemaphore = this.stack.get((int)n).flushSem;
            bl |= eventEngineSemaphore.P_uninterruptly();
            eventEngineSemaphore.V();
            ++n;
        }
        return bl;
    }

    private boolean waitForExclusive(Event event, Thread thread) {
        boolean bl = event.syncSem.P_uninterruptly();
        event.syncSem.V();
        return bl;
    }

    public int dbgGetStreamState() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.stack.size()) {
            n += this.stack.get((int)n2).streamSem.getCurrCount();
            ++n2;
        }
        return n / this.stack.size();
    }

    public int dbgGetExclusiveState() {
        return 1;
    }

    public int dbgGetFlushState() {
        return 1;
    }

    public int dbgGetVirtualParallelQueueDepth() {
        return this.stack.get(0).dbgGetVirtualParallelQueueDepth();
    }

    public int dbgGetExpandedTasksQueueDepth() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.stack.size()) {
            n += this.stack.get((int)n2).expandedTasks.size();
            ++n2;
        }
        n2 = 0;
        while (n2 < this.stack.size()) {
            if (this.stack.get((int)n2).expandedTasks.size() > 0) {
                LOGGER.debug("stack: " + n2 + " --- " + this.stack.get((int)n2).expandedTasks);
            }
            ++n2;
        }
        return n;
    }

    public long dbgGetPutCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.stack.size()) {
            n = (int)((long)n + this.stack.get((int)n2).exploder.getPutCount());
            ++n2;
        }
        return n;
    }

    public long dbgGetTakeCount() {
        long l = 0L;
        return l;
    }

    public String dbgDetailedIndo(String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(string) + "== Event Dispatcher ======================" + string2);
        stringBuffer.append(String.valueOf(string) + "  Size of stack: ............ " + this.stack.size() + string2);
        stringBuffer.append(String.valueOf(string) + "  Size of parallel queue: ... " + this.stack.get(0).dbgGetVirtualParallelQueueDepth() + string2);
        stringBuffer.append(string2);
        for (StackSet stackSet : this.stack) {
            stringBuffer.append(stackSet.dbgDetailedIndo(String.valueOf(string) + "  "));
        }
        stringBuffer.append(string2);
        stringBuffer.append(String.valueOf(string) + "== Event Dispatcher ======================" + string2);
        return stringBuffer.toString();
    }

    public int dbgGetThreadsCount() {
        return this.countWorkingThreads;
    }

    public int dbgGetFirstLevelExtSyncCount() {
        return this.stack.get((int)0).maxExtSem.getCurrCount();
    }
}

