/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event.dispatch.exp;

import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.ListenerSynchronization;
import com.agfa.pacs.event.dispatch.exp.InteruptableThread;
import com.agfa.pacs.event.internal.Transfer;
import com.agfa.pacs.event.internal.debug.DebugStreamFactory;
import com.agfa.pacs.event.internal.debug.IDebugStream;
import com.agfa.pacs.event.internal.debug.ThreadLocalDebugStream;
import com.agfa.pacs.event.internal.task.Task;
import com.agfa.pacs.event.internal.task.TaskCache;
import com.agfa.pacs.event.internal.task.TaskGroup;
import com.agfa.pacs.event.internal.tools.EventEngineSemaphore;
import com.agfa.pacs.logging.ALogger;
import java.util.concurrent.BlockingQueue;

public class Exploder
extends InteruptableThread {
    private static final ALogger LOGGER = ALogger.getLogger(Exploder.class);
    private static final boolean DEBUG = DebugStreamFactory.isDebugEnabled();
    private static final TaskCache taskCache = TaskCache.instance();
    private IDebugStream dbgStream;
    protected final BlockingQueue<TaskGroup> src;
    protected final BlockingQueue<Task> dst;
    private TaskGroup tg;
    protected final EventEngineSemaphore streamSem;
    protected final EventEngineSemaphore flushSem;
    protected final EventEngineSemaphore orderedSem;
    protected final EventEngineSemaphore maxExtSem;
    protected int flushSemLocalCount = 0;
    protected TaskGroup[] tmpTaskGroupArray;
    private int tmpTaskOffset = 0;
    private int tmpTaskLastCount = 0;
    protected long dbgPutCount = 0L;
    protected long dbgPutFromInsertCount = 0L;
    private static int dbgSelCount = 0;

    public static int getDbgSelCount() {
        return dbgSelCount;
    }

    public Exploder(String string, BlockingQueue<TaskGroup> blockingQueue, BlockingQueue<Task> blockingQueue2, EventEngineSemaphore eventEngineSemaphore, EventEngineSemaphore eventEngineSemaphore2, EventEngineSemaphore eventEngineSemaphore3, EventEngineSemaphore eventEngineSemaphore4) {
        this.setName("Exploder-" + string);
        this.src = blockingQueue;
        this.dst = blockingQueue2;
        this.streamSem = eventEngineSemaphore;
        this.flushSem = eventEngineSemaphore2;
        this.orderedSem = eventEngineSemaphore3;
        this.maxExtSem = eventEngineSemaphore4;
        this.tmpTaskGroupArray = new TaskGroup[200];
    }

    @Override
    public void run() {
        if (DEBUG) {
            this.dbgStream = ThreadLocalDebugStream.get();
        }
        while (this.isRunning()) {
            int n;
            this.tg = null;
            try {
                try {
                    boolean bl;
                    int n2;
                    int n3;
                    if (DEBUG) {
                        this.dbgStream.fdebug("\nSOURCE QUEUE: %s", new Object[]{this.src});
                        this.dbgStream.fdebug("\nDESTINATION QUEUE: %s", new Object[]{this.dst});
                    }
                    this.tg = (TaskGroup)this.src.poll();
                    if (this.tg == null) {
                        n3 = this.flushSem.V(this.flushSemLocalCount);
                        n2 = this.orderedSem.V(this.flushSemLocalCount);
                        if (DEBUG) {
                            this.dbgStream.sdebug("Flushed semaphors (as source queue is empty): flushSem: %s, orderedSem: %s, flushSemLocalCount = %s", new Object[]{n3, n2, this.flushSemLocalCount});
                        }
                        this.flushSemLocalCount = 0;
                        this.tg = this.src.take();
                    }
                    if (DEBUG) {
                        this.dbgStream.fdebug("**************\nPROCESSING task group: %s", new Object[]{this.tg});
                    }
                    if (this.maxExtSem != null && !this.tg.event.isInternal()) {
                        int n4 = this.maxExtSem.V();
                        if (DEBUG) {
                            this.dbgStream.sdebug("Released permit of maxExtSemCount [%s]", new Object[]{n4});
                        }
                    }
                    if (this.tmpTaskOffset < this.tmpTaskGroupArray.length) {
                        this.tmpTaskGroupArray[this.tmpTaskOffset] = null;
                    }
                    ++this.tmpTaskOffset;
                    if (this.tg.transfer == Transfer.STREAMED) {
                        boolean bl2 = this.streamSem.P();
                        if (DEBUG) {
                            this.dbgStream.sdebug("Blocked to acquire streamSem: %s", new Object[]{bl2});
                        }
                    }
                    if (this.tg.transfer == Transfer.ORDERED) {
                        n3 = this.flushSem.V(this.flushSemLocalCount);
                        n2 = this.orderedSem.V(this.flushSemLocalCount);
                        if (DEBUG) {
                            this.dbgStream.sdebug("Flushed semaphors flushSem [%s] orderedSem [%s]; flushSemLocalCount = %s", new Object[]{n3, n2, this.flushSemLocalCount});
                        }
                        this.flushSemLocalCount = 0;
                        bl = this.orderedSem.P();
                        n2 = this.orderedSem.V();
                        if (DEBUG) {
                            this.dbgStream.sdebug("Acquired and released permit from orderedSem [%s]; blocked: %s", new Object[]{n2, bl});
                        }
                    }
                    n2 = this.orderedSem.addP_nonBlocking(this.tg.count);
                    if (DEBUG) {
                        this.dbgStream.sdebug("Acquired permits [NON BLOCKING] from orderedSem [%s]", new Object[]{n2});
                    }
                    if (this.tg.event.action == ActionInfo.PROGRESS && this.src.size() > 1) {
                        this.putSelective(this.tg);
                    } else {
                        this.putAll(this.tg);
                    }
                    if (this.tg.transfer == Transfer.ORDERED) {
                        this.flushSem.V(this.flushSemLocalCount);
                        this.orderedSem.V(this.flushSemLocalCount);
                        this.flushSemLocalCount = 0;
                        bl = this.orderedSem.P();
                        n2 = this.orderedSem.V();
                        if (DEBUG) {
                            this.dbgStream.sdebug("Acquired and released permit from orderedSem [%s]; blocked: %s", new Object[]{n2, bl});
                        }
                    }
                }
                catch (Throwable throwable) {
                    LOGGER.error(String.format("Internal error in Event Engine Exploder %s", this.getName()), throwable);
                    this.tg.event = null;
                    if (this.tg.transfer == Transfer.STREAMED) {
                        n = this.streamSem.V();
                        if (DEBUG) {
                            this.dbgStream.sdebug("Released permit from streamSem [%s]", new Object[]{n});
                        }
                    }
                    if (this.tg.head == null) continue;
                    taskCache.putTask(this.tg.head);
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.tg.event = null;
                if (this.tg.transfer == Transfer.STREAMED) {
                    n = this.streamSem.V();
                    if (DEBUG) {
                        this.dbgStream.sdebug("Released permit from streamSem [%s]", new Object[]{n});
                    }
                }
                if (this.tg.head != null) {
                    taskCache.putTask(this.tg.head);
                }
                throw throwable;
            }
            this.tg.event = null;
            if (this.tg.transfer == Transfer.STREAMED) {
                n = this.streamSem.V();
                if (DEBUG) {
                    this.dbgStream.sdebug("Released permit from streamSem [%s]", new Object[]{n});
                }
            }
            if (this.tg.head == null) continue;
            taskCache.putTask(this.tg.head);
        }
    }

    protected void putSelective(TaskGroup taskGroup) throws InterruptedException {
        ++dbgSelCount;
        this.refreshTaskGroupArray();
        int n = taskGroup.count;
        try {
            int n2 = this.tmpTaskOffset;
            boolean bl = false;
            while (this.tmpTaskGroupArray[n2] != null && !bl) {
                TaskGroup taskGroup2 = this.tmpTaskGroupArray[n2];
                ++n2;
                if (taskGroup2.id != taskGroup.id) continue;
                taskGroup.removeDuplicatesOf(taskGroup2);
                if (taskGroup.count != 0) continue;
                bl = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (Exception exception) {
            LOGGER.error(String.format("Error while filtering Task Groups of event %s", taskGroup.event), (Throwable)exception);
        }
        this.flushSemLocalCount += (n -= taskGroup.count);
        if (DEBUG) {
            this.dbgStream.sdebug("PROGRESS event: dropped: %s, flushSemLocalCount: %s", new Object[]{n, this.flushSemLocalCount});
        }
        if (n != 0 && taskGroup.event.syncSem != null) {
            int n3 = taskGroup.event.syncSem.V(n);
            if (DEBUG) {
                this.dbgStream.sdebug("Increased exlusiveSem [%s] as PROGRESS events were dropped", new Object[]{n3});
            }
        }
        this.putAll(taskGroup);
    }

    public void putAll(TaskGroup taskGroup) throws InterruptedException {
        if (taskGroup.transfer == Transfer.STREAMED) {
            int n = this.streamSem.addP_nonBlocking(taskGroup.count);
            if (DEBUG) {
                this.dbgStream.sdebug("Acquired permits [NON BLOCKING] from streamSem [%s]", new Object[]{n});
            }
        }
        for (Task task : taskGroup) {
            ListenerSynchronization listenerSynchronization = null;
            try {
                listenerSynchronization = (ListenerSynchronization)task.l.getSync();
            }
            catch (NullPointerException nullPointerException) {
                LOGGER.error(String.format("Error while putting Task into task processor queue(s) for event %s", task.e), (Throwable)nullPointerException);
                throw nullPointerException;
            }
            if (listenerSynchronization != null) {
                if (!listenerSynchronization.assignFollowUp(task)) {
                    this.synchronizedPut(task);
                    continue;
                }
                ++this.dbgPutFromInsertCount;
                continue;
            }
            this.synchronizedPut(task);
        }
    }

    private void refreshTaskGroupArray() {
        int n = this.src.size();
        if (n > this.tmpTaskLastCount - this.tmpTaskOffset) {
            this.tmpTaskGroupArray = this.src.toArray(this.tmpTaskGroupArray);
            this.tmpTaskOffset = 0;
            this.tmpTaskLastCount = n;
        }
    }

    private void synchronizedPut(Task task) throws InterruptedException {
        if (!this.dst.offer(task)) {
            this.dst.put(task);
        }
        ++this.dbgPutCount;
    }

    public long getPutCount() {
        return this.dbgPutCount + this.dbgPutFromInsertCount;
    }

    public String dbgDetailedIndo(String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(string) + this.getName() + string2);
        TaskGroup[] taskGroupArray = this.src.toArray(new TaskGroup[0]);
        int n = 0;
        while (n < taskGroupArray.length) {
            stringBuffer.append(taskGroupArray[n].dbgDetailedIndo(String.valueOf(string) + " "));
            ++n;
        }
        return stringBuffer.toString();
    }
}

