/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CloneView
implements Runnable,
MouseMotionListener,
MouseListener {
    private static Object INTERPOLATION_QUALITY = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    private static final Dimension MINIMUM_SIZE = new Dimension(10, 10);
    private static Map<Integer, Integer> cursors = new HashMap<Integer, Integer>();
    private static JFrame frame1;
    private static JFrame frame2;
    private boolean clearFrames;
    private static Robot robot;
    private static Rectangle source1;
    private static Rectangle source2;
    private static JPanel panel1;
    private static JPanel panel2;
    private static CloneView instance;
    private Point dragStart;
    private JFrame dragFrame;
    private Point frameStart;
    private Insets dragInsets;
    private Dimension snapping;
    private int direction;
    protected static final int NORTH = 1;
    protected static final int WEST = 2;
    protected static final int SOUTH = 4;
    protected static final int EAST = 8;
    private Cursor sourceCursor;
    private boolean resizing;
    private Rectangle bounds;
    private Point pressed;
    private boolean autoscrolls;
    private Dimension minimumSize;

    static {
        frame2 = null;
        source1 = null;
        source2 = null;
        instance = new CloneView();
    }

    public CloneView() {
        cursors.put(1, 8);
        cursors.put(2, 10);
        cursors.put(4, 9);
        cursors.put(8, 11);
        cursors.put(3, 6);
        cursors.put(9, 7);
        cursors.put(6, 4);
        cursors.put(12, 5);
        this.clearFrames = true;
        this.dragInsets = new Insets(5, 5, 5, 5);
        this.snapping = new Dimension(1, 1);
        this.minimumSize = MINIMUM_SIZE;
    }

    public static void main(String[] stringArray) throws AWTException {
        if (stringArray.length < 5) {
            return;
        }
        switch (Integer.parseInt(stringArray[0])) {
            case 0: {
                INTERPOLATION_QUALITY = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                break;
            }
            case 1: {
                INTERPOLATION_QUALITY = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
                break;
            }
            case 2: {
                INTERPOLATION_QUALITY = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
            }
        }
        frame1 = new JFrame();
        panel1 = new JPanel();
        frame1.setBounds(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]));
        CloneView.setupFrame(frame1, panel1);
        if (stringArray.length >= 9) {
            frame2 = new JFrame();
            panel2 = new JPanel();
            frame2.setBounds(Integer.parseInt(stringArray[5]), Integer.parseInt(stringArray[6]), Integer.parseInt(stringArray[7]), Integer.parseInt(stringArray[8]));
            CloneView.setupFrame(frame2, panel2);
        }
        robot = new Robot();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        Thread thread = new Thread(instance);
        thread.setDaemon(true);
        thread.start();
        while (true) {
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null && !string.contains("exit")) {
                    String[] stringArray2 = string.split(",");
                    source1 = new Rectangle(Integer.parseInt(stringArray2[0]), Integer.parseInt(stringArray2[1]), Integer.parseInt(stringArray2[2]), Integer.parseInt(stringArray2[3]));
                    if (stringArray2.length != 8) continue;
                    source2 = new Rectangle(Integer.parseInt(stringArray2[4]), Integer.parseInt(stringArray2[5]), Integer.parseInt(stringArray2[6]), Integer.parseInt(stringArray2[7]));
                }
            }
            catch (Exception exception) {
                System.err.println("Parsing problem");
                exception.printStackTrace();
                continue;
            }
            break;
        }
        System.exit(0);
    }

    private static void setupFrame(JFrame jFrame, JPanel jPanel) {
        Cursor cursor = new Cursor(13);
        jFrame.setTitle("IMPAX CloneView");
        jFrame.setLayout(new BorderLayout(0, 0));
        jFrame.getContentPane().add((Component)jPanel, "Center");
        jPanel.setDoubleBuffered(false);
        jPanel.setBackground(Color.BLACK);
        jFrame.getContentPane().setBackground(Color.BLACK);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setCursor(cursor);
        jFrame.setAlwaysOnTop(true);
        jFrame.setUndecorated(true);
        jFrame.addMouseMotionListener(instance);
        jFrame.addMouseListener(instance);
        jFrame.getRootPane().setBorder(BorderFactory.createLineBorder(Color.BLUE, 2));
        jFrame.setVisible(true);
    }

    @Override
    public void run() {
        BufferedImage bufferedImage = null;
        Graphics2D graphics2D = null;
        while (true) {
            Point point;
            if (source1 == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            BufferedImage bufferedImage2 = robot.createScreenCapture(source1);
            if (source2 != null) {
                bufferedImage = robot.createScreenCapture(source2);
            }
            Rectangle rectangle = frame1.getContentPane().getBounds();
            Graphics2D graphics2D2 = (Graphics2D)frame1.getContentPane().getGraphics();
            graphics2D2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            if (this.almostEqual(source1, rectangle)) {
                graphics2D2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            } else {
                graphics2D2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, INTERPOLATION_QUALITY);
            }
            if (this.clearFrames) {
                graphics2D2.setColor(Color.BLACK);
                graphics2D2.setBackground(Color.BLACK);
                graphics2D2.fillRect(0, 0, frame1.getWidth(), frame1.getHeight());
            }
            if (this.dragFrame != frame1) {
                rectangle = this.fitRectangle(rectangle, source1);
                graphics2D2.drawImage(bufferedImage2, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, 0, 0, (int)source1.getWidth(), (int)source1.getHeight(), Color.black, null);
            }
            if (source2 != null && bufferedImage != null) {
                rectangle = frame2.getContentPane().getBounds();
                graphics2D = (Graphics2D)frame2.getContentPane().getGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
                if (this.almostEqual(source2, rectangle)) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                } else {
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, INTERPOLATION_QUALITY);
                }
                if (this.clearFrames) {
                    graphics2D.setColor(Color.BLACK);
                    graphics2D.setBackground(Color.BLACK);
                    graphics2D.fillRect(0, 0, frame2.getWidth(), frame2.getHeight());
                }
                if (this.dragFrame != frame2) {
                    rectangle = this.fitRectangle(rectangle, source2);
                    graphics2D.drawImage(bufferedImage, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, 0, 0, (int)source2.getWidth(), (int)source2.getHeight(), Color.black, null);
                }
            }
            if (source1.contains(point = MouseInfo.getPointerInfo().getLocation()) && this.dragFrame == null) {
                this.drawMouse(point, source1, frame1, graphics2D2);
            } else if (source2 != null && source2.contains(point) && this.dragFrame == null) {
                this.drawMouse(point, source2, frame2, graphics2D);
            }
            graphics2D2.dispose();
            if (graphics2D != null) {
                graphics2D.dispose();
            }
            this.clearFrames = false;
        }
    }

    private void drawMouse(Point point, Rectangle rectangle, JFrame jFrame, Graphics2D graphics2D) {
        int n;
        int n2;
        double d;
        if (this.dragFrame == jFrame) {
            return;
        }
        Rectangle rectangle2 = jFrame.getContentPane().getBounds();
        if ((double)rectangle.width / (double)rectangle.height > (double)rectangle2.width / (double)rectangle2.height) {
            d = (double)rectangle2.width / (double)rectangle.width;
            n2 = (rectangle2.width - (int)((double)rectangle.width * d)) / 2;
            n = (rectangle2.height - (int)((double)rectangle.height * d)) / 2;
        } else {
            d = (double)rectangle2.height / (double)rectangle.height;
            n2 = (rectangle2.width - (int)((double)rectangle.width * d)) / 2;
            n = (rectangle2.height - (int)((double)rectangle.height * d)) / 2;
        }
        int n3 = (int)((double)(point.x - rectangle.x) * d + (double)rectangle2.x + (double)n2);
        int n4 = (int)((double)(point.y - rectangle.y) * d + (double)rectangle2.y + (double)n);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(n3 - 3, n4 - 3, 5, 5);
        graphics2D.setColor(Color.BLACK);
        graphics2D.fillRect(n3 - 2, n4 - 2, 3, 3);
    }

    private boolean almostEqual(Rectangle rectangle, Rectangle rectangle2) {
        return (double)Math.abs(rectangle.width - rectangle2.width) / (double)rectangle.width < 0.05 && (double)Math.abs(rectangle.height - rectangle2.height) / (double)rectangle.height < 0.05;
    }

    private Rectangle fitRectangle(Rectangle rectangle, Rectangle rectangle2) {
        if ((double)rectangle2.width / (double)rectangle2.height > (double)rectangle.width / (double)rectangle.height) {
            double d = (double)rectangle.width / (double)rectangle2.width;
            int n = (int)((double)rectangle2.width * d);
            int n2 = (int)((double)rectangle2.height * d);
            return new Rectangle((rectangle.width - n) / 2, (rectangle.height - n2) / 2, n, n2);
        }
        double d = (double)rectangle.height / (double)rectangle2.height;
        int n = (int)((double)rectangle2.width * d);
        int n3 = (int)((double)rectangle2.height * d);
        return new Rectangle((rectangle.width - n) / 2, (rectangle.height - n3) / 2, n, n3);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragFrame != null) {
            this.dragFrame.setBounds(mouseEvent.getXOnScreen() - this.dragStart.x + this.frameStart.x, mouseEvent.getYOnScreen() - this.dragStart.y + this.frameStart.y, this.dragFrame.getWidth(), this.dragFrame.getHeight());
            this.dragFrame.validate();
            this.printLocation();
        } else if (this.resizing) {
            Component component = mouseEvent.getComponent();
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, component);
            this.changeBounds(component, point);
            this.printLocation();
        }
    }

    private void printLocation() {
        this.clearFrames = true;
        Rectangle rectangle = frame1.getBounds();
        String string = String.valueOf(rectangle.x) + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height;
        if (frame2 != null) {
            Rectangle rectangle2 = frame2.getBounds();
            string = String.valueOf(string) + "," + rectangle2.x + "," + rectangle2.y + "," + rectangle2.width + "," + rectangle2.height;
        }
        System.out.println(string);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.dragFrame != null) {
            return;
        }
        Component component = mouseEvent.getComponent();
        Point point = mouseEvent.getPoint();
        this.direction = 0;
        if (point.x < this.dragInsets.left) {
            this.direction += 2;
        }
        if (point.x > component.getWidth() - this.dragInsets.right - 1) {
            this.direction += 8;
        }
        if (point.y < this.dragInsets.top) {
            ++this.direction;
        }
        if (point.y > component.getHeight() - this.dragInsets.bottom - 1) {
            this.direction += 4;
        }
        if (this.direction == 0) {
            component.setCursor(this.sourceCursor);
        } else {
            int n = cursors.get(this.direction);
            Cursor cursor = Cursor.getPredefinedCursor(n);
            component.setCursor(cursor);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.resizing) {
            Component component = mouseEvent.getComponent();
            this.sourceCursor = component.getCursor();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.resizing) {
            Component component = mouseEvent.getComponent();
            component.setCursor(this.sourceCursor);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && this.direction == 0) {
            this.dragStart = mouseEvent.getLocationOnScreen();
            this.dragFrame = (JFrame)mouseEvent.getSource();
            this.frameStart = this.dragFrame.getLocation();
            return;
        }
        if (this.direction != 0) {
            this.resizing = true;
            Component component = mouseEvent.getComponent();
            this.pressed = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(this.pressed, component);
            this.bounds = component.getBounds();
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                this.autoscrolls = jComponent.getAutoscrolls();
                jComponent.setAutoscrolls(false);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && !this.resizing) {
            this.dragStart = null;
            this.dragFrame = null;
            this.frameStart = null;
        } else if (this.resizing) {
            this.resizing = false;
            Component component = mouseEvent.getComponent();
            component.setCursor(this.sourceCursor);
            if (component instanceof JComponent) {
                ((JComponent)component).setAutoscrolls(this.autoscrolls);
            }
        }
    }

    protected void changeBounds(Component component, Point point) {
        int n;
        int n2 = this.bounds.x;
        int n3 = this.bounds.y;
        int n4 = this.bounds.width;
        int n5 = this.bounds.height;
        int n6 = n4;
        int n7 = n5;
        if (2 == (this.direction & 2)) {
            n = this.getDragDistance(this.pressed.x, point.x, this.snapping.width);
            n = this.getDragBounded(n, this.snapping.width, n4, this.minimumSize.width);
            n2 -= n;
            n4 += n;
        }
        if (1 == (this.direction & 1)) {
            n = this.getDragDistance(this.pressed.y, point.y, this.snapping.height);
            n = this.getDragBounded(n, this.snapping.height, n5, this.minimumSize.height);
            n3 -= n;
            n5 += n;
        }
        if (8 == (this.direction & 8)) {
            n = this.getDragDistance(point.x, this.pressed.x, this.snapping.width);
            n = this.getDragBounded(n, this.snapping.width, n4, this.minimumSize.width);
            n4 += n;
        }
        if (4 == (this.direction & 4)) {
            n = this.getDragDistance(point.y, this.pressed.y, this.snapping.height);
            n = this.getDragBounded(n, this.snapping.height, n5, this.minimumSize.height);
            n5 += n;
        }
        if (n4 < 0) {
            n4 = n6;
        }
        if (n5 < 0) {
            n5 = n7;
        }
        component.setBounds(n2, n3, n4, n5);
        component.validate();
    }

    private int getDragDistance(int n, int n2, int n3) {
        int n4;
        int n5 = n3 / 2;
        n4 += (n4 = n - n2) < 0 ? -n5 : n5;
        n4 = n4 / n3 * n3;
        return n4;
    }

    private int getDragBounded(int n, int n2, int n3, int n4) {
        while (n3 + n < n4) {
            n += n2;
        }
        return n;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

