/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee;

import com.agfa.pacs.base.swing.lists.models.GenericDataMutableListModel;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.impaxee.model.xml.shared.AbstractNamedXMLElement;
import com.agfa.pacs.impaxee.model.xml.shared.IUniqueNameGenerator;
import com.agfa.pacs.impaxee.utils.Checksumm;
import com.agfa.pacs.impaxee.utils.StorageStamp;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.security.role.RoleManagerFactory;
import com.tiani.config.xml.minijaxb.XmlSaveable;
import com.tiani.config.xml.minijaxb.XmlSaver;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractRegistry<T extends AbstractNamedXMLElement>
extends GenericDataMutableListModel<T>
implements IUniqueNameGenerator {
    private static final ALogger log = ALogger.getLogger(AbstractRegistry.class);
    protected static final String CONTENT_KEY = "content";
    protected Map<T, StorageStamp> storageStamps = new HashMap<T, StorageStamp>();
    private volatile boolean isStored = false;

    public AbstractRegistry(List<T> list, Comparator<T> comparator) {
        super(list, comparator);
    }

    @Override
    public boolean isNameUnique(String string) {
        return this.getAll().stream().noneMatch(abstractNamedXMLElement -> string.equals(abstractNamedXMLElement.getName()));
    }

    protected IConfigurationProvider getConfigurationProviderForEnterpriseLevel() {
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig().isSupportingRoles() ? ConfigurationProviderFactory.getAdministrationFactory().getConfigForRole(RoleManagerFactory.getInstance().getEnterpriseRole().getFullPath()) : ConfigurationProviderFactory.getConfig();
        return iConfigurationProvider;
    }

    private IConfigurationList getConfigList(String string) {
        IConfigurationProvider iConfigurationProvider = this.getConfigurationProviderForEnterpriseLevel();
        return iConfigurationProvider.getList(string);
    }

    protected synchronized void writeToConfig(String string) {
        if (this.isStored) {
            log.warn("Double storage of the registry:" + this);
            return;
        }
        Map<T, StorageStamp> map = this.storageStamps;
        this.storageStamps = new HashMap<T, StorageStamp>();
        IConfigurationList iConfigurationList = null;
        List list = this.getAll();
        int n = 0;
        int n2 = 0;
        for (AbstractNamedXMLElement abstractNamedXMLElement : list) {
            XmlSaver xmlSaver = new XmlSaver((XmlSaveable)abstractNamedXMLElement);
            try {
                IConfigurationProvider iConfigurationProvider;
                String string2;
                String exception = xmlSaver.toXmlString();
                long l = Checksumm.getChecksumm(exception);
                if (map.containsKey(abstractNamedXMLElement)) {
                    string2 = map.get((Object)abstractNamedXMLElement).configId;
                    if (l != map.get((Object)abstractNamedXMLElement).crc) {
                        if (iConfigurationList == null) {
                            iConfigurationList = this.getConfigList(string);
                        }
                        if ((iConfigurationProvider = (IConfigurationProvider)iConfigurationList.getChildrenItems().get(string2)) != null) {
                            iConfigurationProvider.setText(CONTENT_KEY, exception);
                            ++n2;
                        } else {
                            log.warn("Items already deleted, skipping.");
                        }
                    }
                } else {
                    if (iConfigurationList == null) {
                        iConfigurationList = this.getConfigList(string);
                    }
                    iConfigurationProvider = iConfigurationList.appendItem();
                    string2 = iConfigurationList.getIdOfLastNewElement();
                    iConfigurationProvider.setText(CONTENT_KEY, exception);
                    log.info("New registry item '{}' ({}) stored to config ", (Object)abstractNamedXMLElement.getName(), (Object)this.getClass().getSimpleName());
                    ++n;
                }
                this.storageStamps.put(abstractNamedXMLElement, new StorageStamp(string2, l));
                map.remove(abstractNamedXMLElement);
            }
            catch (Exception exception) {
                log.error("Cannot generate XML representation for: " + abstractNamedXMLElement, (Throwable)exception);
            }
        }
        if (iConfigurationList == null && !map.isEmpty()) {
            iConfigurationList = this.getConfigList(string);
        }
        int n3 = 0;
        for (StorageStamp storageStamp : map.values()) {
            try {
                iConfigurationList.remove(storageStamp.configId);
                ++n3;
            }
            catch (Exception exception) {
                log.warn("Could not remove element", (Throwable)exception);
            }
        }
        log.info("Stored {} to config({} total, {} new, {} modified, {} removed)", new Object[]{this.getClass().getSimpleName(), list.size(), n, n2, n3});
        this.isStored = true;
    }

    protected void loadFromConfig(String string) {
        this.removeAll();
        this.storageStamps.clear();
        IConfigurationList iConfigurationList = ConfigurationProviderFactory.getConfig().getList(string);
        int n = 0;
        for (Map.Entry entry : iConfigurationList.getChildrenItems().entrySet()) {
            String string2;
            T t;
            IConfigurationProvider iConfigurationProvider = (IConfigurationProvider)entry.getValue();
            if (!iConfigurationProvider.exists(CONTENT_KEY) || (t = this.parseXML(string2 = iConfigurationProvider.getText(CONTENT_KEY))) == null || this.addElement(t) < 0) continue;
            this.storageStamps.put(t, new StorageStamp((String)entry.getKey(), Checksumm.getChecksumm(string2)));
            ++n;
        }
        log.info("Initialized {} from config ({} items loaded)", (Object)this.getClass().getSimpleName(), (Object)n);
    }

    protected abstract T parseXML(String var1);
}

