/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions;

import com.agfa.pacs.impaxee.Messages;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class KeyShortcut {
    public static final int KEY_CODE_FOR_GESTURES = 260;
    public final int keyCode;
    public final int modifiers;

    public KeyShortcut(int n, int n2) {
        this.keyCode = n;
        this.modifiers = n2;
    }

    public KeyShortcut(int n) {
        this(n, 0);
    }

    public KeyShortcut(KeyEvent keyEvent) {
        this(keyEvent.getKeyCode(), keyEvent.getModifiers());
    }

    public String toString() {
        return KeyShortcut.toString(this.modifiers, this.keyCode);
    }

    private static String toString(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 400 || n2 == 402) {
            stringBuilder.append(KeyEvent.getKeyModifiersText(n));
            String string = MouseEvent.getModifiersExText(n);
            if (string.length() > 0) {
                stringBuilder.append(string);
                stringBuilder.append('-');
            }
            if (n2 == 400) {
                stringBuilder.append(Messages.getString("SingleClick"));
            } else if (n2 == 402) {
                stringBuilder.append(Messages.getString("DoubleClick"));
            }
            String string2 = stringBuilder.toString();
            string2 = string2.replace("Meta", Messages.getString("SpaceKey"));
            string2 = string2.replace("Button1", Messages.getString("LeftMouseButton"));
            string2 = string2.replace("Button2", Messages.getString("MiddleMouseButton"));
            string2 = string2.replace("Button3", Messages.getString("RightMouseButton"));
            return string2;
        }
        if ((n & 0x100) > 0) {
            n |= 4;
        }
        stringBuilder.append(KeyEvent.getKeyModifiersText(n));
        if (stringBuilder.length() > 0) {
            stringBuilder.append('+');
        }
        stringBuilder.append(KeyEvent.getKeyText(n2));
        String string = stringBuilder.toString();
        string = string.replace("Meta", Messages.getString("SpaceKey"));
        return string;
    }

    public boolean equals(Object object) {
        if (object instanceof KeyShortcut) {
            KeyShortcut keyShortcut = (KeyShortcut)object;
            return this.modifiers == keyShortcut.modifiers && this.keyCode == keyShortcut.keyCode;
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.modifiers).append(this.keyCode).toHashCode();
    }
}

