/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.impl;

import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.impaxee.actions.KeyShortcut;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionIcon;
import com.agfa.pacs.impaxee.actions.PActionListener;
import com.agfa.pacs.impaxee.actions.PDataAction;
import com.agfa.pacs.impaxee.actions.impl.PActionIconFactory;
import com.agfa.pacs.impaxee.plugin.IconDefinition;
import com.agfa.pacs.logging.ALogger;
import com.tiani.jvision.keypress.KeypressRegistry;
import com.tiani.jvision.keypress.ShortCut;
import com.tiani.jvision.plugin.PluginName;
import com.tiani.jvision.vis.VisData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;

public abstract class AbstractPAction
implements PAction {
    protected static final long CACHING_TIMEOUT = Product.isRunningAutoTests() ? 0L : 1000L;
    private static final ALogger log = ALogger.getLogger(PDataAction.class);
    private static Map<String, Counter> usageTracking = new HashMap<String, Counter>(512);
    private List<PActionListener> listeners = new CopyOnWriteArrayList<PActionListener>();
    private boolean enabled = true;
    private Boolean lastEnabled = null;
    private Boolean lastSelected = null;
    private PActionIcon icon = null;

    public AbstractPAction() {
    }

    public AbstractPAction(String string) {
        this(string, null);
    }

    public AbstractPAction(String string, Class<?> clazz) {
        this(IconDefinition.createInstance(string, clazz));
    }

    public AbstractPAction(IconDefinition iconDefinition) {
        if (iconDefinition != null) {
            this.icon = iconDefinition.loadActionIcon();
        }
    }

    public void changeIcon(PActionIcon pActionIcon) {
        this.icon = pActionIcon;
        this.fireContentChanged(true);
    }

    protected void changeIcon(String string, String string2) {
        this.changeIcon(PActionIconFactory.getInstance().loadSvgIcon(string, string2));
    }

    @Override
    public final void addListener(PActionListener pActionListener) {
        if (!this.listeners.contains(pActionListener)) {
            this.listeners.add(pActionListener);
        }
    }

    @Override
    public final void removeListener(PActionListener pActionListener) {
        this.listeners.remove(pActionListener);
    }

    public static String getTooltipTextWithShortcut(PAction pAction) {
        String string = pAction.getToolTipText();
        if (string == null) {
            return null;
        }
        List<ShortCut> list = KeypressRegistry.getInstance().getCopyOfGlobalShortcuts().getShortcutsForAction(pAction);
        if (!list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(" [");
            Iterator<ShortCut> iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                if (iterator.hasNext()) {
                    stringBuilder.append(", ");
                    continue;
                }
                stringBuilder.append(']');
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public KeyShortcut getDefaultShortcut() {
        return null;
    }

    @Override
    public PluginName[] getScopes() {
        return null;
    }

    @Override
    public String getName() {
        return this.getCaption();
    }

    @Override
    public final Icon getDisabledIcon(boolean bl) {
        if (this.icon == null) {
            return null;
        }
        return this.icon.getDisabledIcon(bl);
    }

    @Override
    public final Icon getIcon(boolean bl) {
        if (this.icon == null) {
            return null;
        }
        return this.icon.getIcon(bl);
    }

    @Override
    public boolean hasIcon() {
        return this.icon != null;
    }

    @Override
    public final Icon getPopupIcon(boolean bl) {
        if (this.icon == null) {
            return null;
        }
        return this.icon.getPopupIcon(bl);
    }

    @Override
    public PAction[] getSubactions() {
        return null;
    }

    @Override
    public PAction.ActionType getActionType() {
        return PAction.ActionType.None;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled && this.isEnabledImpl();
    }

    @Override
    public boolean isEnabled(VisData visData) {
        return this.isEnabled();
    }

    protected boolean isEnabledImpl() {
        return true;
    }

    @Override
    public final void setEnabled(boolean bl) {
        this.enabled = bl;
        this.fireEnabledChanged();
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public final void fireEnabledChanged() {
        final boolean bl = this.isEnabled();
        if (this.lastEnabled == null || bl != this.lastEnabled) {
            this.lastEnabled = bl;
            if (!this.listeners.isEmpty()) {
                EventUtil.invokeSynchronous((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (PActionListener pActionListener : AbstractPAction.this.listeners) {
                            pActionListener.enabledStateChanged(bl);
                        }
                    }
                });
            }
        }
    }

    public final void forcedEnablingChanged() {
        this.lastEnabled = null;
        this.fireEnabledChanged();
    }

    @Override
    public final void forcedSelectionChanged() {
        this.lastSelected = null;
        this.fireSelectionChanged();
    }

    @Override
    public final void fireSelectionChanged() {
        final Boolean bl = this.isSelected();
        if (this.lastSelected == null || !this.lastSelected.equals(bl)) {
            this.lastSelected = bl;
            if (!this.listeners.isEmpty()) {
                EventUtil.invokeSynchronous((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (PActionListener pActionListener : AbstractPAction.this.listeners) {
                            pActionListener.selectionStateChanged(bl);
                        }
                    }
                });
            }
        }
    }

    protected void notifyActionPerformed(String string) {
        if (this.isSelectable()) {
            log.info("Changing state:" + string + " from " + this.isSelected());
        } else {
            log.info("Perform action:" + string);
        }
        AbstractPAction.incrementCounter(string);
    }

    public static void notifyNonPActionPerformed(String string) {
        AbstractPAction.incrementCounter(string);
    }

    private static void incrementCounter(String string) {
        Counter counter = usageTracking.get(string);
        if (counter == null) {
            counter = new Counter();
            usageTracking.put(string, counter);
        }
        counter.increment();
    }

    protected void notifyActionPerformed() {
        this.notifyActionPerformed(this.getID());
    }

    protected final void fireContentChanged(final boolean bl) {
        if (!this.listeners.isEmpty()) {
            EventUtil.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    String string = AbstractPAction.this.getCaption();
                    String string2 = AbstractPAction.getTooltipTextWithShortcut(AbstractPAction.this);
                    for (PActionListener pActionListener : AbstractPAction.this.listeners) {
                        pActionListener.contentChanged(string, string2, bl);
                    }
                }
            });
        }
    }

    @Override
    public boolean isUpdatingListeners() {
        return true;
    }

    static Iterable<Map.Entry<String, Counter>> getUsageStatistics() {
        return usageTracking.entrySet();
    }

    @Override
    public boolean invokableByHangingProtocol() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    static class Counter {
        private int counter = 0;

        Counter() {
        }

        public void increment() {
            ++this.counter;
        }

        public int getValue() {
            return this.counter;
        }
    }
}

