/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.impl;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PDataAction;
import com.agfa.pacs.impaxee.actions.PDataProvider;
import com.agfa.pacs.impaxee.actions.PDataScope;
import com.agfa.pacs.impaxee.actions.impl.AbstractPAction;
import com.agfa.pacs.impaxee.actions.impl.ActionNotFoundException;
import com.agfa.pacs.impaxee.actions.impl.CompoundAbstractPAction;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.keyimages.KeyImageManager;
import com.agfa.pacs.impaxee.plugin.IconDefinition;
import com.tiani.base.data.IFrameObjectData;
import com.tiani.base.data.IStudyData;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.util.TwoDArrayIterator;
import com.tiani.jvision.vis.VisData;
import com.tiani.jvision.vis.VisDisplay2;
import com.tiani.jvision.vis.VisScreen2;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractPDataAction
implements PDataAction {
    protected PAction[] dynamicContentActions;

    public AbstractPDataAction(boolean bl) {
    }

    public AbstractPDataAction() {
        this.init();
    }

    public void init() {
        PDataScope[] pDataScopeArray = this.getAvailableScopes();
        this.dynamicContentActions = new PAction[PDataScope.values().length];
        PDataScope[] pDataScopeArray2 = pDataScopeArray;
        int n = pDataScopeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PDataScope pDataScope = pDataScopeArray2[n2];
            this.dynamicContentActions[pDataScope.ordinal()] = this.createDataAction(pDataScope, null);
            ++n2;
        }
    }

    protected abstract PAction createDataAction(PDataScope var1, PDataProvider var2);

    @Override
    public final PAction getAction(PDataScope pDataScope) {
        PAction pAction = this.dynamicContentActions[pDataScope.ordinal()];
        if (pAction == null) {
            throw new ActionNotFoundException(this.getID(), pDataScope);
        }
        return pAction;
    }

    @Override
    public final PAction createAction(PDataProvider pDataProvider) {
        return this.createDataAction(null, pDataProvider);
    }

    @Override
    public boolean canHandleDataProvider(PDataProvider.ProviderType providerType) {
        return PDataProvider.ProviderType.Display == providerType;
    }

    public static VisData getCurrentImage() {
        return VisData.getLastModified();
    }

    public static VisDisplay2 getCurrentDisplay() {
        VisData visData = VisData.getLastModified();
        if (visData == null) {
            return null;
        }
        return visData.getParent().getVisDisplay();
    }

    public static VisScreen2 getCurrentScreen() {
        VisData visData = VisData.getLastModified();
        if (visData == null) {
            return null;
        }
        return visData.getParent().getVisDisplay().getScreen();
    }

    public static List<VisData> getVisDatas(PDataScope pDataScope) {
        VisData visData = null;
        switch (pDataScope) {
            case SelectedImages: {
                visData = VisData.getLastModified();
                if (visData == null) {
                    return Collections.emptyList();
                }
                return visData.getParent().getSelectedVis();
            }
            case KeyImages: {
                IPatientRepresentation iPatientRepresentation = DataSelectionManager.getInstance().getCurrentPatient();
                if (iPatientRepresentation == null) {
                    return Collections.emptyList();
                }
                HashSet<IFrameObjectData> hashSet = new HashSet<IFrameObjectData>();
                for (IStudyData object : iPatientRepresentation.getPatientData().getStudies()) {
                    hashSet.addAll(object.getKeyImageManager().getKeyImages());
                }
                if (!hashSet.isEmpty()) {
                    ArrayList<VisData> string = new ArrayList<VisData>(hashSet.size());
                    List<VisData> list = JVision2.getMainFrame().getAllVisDatas();
                    Iterator visData3 = list.iterator();
                    while (visData3.hasNext()) {
                        VisData iterator = (VisData)visData3.next();
                        IFrameObjectData iFrameObjectData = iterator.getFrameData();
                        if (iFrameObjectData == null || !hashSet.contains(iFrameObjectData)) continue;
                        string.add(iterator);
                    }
                    return string;
                }
                return Collections.emptyList();
            }
            case CurrentDisplay: {
                visData = VisData.getLastModified();
                if (visData == null) {
                    return Collections.emptyList();
                }
                return new ArrayList<VisData>(visData.getParent().getVis());
            }
            case AllDisplayed: {
                return JVision2.getMainFrame().getAllVisDatas();
            }
            case CurrentStudy: {
                visData = VisData.getLastModified();
                if (visData == null) {
                    return Collections.emptyList();
                }
                String string = visData.getImageInformation().getStudyInstanceUID();
                List<VisData> list = JVision2.getMainFrame().getAllVisDatas();
                Iterator<VisData> iterator = list.iterator();
                while (iterator.hasNext()) {
                    VisData visData2 = iterator.next();
                    if (visData2.getImageInformation() != null && visData2.getImageInformation().getStudyInstanceUID().equals(string)) continue;
                    iterator.remove();
                }
                return list;
            }
            case FullStudy: {
                return Collections.emptyList();
            }
            case CurrentImage: {
                visData = VisData.getLastModified();
                if (visData == null) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(visData);
            }
        }
        return Collections.emptyList();
    }

    public static List<VisDisplay2> getVisDisplays(PDataScope pDataScope) {
        switch (pDataScope) {
            case AllDisplayed: {
                return JVision2.getMainFrame().getDisplays();
            }
            case SelectedImages: 
            case CurrentDisplay: 
            case CurrentScreen: {
                VisData visData = VisData.getLastModified();
                if (visData == null) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(visData.getParent().getVisDisplay());
            }
            case KeyImages: {
                ArrayList<VisDisplay2> arrayList = new ArrayList<VisDisplay2>();
                List<VisDisplay2> list = JVision2.getMainFrame().getAllDisplays();
                for (VisDisplay2 visDisplay2 : list) {
                    if (KeyImageManager.getFirstMarked(new TwoDArrayIterator<IFrameObjectData>(visDisplay2.getData().getDisplaySet().getFrames())) == null) continue;
                    arrayList.add(visDisplay2);
                }
                return arrayList;
            }
            case CurrentStudy: {
                VisData visData = VisData.getLastModified();
                if (visData == null) {
                    return Collections.emptyList();
                }
                String string = visData.getImageInformation().getStudyInstanceUID();
                List<VisDisplay2> list = JVision2.getMainFrame().getAllDisplays();
                Iterator<VisDisplay2> iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getData().getFirstVis().getImageInformation().getStudyInstanceUID().equals(string)) continue;
                    iterator.remove();
                }
                return list;
            }
        }
        return Collections.emptyList();
    }

    public static List<VisDisplay2> getVisDisplaysBasedOnMousePosition() {
        Point point = MouseInfo.getPointerInfo().getLocation();
        for (VisDisplay2 visDisplay2 : JVision2.getMainFrame().getDisplays()) {
            Rectangle rectangle = visDisplay2.getBounds();
            rectangle.setLocation(visDisplay2.getLocationOnScreen());
            if (!rectangle.contains(point)) continue;
            return Collections.singletonList(visDisplay2);
        }
        return null;
    }

    protected String getID(PDataScope pDataScope) {
        if (pDataScope == null) {
            return this.getID();
        }
        StringBuilder stringBuilder = new StringBuilder(this.getID());
        stringBuilder.append('@').append(pDataScope.name());
        return stringBuilder.toString();
    }

    protected abstract class AbstractInnerPAction
    extends AbstractPAction {
        protected PDataScope scope;
        protected PDataProvider provider;

        public AbstractInnerPAction(String string, PDataScope pDataScope, PDataProvider pDataProvider) {
            super(string);
            assert (pDataScope != null || pDataProvider != null);
            this.scope = pDataScope;
            this.provider = pDataProvider;
        }

        public AbstractInnerPAction(IconDefinition iconDefinition, PDataScope pDataScope, PDataProvider pDataProvider) {
            super(iconDefinition);
            assert (pDataScope != null || pDataProvider != null);
            this.scope = pDataScope;
            this.provider = pDataProvider;
        }

        public AbstractInnerPAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            assert (pDataScope != null || pDataProvider != null);
            this.scope = pDataScope;
            this.provider = pDataProvider;
        }

        @Override
        public String getID() {
            return AbstractPDataAction.this.getID(this.scope);
        }

        protected final VisDisplay2 getVisDisplay() {
            List<VisDisplay2> list = this.scope != null ? AbstractPDataAction.getVisDisplays(this.scope) : this.provider.getVisDisplays();
            if (list != null && list.size() == 1) {
                return list.get(0);
            }
            return null;
        }

        public final VisScreen2 getScreen() {
            if (this.provider != null) {
                return this.provider.getVisScreen();
            }
            VisDisplay2 visDisplay2 = this.getVisDisplay();
            if (visDisplay2 != null) {
                return visDisplay2.getVisScreen();
            }
            return null;
        }
    }

    protected abstract class CompoundInnerPAction
    extends CompoundAbstractPAction {
        protected PDataScope scope;
        protected PDataProvider provider;

        public CompoundInnerPAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            assert (pDataScope != null || pDataProvider != null);
            this.scope = pDataScope;
            this.provider = pDataProvider;
        }

        @Override
        public String getID() {
            return AbstractPDataAction.this.getID(this.scope);
        }
    }

    protected abstract class SelectableInnerPAction
    extends AbstractInnerPAction {
        public SelectableInnerPAction(IconDefinition iconDefinition, PDataScope pDataScope, PDataProvider pDataProvider) {
            super(iconDefinition, pDataScope, pDataProvider);
        }

        public SelectableInnerPAction(String string, PDataScope pDataScope, PDataProvider pDataProvider) {
            super(string, pDataScope, pDataProvider);
        }

        public SelectableInnerPAction(PDataScope pDataScope, PDataProvider pDataProvider) {
            super(pDataScope, pDataProvider);
        }

        @Override
        public final boolean isSelectable() {
            return this.provider != null;
        }

        protected abstract boolean isSelectedImpl();

        @Override
        public final boolean isSelected() {
            if (this.provider != null) {
                return this.isSelectedImpl();
            }
            return false;
        }
    }
}

