/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.impl;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.actions.PActionIcon;
import com.agfa.pacs.impaxee.actions.PActionIconModifier;
import com.agfa.pacs.impaxee.actions.impl.PActionIconImpl;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.impaxee.utils.GuiUtil;
import com.agfa.pacs.jna.wintools.TouchUtils;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconFactory;
import com.agfa.pacs.listtext.swingx.icon.PIconLoader;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import java.util.HashMap;
import java.util.Map;

public class PActionIconFactory {
    public static final int SMALL_ICON_HEIGHT;
    public static final int LARGE_ICON_HEIGHT;
    public static final double ICON_SIZE_RATIO;
    public static final double TOUCH_ICON_SIZE_RATIO;
    private static final ALogger log;
    private static final PActionIconFactory instance;
    private final Map<IconKey, PActionIcon> loadedIcons;
    private final Map<IconKey, PIcon> unmodifiedIcons;
    private final PIconFactory pif;

    static {
        ICON_SIZE_RATIO = Config.impaxee.jvision.TOPTOOLBAR.IconScaleFactor.get();
        TOUCH_ICON_SIZE_RATIO = Config.impaxee.jvision.TOPTOOLBAR.TouchIconScaleFactor.get();
        log = ALogger.getLogger(PActionIconFactory.class);
        double d = GUI.getScaleDiagnosticFactor();
        SMALL_ICON_HEIGHT = (int)Math.round(22.0 * d);
        LARGE_ICON_HEIGHT = (int)Math.round(22.0 * (d *= TouchUtils.supportsTouchInput() ? TOUCH_ICON_SIZE_RATIO : ICON_SIZE_RATIO));
        instance = new PActionIconFactory(SMALL_ICON_HEIGHT, LARGE_ICON_HEIGHT);
    }

    private PActionIconFactory(int n, int n2) {
        boolean bl = !GuiUtil.isOnColorMonitor();
        log.info("Using " + (bl ? "monochrome" : "colored") + " icons for actions.");
        this.pif = PIconFactory.createdFixedSizeIconFactory((boolean)bl, (int[])new int[]{n, n2});
        this.loadedIcons = new HashMap<IconKey, PActionIcon>();
        this.unmodifiedIcons = new HashMap<IconKey, PIcon>(4);
    }

    public static PActionIconFactory getInstance() {
        return instance;
    }

    public PActionIcon loadUnchangingIcon(Class<?> clazz, String string) {
        if (clazz == null) {
            clazz = this.getClass();
        }
        return this.loadIcon(clazz.getClassLoader(), string, null, true);
    }

    public PActionIcon loadIcon(Class<?> clazz, String string, PActionIconModifier pActionIconModifier) {
        String string2;
        ClassLoader classLoader;
        IconKey iconKey;
        PActionIcon pActionIcon;
        if (clazz == null) {
            clazz = this.getClass();
        }
        if ((pActionIcon = this.loadedIcons.get(iconKey = new IconKey(classLoader = clazz.getClassLoader(), string2 = PIconLoader.updatePath((String)string), pActionIconModifier))) == null) {
            pActionIcon = this.loadIcon(classLoader, string2, pActionIconModifier, false);
            this.loadedIcons.put(iconKey, pActionIcon);
        }
        return pActionIcon;
    }

    private PActionIcon loadIcon(ClassLoader classLoader, String string, PActionIconModifier pActionIconModifier, boolean bl) {
        try {
            PIcon pIcon;
            if (pActionIconModifier == null) {
                pIcon = this.pif.loadIcon(classLoader, string);
            } else {
                IconKey iconKey = new IconKey(classLoader, string, null);
                pIcon = this.unmodifiedIcons.get(iconKey);
                if (pIcon == null) {
                    pIcon = this.pif.loadIcon(classLoader, string);
                    this.unmodifiedIcons.put(iconKey, pIcon);
                }
            }
            if (pIcon != null) {
                return new PActionIconImpl(pIcon, pActionIconModifier, bl);
            }
            log.error("Unknown action icon: " + string);
        }
        catch (Exception exception) {
            log.error("Loading action icon failed: " + string, (Throwable)exception);
        }
        return null;
    }

    public PActionIcon loadSvgIcon(String string, String string2) {
        try {
            PIcon pIcon = this.pif.loadSvgIconFromXml(string, string2);
            return new PActionIconImpl(pIcon, null, false);
        }
        catch (Exception exception) {
            log.error("Loading icon '" + string + "' from literal definition failed.", (Throwable)exception);
            return null;
        }
    }

    private static class IconKey {
        private final ClassLoader classLoader;
        private final String path;
        private final PActionIconModifier modifier;

        IconKey(ClassLoader classLoader, String string, PActionIconModifier pActionIconModifier) {
            this.classLoader = classLoader;
            this.path = string;
            this.modifier = pActionIconModifier;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof IconKey)) {
                return false;
            }
            IconKey iconKey = (IconKey)object;
            return CompareUtils.equals((Object)this.classLoader, (Object)iconKey.classLoader) && CompareUtils.equals((Object)this.path, (Object)iconKey.path) && CompareUtils.equals((Object)this.modifier, (Object)iconKey.modifier);
        }

        public int hashCode() {
            return CompareUtils.hashCode((Object)this.classLoader) ^ CompareUtils.hashCode((Object)this.path) ^ CompareUtils.hashCode((Object)this.modifier);
        }
    }
}

