/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui;

import com.agfa.pacs.base.swing.busylabel.UIManagerExt;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.SeparatorPAction;
import com.agfa.pacs.impaxee.actions.ui.ActionUIScope;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import com.agfa.pacs.impaxee.actions.ui.ButtonPopupMenuPanel;
import com.agfa.pacs.impaxee.actions.ui.DropDownButton;
import com.agfa.pacs.impaxee.actions.ui.DynamicActionPopupMenu;
import com.agfa.pacs.impaxee.actions.ui.LayoutChooserPopupMenu;
import com.agfa.pacs.impaxee.actions.ui.OnlyOneStudyChooser;
import com.agfa.pacs.impaxee.actions.ui.PatientInfoComponent;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.jna.wintools.TouchUtils;
import com.agfa.pacs.listtext.swingx.controls.DropDownBox;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorButton;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorLabel;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorMenuItem;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorToggleButton;
import com.tiani.jvision.toptoolbar.DisplayLayoutChooserDataAction;
import com.tiani.jvision.toptoolbar.OnlyOneStudyDataAction;
import com.tiani.jvision.toptoolbar.VariableLayoutChooserDataAction;
import com.tiani.jvision.vis.VisData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class ActionComponentFactory {
    public static final String ARROW_BUTTON_NAME = "DROP_DOWN_BOX_ARROW_BUTTON";
    public static final String SEPARATOR = "*";

    public static JComponent createComponent(PAction pAction, ActionUIScope actionUIScope, VisData visData) {
        PAction.ActionType actionType = pAction.getActionType();
        boolean bl = pAction.isSelectable();
        boolean bl2 = ArrayUtils.isNotEmpty((Object[])pAction.getSubactions());
        String string = pAction.getID();
        if ("SEPARATOR".equals(string)) {
            return ActionComponentFactory.createSeparatorImpl(pAction);
        }
        if ("PATIENT_INFO".equals(pAction.getID())) {
            return ActionComponentFactory.createPatientInfoComponentImpl(pAction);
        }
        if (pAction.getID().startsWith("ONLY_ONE_STUDY") && pAction instanceof OnlyOneStudyDataAction.OnlyOneStudyAction) {
            return new OnlyOneStudyChooser(((OnlyOneStudyDataAction.OnlyOneStudyAction)pAction).getScreen(), ((OnlyOneStudyDataAction.OnlyOneStudyAction)pAction).useNavigationButtons());
        }
        if (string.startsWith("VARIABLE_LAYOUT_CHOOSER") || string.startsWith("DISPLAY_LAYOUT_CHOOSER") || string.equals("SYNC_OPTIONS") && actionUIScope != ActionUIScope.VisMenu) {
            return ActionComponentFactory.createDropDownButtonImpl(pAction, actionUIScope);
        }
        if (ActionUIScope.VisMenu.equals((Object)actionUIScope)) {
            if (PAction.ActionType.FlatGroup.equals((Object)pAction.getActionType())) {
                return ActionComponentFactory.createFlatGroupPanel(pAction, ActionUIScope.Other, visData);
            }
            return ActionComponentFactory.createMenuItem(pAction, actionUIScope, visData);
        }
        if (PAction.ActionType.None.equals((Object)actionType)) {
            if (ActionUIUtilities.isExecutable(pAction)) {
                if (bl) {
                    return ActionComponentFactory.createToggleButtonImpl(pAction, actionUIScope);
                }
                return ActionComponentFactory.createButtonImpl(pAction, actionUIScope);
            }
            if (!bl2) {
                return ActionComponentFactory.createLabelImpl(pAction);
            }
            if (ActionUIScope.DisplayToolbar.equals((Object)actionUIScope)) {
                return ActionComponentFactory.createDropDownButtonImpl(pAction, actionUIScope);
            }
            return ActionComponentFactory.createDropDownBoxImpl(pAction, actionUIScope, "MOUSE_MODE_GROUP".equals(pAction.getID()));
        }
        if (PAction.ActionType.TextLabel.equals((Object)actionType)) {
            return ActionComponentFactory.createLabelImpl(pAction);
        }
        if (PAction.ActionType.FlatGroup.equals((Object)actionType)) {
            assert (ActionUIUtilities.hasSubActions(pAction)) : "create action component: action '" + pAction.getID() + "' is declared to be of type 'flatgroup' but doesn't has any sub-actions!";
            return ActionComponentFactory.createFlatGroupPanel(pAction, actionUIScope, visData);
        }
        if (ActionUIScope.DisplayToolbar.equals((Object)actionUIScope)) {
            return ActionComponentFactory.createDropDownButtonImpl(pAction, actionUIScope);
        }
        return ActionComponentFactory.createDropDownBoxImpl(pAction, actionUIScope, "MOUSE_MODE_GROUP".equals(pAction.getID()));
    }

    public static JPopupMenu createPopupMenu(Collection<PAction> collection, ActionUIScope actionUIScope) {
        JPopupMenu jPopupMenu = ActionComponentFactory.createPopupImpl(null, actionUIScope);
        ActionComponentFactory.buildMenu(jPopupMenu, collection, actionUIScope);
        return jPopupMenu;
    }

    public static JComponent createFastAccessVisMenuComponent(PAction pAction) {
        PAction.ActionType actionType = pAction.getActionType();
        if (PAction.ActionType.None.equals((Object)actionType)) {
            if (ActionUIUtilities.isExecutable(pAction)) {
                boolean bl = pAction.isSelectable();
                if (bl) {
                    return ActionComponentFactory.createToggleButtonImpl(pAction, ActionUIScope.VisMenu);
                }
                return ActionComponentFactory.createButtonImpl(pAction, ActionUIScope.VisMenu);
            }
            boolean bl = ArrayUtils.isNotEmpty((Object[])pAction.getSubactions());
            if (bl) {
                return ActionComponentFactory.createDropDownButtonImpl(pAction, ActionUIScope.VisMenu);
            }
        } else if (PAction.ActionType.Submenu.equals((Object)actionType) || PAction.ActionType.SubmenuExclusive.equals((Object)actionType)) {
            return ActionComponentFactory.createDropDownButtonImpl(pAction, ActionUIScope.VisMenu);
        }
        return null;
    }

    public static boolean canCreateFastAccessVisMenuComponent(PAction pAction) {
        PAction[] pActionArray;
        PAction.ActionType actionType = pAction.getActionType();
        if (PAction.ActionType.None.equals((Object)actionType)) {
            if (ActionUIUtilities.isExecutable(pAction)) {
                return pAction.hasIcon();
            }
            return ArrayUtils.isNotEmpty((Object[])pAction.getSubactions());
        }
        if ((PAction.ActionType.Submenu.equals((Object)actionType) || PAction.ActionType.SubmenuExclusive.equals((Object)actionType)) && (pActionArray = pAction.getSubactions()) != null && pAction.getSubactions().length > 0) {
            PAction[] pActionArray2 = pActionArray;
            int n = pActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                PAction pAction2 = pActionArray2[n2];
                if (!pAction2.hasIcon()) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private static JMenuItem createMenuItem(PAction pAction, ActionUIScope actionUIScope, VisData visData) {
        PAction.ActionType actionType = pAction.getActionType();
        if (PAction.ActionType.None == actionType) {
            if (pAction.isSelectable()) {
                return ActionComponentFactory.createCheckBoxMenuItemImpl(pAction);
            }
            return ActionComponentFactory.createMenuItemImpl(pAction);
        }
        if (PAction.ActionType.TextLabel.equals((Object)actionType)) {
            return ActionComponentFactory.createMenuItemImpl(pAction);
        }
        JMenu jMenu = ActionComponentFactory.createMenuImpl(pAction);
        PAction[] pActionArray = pAction.getSubactions();
        if (pActionArray != null) {
            PAction[] pActionArray2 = pActionArray;
            int n = pActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                JMenuItem jMenuItem;
                PAction pAction2 = pActionArray2[n2];
                if ("SEPARATOR".equals(pAction2.getID())) {
                    jMenu.add(ActionComponentFactory.createSeparatorImpl(pAction2));
                } else if (pAction2.isEnabled() && (visData == null || pAction2.isEnabled(visData)) && (jMenuItem = ActionComponentFactory.createSubMenuItem(pAction, pAction2, actionUIScope)) != null) {
                    jMenu.add(jMenuItem);
                }
                ++n2;
            }
        }
        return jMenu;
    }

    static final JMenuItem createSubMenuItem(PAction pAction, PAction pAction2, ActionUIScope actionUIScope) {
        PAction.ActionType actionType = pAction2.getActionType();
        if (PAction.ActionType.None.equals((Object)actionType)) {
            PAction.ActionType actionType2 = pAction.getActionType();
            if (PAction.ActionType.SubmenuExclusive.equals((Object)actionType2)) {
                return ActionComponentFactory.createRadioButtonMenuItemImpl(pAction2);
            }
            if (ActionUIScope.VisMenu.equals((Object)actionUIScope) && pAction2.isSelectable()) {
                return ActionComponentFactory.createCheckBoxMenuItemImpl(pAction2);
            }
            assert (ActionUIUtilities.isExecutable(pAction2)) : "create action component: action '" + pAction2.getID() + "' is not executable!";
            return ActionComponentFactory.createMenuItemImpl(pAction2);
        }
        return ActionComponentFactory.createMenuItem(pAction2, actionUIScope, null);
    }

    private static JPanel createFlatGroupPanel(PAction pAction, ActionUIScope actionUIScope, VisData visData) {
        assert (PAction.ActionType.FlatGroup.equals((Object)pAction.getActionType())) : "create action component: action '" + pAction.getID() + "' must be of type 'flatgroup'!";
        JPanel jPanel = ActionComponentFactory.createPanelImpl(pAction);
        if (ActionUIUtilities.hasSubActions(pAction)) {
            GridBagLayout gridBagLayout = new GridBagLayout();
            jPanel.setLayout(gridBagLayout);
            int n = 0;
            PAction[] pActionArray = pAction.getSubactions();
            int n2 = pActionArray.length;
            int n3 = 0;
            while (n3 < n2) {
                PAction pAction2 = pActionArray[n3];
                JComponent jComponent = ActionComponentFactory.createComponent(pAction2, actionUIScope, visData);
                gridBagLayout.setConstraints(jComponent, new GridBagConstraints(n, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, GUI.getScaledDiagnosticInt((int)1), "TEXT_INFO".equals(pAction2.getID()) ? GUI.getScaledDiagnosticInt((int)5) : 0, GUI.getScaledDiagnosticInt((int)1)), 0, 0));
                jPanel.add(jComponent);
                ++n;
                ++n3;
            }
        }
        return jPanel;
    }

    private static JPopupMenu createDropDownMenu(PAction pAction, ActionUIScope actionUIScope) {
        if (ActionUIScope.DisplayToolbar.equals((Object)actionUIScope) && "PS_CHOOSER".equals(pAction.getID())) {
            return ActionComponentFactory.createDynamicPopupImpl(pAction, actionUIScope);
        }
        if ("WINDOWLEVEL_GROUP".equals(StringUtils.substringBefore((String)pAction.getID(), (String)Character.toString('@')))) {
            DynamicActionPopupMenu dynamicActionPopupMenu = ActionComponentFactory.createDynamicPopupImpl(pAction, actionUIScope);
            ActionComponentFactory.buildMenu((JPopupMenu)dynamicActionPopupMenu, pAction, actionUIScope);
            dynamicActionPopupMenu.cacheCurrentComponents();
            return dynamicActionPopupMenu;
        }
        if (pAction.getID().startsWith("VARIABLE_LAYOUT_CHOOSER")) {
            return LayoutChooserPopupMenu.createVariableLayoutPopupMenu((VariableLayoutChooserDataAction.VariableLayoutChooserAction)pAction);
        }
        if (pAction.getID().startsWith("DISPLAY_LAYOUT_CHOOSER")) {
            return LayoutChooserPopupMenu.createDisplayLayoutPopupMenu((DisplayLayoutChooserDataAction.DisplayLayoutChooserAction)pAction);
        }
        JPopupMenu jPopupMenu = ActionComponentFactory.createPopupImpl(pAction, actionUIScope);
        ActionComponentFactory.buildMenu(jPopupMenu, pAction, actionUIScope);
        return jPopupMenu;
    }

    private static final ButtonPopupMenuPanel createButtonPopupMenuPanel(JPopupMenu jPopupMenu, Collection<PAction> collection, int n, int n2, ActionUIScope actionUIScope) {
        ArrayList<AbstractButton> arrayList = new ArrayList<AbstractButton>();
        if (collection != null && !collection.isEmpty()) {
            for (PAction pAction : collection) {
                assert (ActionUIUtilities.isIconButtonAction(pAction)) : "create action icon-group button: action '" + pAction.getID() + "' is not icon-group action!";
                AbstractButton abstractButton = null;
                abstractButton = pAction.isSelectable() ? ActionComponentFactory.createToggleButtonImpl(pAction, actionUIScope) : ActionComponentFactory.createButtonImpl(pAction, actionUIScope);
                if (abstractButton == null) continue;
                arrayList.add(abstractButton);
            }
        }
        return ButtonPopupMenuPanel.create(jPopupMenu, arrayList, n, n2);
    }

    static final JSeparator createSeparatorImpl(PAction pAction) {
        JSeparator jSeparator = new JSeparator();
        ActionComponentFactory.setClientProperty(jSeparator, pAction);
        return jSeparator;
    }

    static final JButton createButtonImpl(PAction pAction, ActionUIScope actionUIScope) {
        MultiMonitorButton multiMonitorButton = ComponentFactory.instance.createMultiMonitorButton((String)null);
        multiMonitorButton.setName("ImageAreaButton");
        ActionComponentFactory.setClientProperty(multiMonitorButton, pAction);
        return multiMonitorButton;
    }

    private static JToggleButton createToggleButtonImpl(PAction pAction, ActionUIScope actionUIScope) {
        MultiMonitorToggleButton multiMonitorToggleButton = ComponentFactory.instance.createMultiMonitorToggleButton((String)null);
        multiMonitorToggleButton.setName("ImageAreaToggleButton");
        ActionComponentFactory.setClientProperty(multiMonitorToggleButton, pAction);
        return multiMonitorToggleButton;
    }

    private static DropDownBox createDropDownBoxImpl(final PAction pAction, ActionUIScope actionUIScope, boolean bl) {
        DropDownBox dropDownBox = new DropDownBox(null, null, ActionComponentFactory.createDropDownMenu(pAction, actionUIScope), DropDownBox.Orientation.bottom, bl){

            protected JButton createItemButton() {
                MultiMonitorButton multiMonitorButton = ComponentFactory.instance.createMultiMonitorButton((String)null);
                multiMonitorButton.setName("ImageAreaButton");
                multiMonitorButton.setBorderPainted(false);
                multiMonitorButton.setFocusable(false);
                multiMonitorButton.setRolloverEnabled(true);
                return multiMonitorButton;
            }

            protected JToggleButton createItemToggleButton() {
                MultiMonitorToggleButton multiMonitorToggleButton = ComponentFactory.instance.createMultiMonitorToggleButton((String)null);
                multiMonitorToggleButton.setName("ImageAreaToggleButton");
                multiMonitorToggleButton.setBorderPainted(false);
                multiMonitorToggleButton.setFocusable(false);
                multiMonitorToggleButton.setRolloverEnabled(true);
                multiMonitorToggleButton.setSelected(false);
                return multiMonitorToggleButton;
            }

            protected JButton createArrowButton() {
                JButton jButton = super.createArrowButton();
                jButton.setName("ImageAreaButton");
                jButton.putClientProperty("componentID", "DROP_DOWN_BOX_ARROW_BUTTON*" + pAction.getID());
                if (TouchUtils.supportsTouchInput()) {
                    jButton.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 20));
                    jButton.setPreferredSize(new Dimension(GUI.getScaledDiagnosticInt((int)32), 20));
                } else {
                    jButton.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 4));
                    jButton.setPreferredSize(new Dimension(GUI.getScaledDiagnosticInt((int)13), 9));
                }
                return jButton;
            }
        };
        ActionComponentFactory.setClientProperty((JComponent)dropDownBox, pAction);
        return dropDownBox;
    }

    private static DropDownButton createDropDownButtonImpl(PAction pAction, ActionUIScope actionUIScope) {
        DropDownButton dropDownButton = new DropDownButton(null, null, ActionComponentFactory.createDropDownMenu(pAction, actionUIScope), DropDownButton.Orientation.bottom){

            @Override
            protected int getArrowIconWidth(DropDownButton.Orientation orientation) {
                if (DropDownButton.Orientation.left.equals((Object)orientation) || DropDownButton.Orientation.right.equals((Object)orientation)) {
                    return GUI.getScaledDiagnosticInt((int)4);
                }
                return GUI.getScaledDiagnosticInt((int)8);
            }

            @Override
            protected int getArrowIconHeight(DropDownButton.Orientation orientation) {
                if (DropDownButton.Orientation.left.equals((Object)orientation) || DropDownButton.Orientation.right.equals((Object)orientation)) {
                    return GUI.getScaledDiagnosticInt((int)8);
                }
                return GUI.getScaledDiagnosticInt((int)4);
            }
        };
        ActionComponentFactory.setClientProperty(dropDownButton, pAction);
        return dropDownButton;
    }

    private static JLabel createLabelImpl(PAction pAction) {
        MultiMonitorLabel multiMonitorLabel = "DENSITY_VALUE".equals(pAction.getID()) ? new DensityLabel() : ComponentFactory.instance.createMultiMonitorLabel();
        ActionComponentFactory.setClientProperty(multiMonitorLabel, pAction);
        return multiMonitorLabel;
    }

    private static PatientInfoComponent createPatientInfoComponentImpl(PAction pAction) {
        PatientInfoComponent patientInfoComponent = new PatientInfoComponent();
        ComponentFactory.instance.scaleFont(patientInfoComponent);
        ActionComponentFactory.setClientProperty(patientInfoComponent, pAction);
        return patientInfoComponent;
    }

    private static JPanel createPanelImpl(PAction pAction) {
        JPanel jPanel = new JPanel();
        ActionComponentFactory.setClientProperty(jPanel, pAction);
        return jPanel;
    }

    private static JPopupMenu createPopupImpl(PAction pAction, ActionUIScope actionUIScope) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (pAction != null) {
            ActionComponentFactory.setClientProperty(jPopupMenu, pAction);
        }
        jPopupMenu.setBorder(BorderFactory.createLineBorder(UIManager.getColor("color.primary.3")));
        jPopupMenu.setLightWeightPopupEnabled(false);
        return jPopupMenu;
    }

    private static DynamicActionPopupMenu createDynamicPopupImpl(PAction pAction, ActionUIScope actionUIScope) {
        DynamicActionPopupMenu dynamicActionPopupMenu = new DynamicActionPopupMenu(actionUIScope, pAction);
        ActionComponentFactory.setClientProperty(dynamicActionPopupMenu, pAction);
        dynamicActionPopupMenu.setBorder(BorderFactory.createLineBorder(UIManagerExt.getColor((Object)"color.primary.3")));
        dynamicActionPopupMenu.setLightWeightPopupEnabled(false);
        return dynamicActionPopupMenu;
    }

    private static JMenuItem createMenuItemImpl(PAction pAction) {
        MultiMonitorMenuItem multiMonitorMenuItem = ComponentFactory.instance.createMultiMonitorMenuItem(null);
        ActionComponentFactory.setClientProperty(multiMonitorMenuItem, pAction);
        return multiMonitorMenuItem;
    }

    private static JRadioButtonMenuItem createRadioButtonMenuItemImpl(PAction pAction) {
        JRadioButtonMenuItem jRadioButtonMenuItem = ComponentFactory.instance.createRadioButtonMenuItem(null);
        ActionComponentFactory.setClientProperty(jRadioButtonMenuItem, pAction);
        return jRadioButtonMenuItem;
    }

    private static JCheckBoxMenuItem createCheckBoxMenuItemImpl(PAction pAction) {
        JCheckBoxMenuItem jCheckBoxMenuItem = ComponentFactory.instance.createCheckBoxMenuItem(null, false);
        ActionComponentFactory.setClientProperty(jCheckBoxMenuItem, pAction);
        return jCheckBoxMenuItem;
    }

    private static JMenu createMenuImpl(PAction pAction) {
        JMenu jMenu = ComponentFactory.instance.createMenu(null);
        ActionComponentFactory.setClientProperty(jMenu, pAction);
        return jMenu;
    }

    private static void setClientProperty(JComponent jComponent, PAction pAction) {
        jComponent.putClientProperty("componentID", pAction.getID());
    }

    private static void buildMenu(JPopupMenu jPopupMenu, Collection<PAction> collection, ActionUIScope actionUIScope) {
        jPopupMenu.removeAll();
        ArrayList<PAction> arrayList = null;
        for (PAction pAction : collection) {
            if (ActionUIUtilities.isIconButtonAction(pAction)) {
                if (arrayList == null) {
                    arrayList = new ArrayList<PAction>();
                }
                arrayList.add(pAction);
                continue;
            }
            jPopupMenu.add(ActionComponentFactory.createMenuItem(pAction, actionUIScope, null));
        }
        if (arrayList != null && !arrayList.isEmpty()) {
            if (jPopupMenu.getComponentCount() > 0) {
                jPopupMenu.add((Component)ActionComponentFactory.createSeparatorImpl(new SeparatorPAction()), 0);
                jPopupMenu.add(Box.createVerticalStrut(GUI.getScaledDiagnosticInt((int)2)), 1);
            }
            jPopupMenu.add((Component)ActionComponentFactory.createButtonPopupMenuPanel(jPopupMenu, arrayList, 1, 5, actionUIScope), 0);
        }
    }

    private static void buildMenu(JPopupMenu jPopupMenu, PAction pAction, ActionUIScope actionUIScope) {
        jPopupMenu.removeAll();
        ArrayList<PAction> arrayList = null;
        PAction[] pActionArray = pAction.getSubactions();
        int n = pActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PAction pAction2 = pActionArray[n2];
            if (ActionUIUtilities.isIconButtonAction(pAction2)) {
                if (arrayList == null) {
                    arrayList = new ArrayList<PAction>();
                }
                arrayList.add(pAction2);
            } else {
                jPopupMenu.add(ActionComponentFactory.createSubMenuItem(pAction, pAction2, actionUIScope));
            }
            ++n2;
        }
        if (arrayList != null && !arrayList.isEmpty()) {
            if (jPopupMenu.getComponentCount() > 0) {
                jPopupMenu.add((Component)ActionComponentFactory.createSeparatorImpl(new SeparatorPAction()), 0);
                jPopupMenu.add(Box.createVerticalStrut(GUI.getScaledDiagnosticInt((int)2)), 1);
            }
            jPopupMenu.add((Component)ActionComponentFactory.createButtonPopupMenuPanel(jPopupMenu, arrayList, 3, 5, actionUIScope), 0);
        }
    }

    private static class DensityLabel
    extends MultiMonitorLabel {
        private boolean disableValidate = false;

        DensityLabel() {
            ComponentFactory.instance.scaleFont(this);
        }

        @Override
        public void setText(String string) {
            try {
                String string2 = this.padSpaces(string, 8);
                String string3 = this.getText();
                int n = string3 != null && this.getGraphics() != null ? this.getGraphics().getFontMetrics().charsWidth(string3.toCharArray(), 0, string3.length()) : -1;
                int n2 = string2 != null && this.getGraphics() != null ? this.getGraphics().getFontMetrics().charsWidth(string2.toCharArray(), 0, string2.length()) : -1;
                this.disableValidate = n == n2;
                super.setText(string2);
            }
            finally {
                this.disableValidate = false;
            }
        }

        @Override
        public void revalidate() {
            if (!this.disableValidate) {
                super.revalidate();
            }
        }

        private String padSpaces(String string, int n) {
            if (string != null && string.length() < n) {
                int n2;
                int n3 = n2 = n - string.length();
                StringBuilder stringBuilder = new StringBuilder(n);
                int n4 = 0;
                while (n4 < n3) {
                    stringBuilder.append(' ');
                    ++n4;
                }
                stringBuilder.append(string);
                return stringBuilder.toString();
            }
            return string;
        }
    }
}

