/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.util.ComponentUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.ImpaxEEUtils;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionRegistry;
import com.agfa.pacs.impaxee.actions.ui.ActionUIScope;
import com.agfa.pacs.impaxee.actions.ui.config.ActionConfigPanel;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.toptoolbar.TopToolbarConfigModel;
import com.agfa.pacs.impaxee.vismenu.VisMenuButtonsConfigModel;
import com.agfa.pacs.impaxee.vismenu.VisMenuItemsConfigModel;
import com.agfa.pacs.impaxee.vistoolbar.VisDisplayToolbarConfigModel;
import com.agfa.pacs.listtext.swingx.controls.MessageDialog;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.security.permission.Permissions;
import com.tiani.jvision.main.JVision2;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ActionUIUtilities {
    private static final ALogger log = ALogger.getLogger(ActionUIUtilities.class);
    private static final byte[] KEY;

    static {
        byte[] byArray = new byte[8];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        KEY = byArray;
    }

    public static final <C extends JComponent> Component getActionUIContext(C c) {
        return c;
    }

    public static final boolean hasSubActions(PAction pAction) {
        PAction[] pActionArray = pAction.getSubactions();
        return pActionArray != null && pActionArray.length > 0;
    }

    public static final boolean isExecutable(PAction pAction) {
        return PAction.ActionType.None == pAction.getActionType();
    }

    public static void removeActionByID(List<PAction> list, String string) {
        if (list != null && string != null) {
            Iterator<PAction> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().getID();
                int n = string2.indexOf(64);
                if (n > 0) {
                    string2 = string2.substring(0, n);
                }
                if (!string2.equals(string)) continue;
                iterator.remove();
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean isSubAction(PAction pAction) {
        List<PAction> list = PActionRegistry.getAllActions(null);
        if (list != null) {
            for (PAction pAction2 : list) {
                try {
                    PAction[] pActionArray = pAction2.getSubactions();
                    if (pActionArray == null || pActionArray.length <= 0) continue;
                    PAction[] pActionArray2 = pActionArray;
                    int n = pActionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PAction pAction3 = pActionArray2[n2];
                        if (pAction3.equals(pAction)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static final String getActionConfigText(PAction pAction) {
        String string = pAction.getName();
        if (string == null) {
            string = pAction.getID();
        }
        return string;
    }

    public static final void showActionConfigDialog(ActionUIScope actionUIScope) {
        TopToolbarConfigModel topToolbarConfigModel = TopToolbarConfigModel.createDefaultTopToolbarRuntimeInstance();
        VisMenuItemsConfigModel visMenuItemsConfigModel = VisMenuItemsConfigModel.createRuntimeInstance();
        VisMenuButtonsConfigModel visMenuButtonsConfigModel = VisMenuButtonsConfigModel.createRuntimeInstance();
        VisDisplayToolbarConfigModel visDisplayToolbarConfigModel = VisDisplayToolbarConfigModel.createRuntimeInstance();
        ActionConfigPanel actionConfigPanel = new ActionConfigPanel(topToolbarConfigModel, visMenuItemsConfigModel, visMenuButtonsConfigModel, visDisplayToolbarConfigModel, actionUIScope);
        MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)JVision2.getMainFrame(), (String)Messages.getString("ActionConfigDialog.Title"), (Object)actionConfigPanel, (boolean)true, (int)3, (String)"OK_CANCEL_OPTION", (boolean)false, (IComponentFactory)ComponentFactory.instance);
        messageDialog.setSize(GUI.getScaledDiagnosticInt((int)880), GUI.getScaledDiagnosticInt((int)800));
        String string = ImpaxEEUtils.showMessageDialogCenteredInWindow(messageDialog);
        if ("OK_OPTION".equals(string)) {
            try {
                boolean bl = topToolbarConfigModel.modified();
                topToolbarConfigModel.save();
                visMenuItemsConfigModel.save();
                visMenuButtonsConfigModel.save();
                visDisplayToolbarConfigModel.save();
                if (bl) {
                    JVision2.getMainFrame().getTopToolbar().repaint();
                }
            }
            catch (Exception exception) {
                log.error("Saving action-config changes failed!", (Throwable)exception);
            }
        }
    }

    public static final PAction findActionWithId(Collection<? extends PAction> collection, String string) {
        if (collection != null) {
            for (PAction pAction : collection) {
                if (!string.equals(pAction.getID())) continue;
                return pAction;
            }
        }
        return null;
    }

    public static final Map<Component, PAction> createComponentActionMap(Container container, Collection<PAction> collection) {
        HashMap<Component, PAction> hashMap = new HashMap<Component, PAction>();
        if (container.getComponentCount() > 0) {
            Component[] componentArray = container.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                String string = ComponentUtil.getComponentID((Component)component);
                if (string != null) {
                    PAction pAction = ActionUIUtilities.findActionWithId(collection, string);
                    if (pAction != null) {
                        hashMap.put(component, pAction);
                    }
                } else if (component instanceof Container) {
                    hashMap.putAll(ActionUIUtilities.createComponentActionMap((Container)component, collection));
                }
                ++n2;
            }
        }
        return hashMap;
    }

    public static boolean isIconButtonAction(PAction pAction) {
        return ActionUIUtilities.isExecutable(pAction) && pAction.hasIcon();
    }

    public static void writeToFile(File file, String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        CDATASection cDATASection = document.createCDATASection(string);
        Element element = document.createElement("content");
        element.appendChild(cDATASection);
        Element element2 = document.createElement("signature");
        element2.setTextContent(Base64.getEncoder().encodeToString(ActionUIUtilities.encrypt(MessageDigest.getInstance("MD5").digest(string.getBytes(StandardCharsets.UTF_8)))));
        Element element3 = document.createElement("root");
        element3.appendChild(element);
        element3.appendChild(element2);
        document.appendChild(element3);
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(file.toURI().getPath());
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(dOMSource, streamResult);
    }

    public static Document readFromFile(File file) throws IllegalFormatModificationException, Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        NodeList nodeList = document.getElementsByTagName("content");
        String string = ((CDATASection)nodeList.item(0).getFirstChild()).getData();
        NodeList nodeList2 = document.getElementsByTagName("signature");
        byte[] byArray = ActionUIUtilities.decrypt(Base64.getDecoder().decode(new String(((Element)nodeList2.item(0)).getTextContent().getBytes(StandardCharsets.UTF_8))));
        byte[] byArray2 = MessageDigest.getInstance("MD5").digest(string.getBytes(StandardCharsets.UTF_8));
        if (byArray != null && Objects.deepEquals(byArray2, byArray)) {
            return documentBuilder.parse(new InputSource(new StringReader(string)));
        }
        throw new IllegalFormatModificationException();
    }

    private static final byte[] encrypt(byte[] byArray) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(KEY, "DES");
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(1, secretKeySpec);
        return cipher.doFinal(byArray);
    }

    private static final byte[] decrypt(byte[] byArray) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(KEY, "DES");
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, secretKeySpec);
        return cipher.doFinal(byArray);
    }

    public static File getSettingsFile(boolean bl, Component component) {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file != null && (file.isDirectory() || file.getName().endsWith(".xml"));
            }

            @Override
            public String getDescription() {
                return "*.xml";
            }
        });
        int n2 = n = bl ? jFileChooser.showOpenDialog(component) : jFileChooser.showSaveDialog(component);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!bl && !file.getName().endsWith(".xml")) {
                file = new File(String.valueOf(file.getAbsolutePath()) + ".xml");
            }
            return file;
        }
        return null;
    }

    public static enum ActionPermission {
        ConfigureTools("ImageArea/ConfigureTools");

        private String path;

        private ActionPermission(String string2) {
            this.path = string2;
        }

        public boolean checkForCurrentUser() {
            return Permissions.getInstance().isAllowed(this.path);
        }
    }

    public static class IllegalFormatModificationException
    extends Exception {
    }
}

