/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionListener;
import com.agfa.pacs.impaxee.actions.impl.AbstractPDataAction;
import com.agfa.pacs.impaxee.actions.ui.AbstractActionUI;
import com.agfa.pacs.impaxee.actions.ui.ActionUIScope;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import com.agfa.pacs.listtext.swingx.util.ScaledIconWrapper;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;

public class ButtonActionUI
extends AbstractActionUI<AbstractButton> {
    private PActionListener actionListener;
    private ActionListener buttonListener;
    private boolean prefSizeSet = false;
    private final boolean isActionListener;

    public ButtonActionUI(PAction pAction, AbstractButton abstractButton, ActionUIScope actionUIScope) {
        this(pAction, abstractButton, actionUIScope, true);
    }

    ButtonActionUI(PAction pAction, AbstractButton abstractButton, ActionUIScope actionUIScope, boolean bl) {
        super(pAction, abstractButton, actionUIScope);
        this.isActionListener = bl;
        assert (ActionUIUtilities.isExecutable(pAction)) : "create button-action-ui error: action is not executable!";
        this.bind();
    }

    public static void adjustNimbusSize(AbstractButton abstractButton) {
        Dimension dimension = abstractButton.getPreferredSize();
        dimension.width += 6;
        dimension.height += 8;
        abstractButton.setPreferredSize(dimension);
    }

    @Override
    public void bind() {
        super.bind();
        if (this.shouldAdjustNimbusSize()) {
            ButtonActionUI.adjustNimbusSize((AbstractButton)this.getComponent());
            this.prefSizeSet = true;
        }
    }

    @Override
    public void release() {
        if (this.prefSizeSet) {
            ((AbstractButton)this.getComponent()).setPreferredSize(null);
            this.prefSizeSet = false;
        }
        super.release();
    }

    @Override
    protected void updateComponent(PAction pAction, AbstractButton abstractButton, ActionUIScope actionUIScope) {
        this.updateComponent(pAction, abstractButton, actionUIScope, true, true);
    }

    @Override
    protected void registerListeners(PAction pAction, AbstractButton abstractButton) {
        if (this.isActionListener) {
            if (this.actionListener == null) {
                this.actionListener = this.createActionListener();
            }
            pAction.addListener(this.actionListener);
        }
        if (this.buttonListener == null) {
            this.buttonListener = this.createButtonListener();
        }
        abstractButton.addActionListener(this.buttonListener);
    }

    @Override
    protected void unregisterListeners(PAction pAction, AbstractButton abstractButton) {
        if (this.actionListener != null) {
            pAction.removeListener(this.actionListener);
        }
        if (this.buttonListener != null) {
            abstractButton.removeActionListener(this.buttonListener);
        }
    }

    protected PActionListener createActionListener() {
        return new DefaultActionListener();
    }

    protected ActionListener createButtonListener() {
        return new DefaultButtonListener();
    }

    private void updateComponent(PAction pAction, AbstractButton abstractButton, ActionUIScope actionUIScope, boolean bl, boolean bl2) {
        super.updateComponent(pAction, abstractButton, actionUIScope);
        if (bl) {
            String string = null;
            if (ActionUIScope.VisMenu == actionUIScope) {
                if (abstractButton instanceof JMenuItem) {
                    string = abstractButton.getParent() == null ? pAction.getName() : pAction.getCaption();
                    abstractButton.setToolTipText(null);
                }
            } else if (!pAction.hasIcon()) {
                string = pAction.getCaption();
            }
            abstractButton.setText(string);
        }
        if (bl2) {
            abstractButton.setRolloverEnabled(true);
            abstractButton.setBorderPainted(false);
            abstractButton.setFocusable(false);
            abstractButton.setSelected(pAction.isSelected());
            if (abstractButton instanceof JMenuItem && ActionUIScope.VisMenu.equals((Object)actionUIScope)) {
                abstractButton.setIcon(null);
                abstractButton.setDisabledIcon(null);
                abstractButton.setRolloverIcon(null);
                abstractButton.setRolloverSelectedIcon(null);
            } else {
                boolean bl3 = actionUIScope == ActionUIScope.VisMenu || actionUIScope == ActionUIScope.Other;
                Icon icon = pAction.getIcon(bl3);
                Icon icon2 = pAction.getPopupIcon(bl3);
                Icon icon3 = pAction.getDisabledIcon(bl3);
                abstractButton.setIcon(this.getIconForButton(icon, abstractButton, actionUIScope));
                abstractButton.setDisabledIcon(this.getIconForButton(icon3, abstractButton, actionUIScope));
                abstractButton.setRolloverIcon(this.getIconForButton(icon2, abstractButton, actionUIScope));
                abstractButton.setRolloverSelectedIcon(this.getIconForButton(icon2, abstractButton, actionUIScope));
            }
        }
    }

    private Icon getIconForButton(Icon icon, AbstractButton abstractButton, ActionUIScope actionUIScope) {
        return ActionUIScope.DisplayToolbar.equals((Object)actionUIScope) && abstractButton.getComponentPopupMenu() == null && icon != null ? new ScaledIconWrapper(icon, (JComponent)abstractButton) : icon;
    }

    private boolean shouldAdjustNimbusSize() {
        String string;
        if (ActionUIScope.TopToolbar.equals((Object)this.getScope()) && ("MINIMIZE".equals(string = this.getAction().getID()) || "EXIT".equals(string) || "NEXT_SERIE".equals(string) || "PREVIOUS_SERIE".equals(string) || "NEXT_PATIENT".equals(string) || "PREVIOUS_PATIENT".equals(string))) {
            return false;
        }
        string = ((AbstractButton)this.getComponent()).getText();
        return string == null || string.length() == 0 || !ActionUIScope.VisMenu.equals((Object)this.getScope());
    }

    private class DefaultActionListener
    implements PActionListener {
        private DefaultActionListener() {
        }

        @Override
        public void enabledStateChanged(boolean bl) {
            ((AbstractButton)ButtonActionUI.this.getComponent()).setEnabled(bl);
        }

        @Override
        public void selectionStateChanged(boolean bl) {
            ((AbstractButton)ButtonActionUI.this.getComponent()).setSelected(bl);
        }

        @Override
        public void contentChanged(String string, String string2, boolean bl) {
            ButtonActionUI.this.updateComponent(ButtonActionUI.this.getAction(), (AbstractButton)ButtonActionUI.this.getComponent(), ButtonActionUI.this.getScope(), !ButtonActionUI.this.getScope().equals((Object)ActionUIScope.VisMenu), bl);
        }
    }

    private class DefaultButtonListener
    implements ActionListener {
        private DefaultButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isPopupMenuButton((AbstractButton)ButtonActionUI.this.getComponent()) && ActionUIScope.TopToolbar.equals((Object)ButtonActionUI.this.getScope())) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
            ButtonActionUI.this.getAction().perform(ActionUIUtilities.getActionUIContext((AbstractButton)ButtonActionUI.this.getComponent()));
            if (ActionUIScope.VisMenu == ButtonActionUI.this.getScope() && AbstractPDataAction.getCurrentDisplay() != null) {
                AbstractPDataAction.getCurrentDisplay().repaint();
            }
        }

        private boolean isPopupMenuButton(AbstractButton abstractButton) {
            Container container = abstractButton.getParent();
            while (container != null) {
                if (container instanceof JPopupMenu) {
                    return true;
                }
                container = container.getParent();
            }
            return false;
        }
    }
}

