/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui;

import com.agfa.pacs.impaxee.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;

public class ButtonPopupMenuPanel
extends JPanel
implements MenuElement {
    private ButtonPanel buttonPanel;

    private ButtonPopupMenuPanel(JPopupMenu jPopupMenu, Collection<AbstractButton> collection, int n, int n2) {
        super(new BorderLayout(0, 0));
        this.buttonPanel = new ButtonPanel(collection, n, n2);
        this.setBorder(ComponentFactory.instance.createEmptyBorder(2));
        this.setComponentPopupMenu(jPopupMenu);
        this.add((Component)this.buttonPanel, "West");
    }

    private ButtonPopupMenuPanel(JPopupMenu jPopupMenu, Collection<AbstractButton> collection, int n) {
        super(new BorderLayout(0, 0));
        this.buttonPanel = new ButtonPanel(collection, n);
        this.setOpaque(false);
        this.setBorder(ComponentFactory.instance.createEmptyBorder(2));
        this.setComponentPopupMenu(jPopupMenu);
        this.add((Component)this.buttonPanel, "West");
    }

    public static ButtonPopupMenuPanel create(JPopupMenu jPopupMenu, Collection<AbstractButton> collection, int n, int n2) {
        return new ButtonPopupMenuPanel(jPopupMenu, collection, n, n2);
    }

    public static ButtonPopupMenuPanel create(JPopupMenu jPopupMenu, Collection<AbstractButton> collection, int n) {
        return new ButtonPopupMenuPanel(jPopupMenu, collection, n);
    }

    public Collection<AbstractButton> getButtons() {
        return this.buttonPanel.getButtons();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public MenuElement[] getSubElements() {
        return new MenuElement[]{this.buttonPanel};
    }

    @Override
    public void menuSelectionChanged(boolean bl) {
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    private static class ButtonPanel
    extends JPanel
    implements MenuElement {
        private Map<AbstractButton, MenuElement> menuMap;
        private MenuVisibilityHandler menuVisibilityHandler;
        private int maxWidth = -1;

        public ButtonPanel(Collection<AbstractButton> collection, int n, int n2) {
            super(ButtonPanel.createLayout(collection != null ? collection.size() : 0, n, n2));
            this.init(collection);
        }

        public ButtonPanel(Collection<AbstractButton> collection, int n) {
            super(ButtonPanel.createLayout(n));
            this.maxWidth = n;
            this.init(collection);
        }

        public Collection<AbstractButton> getButtons() {
            return this.menuMap.keySet();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (this.getLayout() instanceof FlowLayout && dimension.width > this.maxWidth) {
                int n = (int)Math.ceil((double)dimension.width / (double)this.maxWidth);
                dimension.width = this.maxWidth;
                dimension.height *= n;
            }
            return dimension;
        }

        @Override
        public Component getComponent() {
            return this;
        }

        @Override
        public MenuElement[] getSubElements() {
            return this.menuMap.values().toArray(new MenuElement[0]);
        }

        @Override
        public void menuSelectionChanged(boolean bl) {
        }

        @Override
        public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        }

        @Override
        public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        }

        private void init(Collection<AbstractButton> collection) {
            this.menuMap = new LinkedHashMap<AbstractButton, MenuElement>();
            this.menuVisibilityHandler = new MenuVisibilityHandler();
            this.setOpaque(false);
            this.setInheritsPopupMenu(true);
            if (collection != null) {
                for (AbstractButton abstractButton : collection) {
                    this.menuMap.put(abstractButton, ButtonPanel.createMenuElement(abstractButton));
                    this.prepareButton(abstractButton);
                    this.add(abstractButton);
                }
            }
        }

        private void prepareButton(AbstractButton abstractButton) {
            abstractButton.setText(null);
            abstractButton.setInheritsPopupMenu(true);
            abstractButton.addMouseListener(this.menuVisibilityHandler);
            abstractButton.addActionListener(this.menuVisibilityHandler);
        }

        private static GridLayout createLayout(int n, int n2, int n3) {
            int n4;
            int n5 = n <= n2 ? 1 : (n4 = n <= n3 ? n : n3);
            int n6 = n <= n2 ? n : (n <= n4 ? 1 : (int)Math.ceil((double)n / (double)n4));
            return new GridLayout(n6, n4, 2, 2);
        }

        private static FlowLayout createLayout(int n) {
            return new FlowLayout(0, 2, 2);
        }

        private static MenuElement createMenuElement(final AbstractButton abstractButton) {
            return new MenuElement(){

                @Override
                public Component getComponent() {
                    return abstractButton;
                }

                @Override
                public MenuElement[] getSubElements() {
                    return new MenuElement[0];
                }

                @Override
                public void menuSelectionChanged(boolean bl) {
                    ButtonModel buttonModel = abstractButton.getModel();
                    if (buttonModel.isArmed() != bl) {
                        buttonModel.setArmed(bl);
                    }
                }

                @Override
                public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
                }

                @Override
                public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
                }
            };
        }
    }

    private static class MenuVisibilityHandler
    extends MouseAdapter
    implements ActionListener {
        private MenuVisibilityHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getComponent();
            JPopupMenu jPopupMenu = abstractButton.getComponentPopupMenu();
            MenuSelectionManager.defaultManager().setSelectedPath(new MenuElement[]{jPopupMenu});
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
    }
}

