/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui;

import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.PActionListener;
import com.agfa.pacs.impaxee.actions.ui.AbstractParentActionUI;
import com.agfa.pacs.impaxee.actions.ui.ActionUIScope;
import com.agfa.pacs.impaxee.actions.ui.ActionUIUtilities;
import javax.swing.JMenu;

public class MenuActionUI
extends AbstractParentActionUI<JMenu> {
    private PActionListener actionListener;

    public MenuActionUI(PAction pAction, JMenu jMenu, ActionUIScope actionUIScope) {
        super(pAction, jMenu, actionUIScope);
        assert (!ActionUIUtilities.isExecutable(pAction)) : "create menu-action-ui error: action is executable!";
        this.bind();
    }

    @Override
    protected void updateComponent(PAction pAction, JMenu jMenu, ActionUIScope actionUIScope) {
        super.updateComponent(pAction, jMenu, actionUIScope);
        if (jMenu.getParent() == null) {
            jMenu.setText(pAction.getName());
        } else {
            jMenu.setText(pAction.getCaption());
        }
        if (actionUIScope == ActionUIScope.VisMenu) {
            jMenu.setIcon(null);
            jMenu.setDisabledIcon(null);
        } else {
            jMenu.setIcon(pAction.getIcon(true));
            jMenu.setDisabledIcon(pAction.getDisabledIcon(true));
        }
    }

    @Override
    protected void registerListeners(PAction pAction, JMenu jMenu) {
        if (this.actionListener == null) {
            this.actionListener = this.createActionListener();
        }
        pAction.addListener(this.actionListener);
    }

    @Override
    protected void unregisterListeners(PAction pAction, JMenu jMenu) {
        if (this.actionListener != null) {
            pAction.removeListener(this.actionListener);
        }
    }

    protected PActionListener createActionListener() {
        return new DefaultActionListener();
    }

    private class DefaultActionListener
    implements PActionListener {
        private DefaultActionListener() {
        }

        @Override
        public void enabledStateChanged(boolean bl) {
            ((JMenu)MenuActionUI.this.getComponent()).setEnabled(bl);
        }

        @Override
        public void selectionStateChanged(boolean bl) {
        }

        @Override
        public void contentChanged(String string, String string2, boolean bl) {
            MenuActionUI.this.updateComponent();
        }
    }
}

