/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui;

import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.actions.PActionIcon;
import com.agfa.pacs.impaxee.actions.impl.PActionIconFactory;
import com.agfa.pacs.impaxee.data.manager.DataManager;
import com.agfa.pacs.impaxee.data.manager.DisplaySetListenerAdapter;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.hanging.IDisplaySet;
import com.agfa.pacs.impaxee.hanging.IHanging;
import com.agfa.pacs.impaxee.hanging.IHangingSession;
import com.agfa.pacs.impaxee.hanging.IPatientRepresentation;
import com.agfa.pacs.impaxee.hanging.OnlyOneStudyManager;
import com.agfa.pacs.impaxee.hanging.StudyType;
import com.agfa.pacs.impaxee.splitsort.SplitAndSortChangeType;
import com.agfa.pacs.impaxee.utils.GuiUtil;
import com.agfa.pacs.impaxee.utils.NavigationDirection;
import com.agfa.pacs.listtext.swingx.controls.DropDownBox;
import com.agfa.pacs.tools.CompareUtils;
import com.tiani.base.data.IStudyData;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorButton;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorPanel;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorToggleButton;
import com.tiani.jvision.main.JVision2;
import com.tiani.jvision.overlay.demographics.PriorStudyColoring;
import com.tiani.jvision.patinfo.DataSelectionListenerAdapter;
import com.tiani.jvision.patinfo.DataSelectionManager;
import com.tiani.jvision.patinfo.studies.StudyTextHelper;
import com.tiani.jvision.vis.VisScreen2;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang3.ArrayUtils;

public class OnlyOneStudyChooser
extends MultiMonitorPanel {
    private static final String ROLLOVER_ICON = "ROLLOVER_ICON";
    private static final String DISABLED_ICON = "DISABLED_ICON";
    private final VisScreen2 screen;
    private PrevStudyAction prevStudyAction;
    private NextStudyAction nextStudyAction;
    private StudyListPopup studiesPopup;
    private StudyListModel studiesModel;
    private DropDownBox activationBox;

    protected OnlyOneStudyChooser(VisScreen2 visScreen2, boolean bl) {
        this.screen = visScreen2;
        this.setupComponents(visScreen2, bl);
        this.initComponents();
    }

    public OnlyOneStudyChooser(VisScreen2 visScreen2) {
        this(visScreen2, true);
    }

    public boolean changeStudy(NavigationDirection navigationDirection) {
        AbstractNavigationAction abstractNavigationAction;
        switch (navigationDirection) {
            case PREV: {
                abstractNavigationAction = this.prevStudyAction;
                break;
            }
            case NEXT: {
                abstractNavigationAction = this.nextStudyAction;
                break;
            }
            default: {
                return false;
            }
        }
        abstractNavigationAction.perform();
        return true;
    }

    private void setupComponents(final VisScreen2 visScreen2, boolean bl) {
        JButton jButton;
        OnlyOneStudyManager onlyOneStudyManager = OnlyOneStudyManager.get();
        this.studiesModel = new StudyListModel();
        this.studiesPopup = new StudyListPopup(this.studiesModel, new StudyListSelectionListener());
        this.activationBox = OnlyOneStudyChooser.createDropDownBox(this.studiesPopup);
        this.prevStudyAction = new PrevStudyAction();
        this.nextStudyAction = new NextStudyAction();
        JButton jButton2 = bl ? OnlyOneStudyChooser.createButton(this.prevStudyAction) : null;
        JButton jButton3 = jButton = bl ? OnlyOneStudyChooser.createButton(this.nextStudyAction) : null;
        if (bl) {
            this.setLayout((LayoutManager)new TableLayout(new double[]{-2.0, -2.0, -2.0}, new double[]{-1.0}));
            this.add((Component)jButton2, "0,0");
            this.add((Component)this.activationBox, "1,0");
            this.add((Component)jButton, "2,0");
        } else {
            this.setLayout(new BorderLayout());
            this.add((Component)this.activationBox, "West");
        }
        onlyOneStudyManager.getListenerSupport().addListener((Object)new OnlyOneStudyManager.IOnlyOneStudyManagerListener(){

            @Override
            public void stateChanged() {
                OnlyOneStudyChooser.this.initComponents();
            }
        });
        this.activationBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OnlyOneStudyChooser.this.toggleActivation();
            }
        });
        DataManager.getInstance().addDisplaySetListener(new DisplaySetListenerAdapter(){

            @Override
            public void displaySetAdded(IPatientRepresentation iPatientRepresentation, List<IDisplaySet> list, SplitAndSortChangeType splitAndSortChangeType) {
                this.updateStudiesIfNeeded(list, true);
            }

            @Override
            public void displaySetsRemoved(IDisplaySet[] iDisplaySetArray, SplitAndSortChangeType splitAndSortChangeType) {
                if (iDisplaySetArray != null) {
                    this.updateStudiesIfNeeded(Arrays.asList(iDisplaySetArray), false);
                }
            }

            private void updateStudiesIfNeeded(List<IDisplaySet> list, boolean bl) {
                if (OnlyOneStudyManager.get().isActivatedOnScreen(visScreen2) && list != null) {
                    boolean bl2 = false;
                    for (IDisplaySet iDisplaySet : list) {
                        bl2 = bl ^ OnlyOneStudyChooser.this.studiesModel.hasStudy(iDisplaySet.getStudy());
                        if (bl2) break;
                    }
                    if (bl2) {
                        OnlyOneStudyChooser.this.initComponents();
                    }
                }
            }
        });
        DataSelectionManager.getInstance().addListener(new DataSelectionListenerAdapter(){

            @Override
            public void newHangingCaseSelected(IPatientRepresentation iPatientRepresentation, IHanging iHanging, IHanging iHanging2, boolean bl) {
                if (OnlyOneStudyManager.get().isActivatedOnScreen(visScreen2)) {
                    OnlyOneStudyChooser.this.initComponents();
                }
            }
        });
    }

    private void initComponents() {
        OnlyOneStudyManager onlyOneStudyManager = OnlyOneStudyManager.get();
        boolean bl = onlyOneStudyManager.isActivatedOnScreen(this.screen);
        this.activationBox.setSelected(bl);
        if (bl) {
            this.studiesModel.init(OnlyOneStudyManager.getAllStudiesForScreen(this.screen), onlyOneStudyManager.getAllowedStudyUIDOnScreen(this.screen));
        } else {
            this.studiesModel.init(new IStudyData[0], null);
        }
        boolean bl2 = DataSelectionManager.getInstance().getActiveHanging() instanceof IHangingSession;
        if (bl && this.studiesModel.hasStudies()) {
            this.activationBox.setDropDownEnabled(!bl2);
        } else {
            this.activationBox.setDropDownEnabled(false);
        }
        if (this.prevStudyAction != null) {
            this.prevStudyAction.setEnabled(bl && this.studiesModel.hasPrevStudy() && !bl2);
        }
        if (this.nextStudyAction != null) {
            this.nextStudyAction.setEnabled(bl && this.studiesModel.hasNextStudy() && !bl2);
        }
    }

    private static DropDownBox createDropDownBox(JPopupMenu jPopupMenu) {
        PActionIcon pActionIcon = OnlyOneStudyChooser.createActionIcon("only_one_study.svg");
        DropDownBox dropDownBox = new DropDownBox(null, pActionIcon.getIcon(false), jPopupMenu, DropDownBox.Orientation.bottom, true){

            protected JToggleButton createItemToggleButton() {
                MultiMonitorToggleButton multiMonitorToggleButton = ComponentFactory.instance.createMultiMonitorToggleButton((String)null);
                multiMonitorToggleButton.setName("ImageAreaToggleButton");
                multiMonitorToggleButton.setBorderPainted(false);
                multiMonitorToggleButton.setFocusable(false);
                multiMonitorToggleButton.setRolloverEnabled(true);
                multiMonitorToggleButton.setSelected(false);
                return multiMonitorToggleButton;
            }

            protected JButton createArrowButton() {
                JButton jButton = super.createArrowButton();
                jButton.setBorder(BorderFactory.createEmptyBorder(0, GUI.getScaledDiagnosticInt((int)5), 0, 4));
                jButton.setPreferredSize(new Dimension(GUI.getScaledDiagnosticInt((int)17), 9));
                return jButton;
            }
        };
        dropDownBox.setDisabledIcon(pActionIcon.getDisabledIcon(false));
        dropDownBox.setRolloverIcon(pActionIcon.getPopupIcon(false));
        dropDownBox.setToolTipText(Messages.getString("OnlyOneStudyChooser.ActivationBtn.ToolTipText"));
        Dimension dimension = dropDownBox.getPreferredSize();
        dimension.width += 14;
        dimension.height += 8;
        dropDownBox.setPreferredSize(dimension);
        return dropDownBox;
    }

    public void toggleActivation() {
        try {
            CursorUtil.setWaitCursor((Component)JVision2.getMainFrame());
            OnlyOneStudyManager onlyOneStudyManager = OnlyOneStudyManager.get();
            if (onlyOneStudyManager.isActivatedOnScreen(this.screen)) {
                onlyOneStudyManager.deactivateOnScreen(this.screen);
            } else if (onlyOneStudyManager.activateOnScreen(this.screen, OnlyOneStudyManager.getDefaultStudyForScreen(this.screen))) {
                onlyOneStudyManager.purgeScreen(this.screen);
            }
        }
        finally {
            CursorUtil.resetWaitCursor((Component)JVision2.getMainFrame());
        }
    }

    public int getStudyCount() {
        return this.studiesModel.getSize();
    }

    public void setSelectedIndex(int n) {
        this.studiesPopup.list.setSelectedIndex(n);
    }

    private static JButton createButton(Action action) {
        MultiMonitorButton multiMonitorButton = ComponentFactory.instance.createMultiMonitorButton((String)null);
        multiMonitorButton.setName("ImageAreaButton");
        multiMonitorButton.setAction(action);
        multiMonitorButton.setRolloverEnabled(true);
        multiMonitorButton.setBorderPainted(false);
        multiMonitorButton.setFocusable(false);
        multiMonitorButton.setRolloverIcon((Icon)action.getValue(ROLLOVER_ICON));
        multiMonitorButton.setDisabledIcon((Icon)action.getValue(DISABLED_ICON));
        return multiMonitorButton;
    }

    private static PActionIcon createActionIcon(String string) {
        return PActionIconFactory.getInstance().loadIcon(OnlyOneStudyChooser.class, string, null);
    }

    private abstract class AbstractNavigationAction
    extends AbstractAction {
        AbstractNavigationAction(String string, String string2) {
            PActionIcon pActionIcon = OnlyOneStudyChooser.createActionIcon(string);
            this.putValue("SmallIcon", pActionIcon.getIcon(false));
            this.putValue(OnlyOneStudyChooser.ROLLOVER_ICON, pActionIcon.getPopupIcon(false));
            this.putValue(OnlyOneStudyChooser.DISABLED_ICON, pActionIcon.getDisabledIcon(false));
            this.putValue("ShortDescription", string2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.perform();
        }

        abstract void perform();
    }

    private class NextStudyAction
    extends AbstractNavigationAction {
        NextStudyAction() {
            super("next_item.svg", Messages.getString("OnlyOneStudyChooser.NextStudyBtn.ToolTipText"));
        }

        @Override
        void perform() {
            try {
                IStudyData iStudyData;
                CursorUtil.setWaitCursor((Component)JVision2.getMainFrame());
                OnlyOneStudyManager onlyOneStudyManager = OnlyOneStudyManager.get();
                if (onlyOneStudyManager.isActivatedOnScreen(OnlyOneStudyChooser.this.screen) && (iStudyData = OnlyOneStudyChooser.this.studiesModel.getNextStudy()) != null && onlyOneStudyManager.activateOnScreen(OnlyOneStudyChooser.this.screen, iStudyData)) {
                    onlyOneStudyManager.refreshScreen(OnlyOneStudyChooser.this.screen);
                }
            }
            finally {
                CursorUtil.resetWaitCursor((Component)JVision2.getMainFrame());
            }
        }
    }

    private class PrevStudyAction
    extends AbstractNavigationAction {
        PrevStudyAction() {
            super("previous_item.svg", Messages.getString("OnlyOneStudyChooser.PrevStudyBtn.ToolTipText"));
        }

        @Override
        void perform() {
            try {
                IStudyData iStudyData;
                CursorUtil.setWaitCursor((Component)JVision2.getMainFrame());
                OnlyOneStudyManager onlyOneStudyManager = OnlyOneStudyManager.get();
                if (onlyOneStudyManager.isActivatedOnScreen(OnlyOneStudyChooser.this.screen) && (iStudyData = OnlyOneStudyChooser.this.studiesModel.getPrevStudy()) != null && onlyOneStudyManager.activateOnScreen(OnlyOneStudyChooser.this.screen, iStudyData)) {
                    onlyOneStudyManager.refreshScreen(OnlyOneStudyChooser.this.screen);
                }
            }
            finally {
                CursorUtil.resetWaitCursor((Component)JVision2.getMainFrame());
            }
        }
    }

    private static class StudyListModel
    extends AbstractListModel<IStudyData> {
        private IStudyData[] studies = new IStudyData[0];
        private ListSelectionModel selectionModel;
        private Map<IStudyData, StudyTextHelper> textHelper = new HashMap<IStudyData, StudyTextHelper>(8);

        public StudyListModel() {
            this.selectionModel = new DefaultListSelectionModel();
        }

        @Override
        public int getSize() {
            return this.studies.length == 0 ? 1 : this.studies.length;
        }

        @Override
        public IStudyData getElementAt(int n) {
            if (this.hasStudies()) {
                return this.studies[n];
            }
            return null;
        }

        public ListSelectionModel getSelectionModel() {
            return this.selectionModel;
        }

        public void init(IStudyData[] iStudyDataArray, String string) {
            this.studies = iStudyDataArray;
            this.fireContentsChanged(this, iStudyDataArray.length > 0 ? 0 : -1, iStudyDataArray.length);
            this.setSelectedStudy(string);
        }

        public boolean hasStudy(IStudyData iStudyData) {
            return ArrayUtils.contains((Object[])this.studies, (Object)iStudyData);
        }

        public boolean hasStudies() {
            return this.studies.length > 0;
        }

        public boolean hasPrevStudy() {
            return this.indexOfSelectedStudy() > 0;
        }

        public boolean hasNextStudy() {
            int n = this.indexOfSelectedStudy();
            return n >= 0 && n < this.studies.length - 1;
        }

        public IStudyData getPrevStudy() {
            int n = this.indexOfSelectedStudy();
            if (n > 0) {
                return this.studies[n - 1];
            }
            return null;
        }

        public IStudyData getNextStudy() {
            int n = this.indexOfSelectedStudy();
            if (n >= 0 && n < this.studies.length - 1) {
                return this.studies[n + 1];
            }
            return null;
        }

        public IStudyData getSelectedStudy() {
            int n = this.indexOfSelectedStudy();
            if (n >= 0 && n < this.studies.length) {
                return this.studies[n];
            }
            return null;
        }

        public void setSelectedStudy(String string) {
            int n = this.indexOfStudy(string);
            this.selectionModel.setSelectionInterval(n, n);
        }

        public boolean isStudySelected(IStudyData iStudyData) {
            int n = this.indexOfSelectedStudy();
            return n >= 0 && n < this.studies.length && iStudyData.equals(this.studies[n]);
        }

        public boolean isStudyActive(IStudyData iStudyData) {
            return CompareUtils.equals((Object)iStudyData.getStudyInstanceUID(), (Object)DataSelectionManager.getInstance().getActiveStudyUID());
        }

        public String getStudyHtmlText(IStudyData iStudyData, boolean bl, boolean bl2) {
            return this.getTextHelper(iStudyData).toHtmlString(bl, bl2);
        }

        private StudyTextHelper getTextHelper(IStudyData iStudyData) {
            StudyTextHelper studyTextHelper = this.textHelper.get(iStudyData);
            if (studyTextHelper == null) {
                studyTextHelper = StudyTextHelper.create(iStudyData);
            }
            return studyTextHelper;
        }

        private int indexOfSelectedStudy() {
            return this.selectionModel.getAnchorSelectionIndex();
        }

        private int indexOfStudy(String string) {
            if (this.studies != null && string != null) {
                int n = 0;
                while (n < this.studies.length) {
                    if (this.studies[n].getStudyInstanceUID().equals(string)) {
                        return n;
                    }
                    ++n;
                }
            }
            return -1;
        }
    }

    private static class StudyListPopup
    extends JPopupMenu {
        private final StudyListMouseHoverHandler mouseHoverHandler = new StudyListMouseHoverHandler();
        private final JList<IStudyData> list;
        private int rowMouseOver = -1;

        public StudyListPopup(final StudyListModel studyListModel, final StudySelectionListener studySelectionListener) {
            this.list = new JList<IStudyData>(studyListModel);
            ComponentFactory.instance.scaleFont(this.list);
            this.list.setSelectionModel(studyListModel.getSelectionModel());
            this.list.setCellRenderer(new StudyListCellRenderer());
            this.list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (studySelectionListener != null) {
                        studySelectionListener.studySelected(studyListModel.getSelectedStudy());
                    }
                }
            });
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n;
                    if (studySelectionListener != null && SwingUtilities.isLeftMouseButton(mouseEvent) && (n = list.locationToIndex(mouseEvent.getPoint())) >= 0 && n == list.getSelectedIndex()) {
                        studySelectionListener.studySelected((IStudyData)list.getModel().getElementAt(n));
                    }
                }
            });
            this.list.addMouseMotionListener(this.mouseHoverHandler);
            this.list.addMouseListener(this.mouseHoverHandler);
            this.addPopupMenuListener(this.mouseHoverHandler);
            this.add(this.list);
        }

        private class StudyListCellRenderer
        extends DefaultListCellRenderer {
            private final int SCALED_2 = GUI.getScaledDiagnosticInt((int)2);
            private final int SCALED_5 = GUI.getScaledDiagnosticInt((int)5);
            private final Border SPACING_BORDER = BorderFactory.createMatteBorder(this.SCALED_2, 1, this.SCALED_2, 0, UIManager.getColor("color.black"));
            private final Border DEFAULT_BORDER = this.createCellBorder(UIManager.getColor("color.primary.4"));
            private final Border PRIOR1_BORDER = this.createCellBorder(PriorStudyColoring.mappingColorPrior1);
            private final Border PRIORX_BORDER = this.createCellBorder(PriorStudyColoring.mappingColorPriorX);
            private final Border MERGED_BORDER = this.createCellBorder(PriorStudyColoring.mappingColorMergedStudies);

            private StudyListCellRenderer() {
            }

            private Border createCellBorder(Color color) {
                return BorderFactory.createCompoundBorder(this.SPACING_BORDER, BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, this.SCALED_5, 0, 0, color), BorderFactory.createEmptyBorder(0, this.SCALED_5, 0, this.SCALED_5)));
            }

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                boolean bl3;
                JLabel jLabel = (JLabel)super.getListCellRendererComponent(jList, object, n, bl, bl2);
                StudyListModel studyListModel = (StudyListModel)jList.getModel();
                IStudyData iStudyData = (IStudyData)object;
                boolean bl4 = studyListModel.isStudyActive(iStudyData);
                boolean bl5 = studyListModel.isStudySelected(iStudyData);
                boolean bl6 = bl3 = n >= 0 && n == StudyListPopup.this.rowMouseOver;
                if (n >= 0) {
                    jLabel.setText(studyListModel.getStudyHtmlText(iStudyData, bl4, bl3));
                }
                jLabel.setBorder(this.getCellBorder(iStudyData));
                jLabel.setOpaque(false);
                jLabel.setFont(jList.getFont());
                if (bl5) {
                    jLabel.setFont(jLabel.getFont().deriveFont(1));
                }
                return jLabel;
            }

            private Border getCellBorder(IStudyData iStudyData) {
                if (PriorStudyColoring.useDifferentColorsForPriors && GuiUtil.isOnColorMonitor()) {
                    StudyType studyType = StudyType.UNKNOWN;
                    IHanging iHanging = DataSelectionManager.getInstance().getActiveHanging();
                    if (iHanging != null && iHanging.getStudyContainer() != null) {
                        studyType = iHanging.getStudyContainer().getStudyType(iStudyData.getKey());
                    }
                    if (studyType != null && !studyType.equals((Object)StudyType.UNKNOWN)) {
                        switch (studyType) {
                            case BASE_STUDY: 
                            case UNKNOWN: {
                                return this.DEFAULT_BORDER;
                            }
                            case FIRST_PRIOR: {
                                return this.PRIOR1_BORDER;
                            }
                            case MERGED: {
                                return this.MERGED_BORDER;
                            }
                        }
                        return this.PRIORX_BORDER;
                    }
                }
                return this.SPACING_BORDER;
            }
        }

        private class StudyListMouseHoverHandler
        extends MouseAdapter
        implements PopupMenuListener {
            private StudyListMouseHoverHandler() {
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = StudyListPopup.this.rowMouseOver;
                StudyListPopup.this.rowMouseOver = ((JList)mouseEvent.getComponent()).locationToIndex(mouseEvent.getPoint());
                if (StudyListPopup.this.rowMouseOver != n) {
                    mouseEvent.getComponent().repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (StudyListPopup.this.rowMouseOver >= 0) {
                    StudyListPopup.this.rowMouseOver = -1;
                    mouseEvent.getComponent().repaint();
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                StudyListPopup.this.rowMouseOver = -1;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                StudyListPopup.this.rowMouseOver = -1;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        }
    }

    private class StudyListSelectionListener
    implements StudySelectionListener {
        private StudyListSelectionListener() {
        }

        @Override
        public void studySelected(IStudyData iStudyData) {
            try {
                CursorUtil.setWaitCursor((Component)JVision2.getMainFrame());
                OnlyOneStudyChooser.this.studiesPopup.setVisible(false);
                OnlyOneStudyManager onlyOneStudyManager = OnlyOneStudyManager.get();
                if (iStudyData != null) {
                    if (onlyOneStudyManager.activateOnScreen(OnlyOneStudyChooser.this.screen, iStudyData)) {
                        onlyOneStudyManager.refreshScreen(OnlyOneStudyChooser.this.screen);
                    }
                } else if (onlyOneStudyManager.deactivateOnScreen(OnlyOneStudyChooser.this.screen)) {
                    onlyOneStudyManager.purgeScreen(OnlyOneStudyChooser.this.screen);
                }
            }
            finally {
                CursorUtil.resetWaitCursor((Component)JVision2.getMainFrame());
            }
        }
    }

    private static interface StudySelectionListener {
        public void studySelected(IStudyData var1);
    }
}

