/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.actions.ui;

import com.agfa.pacs.base.swing.util.EventConst;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.impaxee.Messages;
import com.agfa.pacs.impaxee.config.Config;
import com.agfa.pacs.login.ILoginData;
import com.agfa.pacs.login.URLProviderFactory;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PatientInfoComponent
extends MultiMonitorPanel
implements MouseListener,
MouseMotionListener {
    private static final int MARGIN = GUI.getScaledDiagnosticInt((int)1);
    private static final int PADDING = GUI.getScaledDiagnosticInt((int)2);
    private static final ILoginData LOGIN_DATA = URLProviderFactory.getProvider().getLoginInformation();
    private static final String HIST = "HIST.";
    private static final String SHOW_LOADING_PROTOCOL = Messages.getString("PatientInfoComponent.ShowLoadingProtocol");
    private final Color HIST_TEXT_COLOR = new Color(167, 176, 193);
    private int xHistStart;
    private int yHistStart;
    private int width;
    private int height;
    private String originalToolTip = null;
    private String name = PatientInfoComponent.getSafeString(null);
    private String birthdate = PatientInfoComponent.getSafeString(null);
    private Icon icon;
    private Font nameFont;
    private Font dateFont;
    private Font auditLogFont;
    private FontMetrics nameFM;
    private FontMetrics dateFM;
    private FontMetrics auditLogFM;
    private int textPadding;

    public PatientInfoComponent() {
        super(true);
        if (!Product.isCDViewer()) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
        this.setOpaque(true);
        this.initComponent();
    }

    private static String getSafeString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private void initComponent() {
        this.setOpaque(false);
        this.setForeground(UIManager.getColor("Label.foreground"));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(MARGIN, 0, MARGIN, 0), BorderFactory.createLineBorder(UIManager.getColor("color.primary.2"))));
        this.initInternalFonts();
        this.initTextPadding();
    }

    public void setPatientInfo(String string, String string2, Icon icon) {
        this.name = PatientInfoComponent.getSafeString(string);
        this.birthdate = PatientInfoComponent.getSafeString(string2);
        this.icon = icon;
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.initInternalFonts();
    }

    private void initInternalFonts() {
        Font font = this.getFont();
        this.nameFont = font.deriveFont(1);
        this.dateFont = font.deriveFont((float)font.getSize() * 0.9f);
        this.auditLogFont = font.deriveFont((float)font.getSize() * 0.8f);
        this.nameFM = this.getFontMetrics(this.nameFont);
        this.dateFM = this.getFontMetrics(this.dateFont);
        this.auditLogFM = this.getFontMetrics(this.auditLogFont);
    }

    @Override
    @Deprecated
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.initTextPadding();
    }

    private void initTextPadding() {
        this.height = this.getHeight();
        if (this.height == 0) {
            return;
        }
        int n = this.nameFont.getSize() + this.dateFont.getSize();
        int n2 = (this.height - n - PADDING) / 3;
        int n3 = 2 * MARGIN + 1;
        int n4 = Math.max(n2, n3);
        this.textPadding = Math.max((this.height - n - n4) / 2, 0);
        this.textPadding = Math.min(this.textPadding, n4);
    }

    private void renderImage(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (!SHOW_LOADING_PROTOCOL.equals(this.getToolTipText())) {
            this.originalToolTip = this.getToolTipText();
        }
        this.width = this.getWidth();
        if (this.width == 0 || this.height == 0) {
            return;
        }
        if (this.icon == null) {
            n3 = 0;
            n2 = 0;
            n = 0;
        } else {
            n3 = this.icon.getIconWidth();
            n2 = this.icon.getIconHeight();
            n = 2 * PADDING;
        }
        int n4 = this.width - 2 * PADDING - n3 - n;
        int n5 = (this.height - 3 * PADDING) / 2;
        String string = this.getShortenedString(this.name, this.nameFM, n4, n5);
        String string2 = this.getShortenedString(this.birthdate, this.dateFM, n4, n5);
        n4 = Math.max(this.nameFM.stringWidth(string), this.dateFM.stringWidth(string2));
        int n6 = n3 + n + n4;
        int n7 = (this.width - n6) / 2;
        if (this.icon != null) {
            this.icon.paintIcon(this, graphics, n7, (this.height - n2) / 2);
            n7 += n3 + n;
        }
        int n8 = this.textPadding + this.nameFont.getSize();
        graphics.setFont(this.nameFont);
        graphics.drawString(string, n7, n8);
        graphics.setFont(this.dateFont);
        graphics.drawString(string2, n7, n8 += this.textPadding + this.dateFont.getSize());
        if (this.patientInfoDisplayed() && !Product.isCDViewer()) {
            int n9 = GUI.getScaledInt((int)3);
            int n10 = this.auditLogFM.stringWidth(HIST);
            int n11 = this.width - n10 - n9;
            int n12 = this.height - n9 * 2;
            this.xHistStart = n11;
            this.yHistStart = n12 - this.auditLogFM.getHeight();
            Color color = graphics.getColor();
            graphics.setFont(this.auditLogFont);
            graphics.setColor(this.HIST_TEXT_COLOR);
            graphics.drawString(HIST, n11, n12);
            graphics.setColor(color);
        }
    }

    private boolean patientInfoDisplayed() {
        return this.name != null && !this.name.isEmpty();
    }

    private String getShortenedString(String string, FontMetrics fontMetrics, int n, int n2) {
        return SwingUtilities.layoutCompoundLabel(this, fontMetrics, string, null, 0, 0, 0, 0, new Rectangle(0, 0, n, n2), new Rectangle(0, 0, 0, 0), new Rectangle(0, 0, 0, 0), 0);
    }

    @Override
    public void paint(Graphics graphics) {
        this.renderImage(graphics);
        super.paint(graphics);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.patientInfoDisplayed() && !Product.isCDViewer()) {
            int[] nArray = new int[]{110103};
            String string = null;
            String string2 = null;
            if (Config.impaxee.jvision.MAIN.Audit.UseCurrentUser.get()) {
                string = LOGIN_DATA.getUserID();
                string2 = LOGIN_DATA.getPassword();
            } else {
                string = Config.impaxee.jvision.MAIN.Audit.DefaultUser.get();
                string2 = Config.impaxee.jvision.MAIN.Audit.DefaultPassword.get();
            }
            IEventEngine iEventEngine = EventEngineFactory.getInstance();
            IEvent iEvent = iEventEngine.createEvent(EventConst.OPEN_AUDIT_LOG_DIALOG_EVENT_ID);
            iEvent.setPayload((Object)new EventConst.OpenAuditLogPayload(string, string2, true, nArray));
            iEvent.setDestination(null, "lta.listarea.auditlog.open");
            iEventEngine.sendEvent(iEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.patientInfoDisplayed()) {
            this.setToolTipText(null);
            return;
        }
        if (this.xHistStart > 0 && mouseEvent.getX() > this.xHistStart && mouseEvent.getX() < this.width && mouseEvent.getY() > this.yHistStart && mouseEvent.getY() < this.height) {
            this.setToolTipText(SHOW_LOADING_PROTOCOL);
        } else if (this.originalToolTip != null && !this.originalToolTip.isEmpty()) {
            this.setToolTipText(this.originalToolTip);
        }
    }
}

